/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.ContainerEntrypointCopier;
import software.amazon.awssdk.services.sagemaker.model.MonitoringContainerArgumentsCopier;
import software.amazon.awssdk.services.sagemaker.model.MonitoringEnvironmentMapCopier;
import software.amazon.awssdk.services.sagemaker.model.MonitoringProblemType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelQualityAppSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelQualityAppSpecification> {
    private static final SdkField<String> IMAGE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ImageUri").getter(ModelQualityAppSpecification.getter(ModelQualityAppSpecification::imageUri)).setter(ModelQualityAppSpecification.setter(Builder::imageUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageUri").build()}).build();
    private static final SdkField<List<String>> CONTAINER_ENTRYPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerEntrypoint").getter(ModelQualityAppSpecification.getter(ModelQualityAppSpecification::containerEntrypoint)).setter(ModelQualityAppSpecification.setter(Builder::containerEntrypoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEntrypoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTAINER_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerArguments").getter(ModelQualityAppSpecification.getter(ModelQualityAppSpecification::containerArguments)).setter(ModelQualityAppSpecification.setter(Builder::containerArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RECORD_PREPROCESSOR_SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecordPreprocessorSourceUri").getter(ModelQualityAppSpecification.getter(ModelQualityAppSpecification::recordPreprocessorSourceUri)).setter(ModelQualityAppSpecification.setter(Builder::recordPreprocessorSourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecordPreprocessorSourceUri").build()}).build();
    private static final SdkField<String> POST_ANALYTICS_PROCESSOR_SOURCE_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PostAnalyticsProcessorSourceUri").getter(ModelQualityAppSpecification.getter(ModelQualityAppSpecification::postAnalyticsProcessorSourceUri)).setter(ModelQualityAppSpecification.setter(Builder::postAnalyticsProcessorSourceUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostAnalyticsProcessorSourceUri").build()}).build();
    private static final SdkField<String> PROBLEM_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProblemType").getter(ModelQualityAppSpecification.getter(ModelQualityAppSpecification::problemTypeAsString)).setter(ModelQualityAppSpecification.setter(Builder::problemType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProblemType").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Environment").getter(ModelQualityAppSpecification.getter(ModelQualityAppSpecification::environment)).setter(ModelQualityAppSpecification.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Environment").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_URI_FIELD, CONTAINER_ENTRYPOINT_FIELD, CONTAINER_ARGUMENTS_FIELD, RECORD_PREPROCESSOR_SOURCE_URI_FIELD, POST_ANALYTICS_PROCESSOR_SOURCE_URI_FIELD, PROBLEM_TYPE_FIELD, ENVIRONMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ImageUri", IMAGE_URI_FIELD);
            this.put("ContainerEntrypoint", CONTAINER_ENTRYPOINT_FIELD);
            this.put("ContainerArguments", CONTAINER_ARGUMENTS_FIELD);
            this.put("RecordPreprocessorSourceUri", RECORD_PREPROCESSOR_SOURCE_URI_FIELD);
            this.put("PostAnalyticsProcessorSourceUri", POST_ANALYTICS_PROCESSOR_SOURCE_URI_FIELD);
            this.put("ProblemType", PROBLEM_TYPE_FIELD);
            this.put("Environment", ENVIRONMENT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String imageUri;
    private final List<String> containerEntrypoint;
    private final List<String> containerArguments;
    private final String recordPreprocessorSourceUri;
    private final String postAnalyticsProcessorSourceUri;
    private final String problemType;
    private final Map<String, String> environment;

    private ModelQualityAppSpecification(BuilderImpl builder) {
        this.imageUri = builder.imageUri;
        this.containerEntrypoint = builder.containerEntrypoint;
        this.containerArguments = builder.containerArguments;
        this.recordPreprocessorSourceUri = builder.recordPreprocessorSourceUri;
        this.postAnalyticsProcessorSourceUri = builder.postAnalyticsProcessorSourceUri;
        this.problemType = builder.problemType;
        this.environment = builder.environment;
    }

    public final String imageUri() {
        return this.imageUri;
    }

    public final boolean hasContainerEntrypoint() {
        return this.containerEntrypoint != null && !(this.containerEntrypoint instanceof SdkAutoConstructList);
    }

    public final List<String> containerEntrypoint() {
        return this.containerEntrypoint;
    }

    public final boolean hasContainerArguments() {
        return this.containerArguments != null && !(this.containerArguments instanceof SdkAutoConstructList);
    }

    public final List<String> containerArguments() {
        return this.containerArguments;
    }

    public final String recordPreprocessorSourceUri() {
        return this.recordPreprocessorSourceUri;
    }

    public final String postAnalyticsProcessorSourceUri() {
        return this.postAnalyticsProcessorSourceUri;
    }

    public final MonitoringProblemType problemType() {
        return MonitoringProblemType.fromValue(this.problemType);
    }

    public final String problemTypeAsString() {
        return this.problemType;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environment() {
        return this.environment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerEntrypoint() ? this.containerEntrypoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerArguments() ? this.containerArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.recordPreprocessorSourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.postAnalyticsProcessorSourceUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.problemTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelQualityAppSpecification)) {
            return false;
        }
        ModelQualityAppSpecification other = (ModelQualityAppSpecification)obj;
        return Objects.equals(this.imageUri(), other.imageUri()) && this.hasContainerEntrypoint() == other.hasContainerEntrypoint() && Objects.equals(this.containerEntrypoint(), other.containerEntrypoint()) && this.hasContainerArguments() == other.hasContainerArguments() && Objects.equals(this.containerArguments(), other.containerArguments()) && Objects.equals(this.recordPreprocessorSourceUri(), other.recordPreprocessorSourceUri()) && Objects.equals(this.postAnalyticsProcessorSourceUri(), other.postAnalyticsProcessorSourceUri()) && Objects.equals(this.problemTypeAsString(), other.problemTypeAsString()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment());
    }

    public final String toString() {
        return ToString.builder((String)"ModelQualityAppSpecification").add("ImageUri", (Object)this.imageUri()).add("ContainerEntrypoint", this.hasContainerEntrypoint() ? this.containerEntrypoint() : null).add("ContainerArguments", this.hasContainerArguments() ? this.containerArguments() : null).add("RecordPreprocessorSourceUri", (Object)this.recordPreprocessorSourceUri()).add("PostAnalyticsProcessorSourceUri", (Object)this.postAnalyticsProcessorSourceUri()).add("ProblemType", (Object)this.problemTypeAsString()).add("Environment", this.hasEnvironment() ? this.environment() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageUri": {
                return Optional.ofNullable(clazz.cast(this.imageUri()));
            }
            case "ContainerEntrypoint": {
                return Optional.ofNullable(clazz.cast(this.containerEntrypoint()));
            }
            case "ContainerArguments": {
                return Optional.ofNullable(clazz.cast(this.containerArguments()));
            }
            case "RecordPreprocessorSourceUri": {
                return Optional.ofNullable(clazz.cast(this.recordPreprocessorSourceUri()));
            }
            case "PostAnalyticsProcessorSourceUri": {
                return Optional.ofNullable(clazz.cast(this.postAnalyticsProcessorSourceUri()));
            }
            case "ProblemType": {
                return Optional.ofNullable(clazz.cast(this.problemTypeAsString()));
            }
            case "Environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelQualityAppSpecification, T> g) {
        return obj -> g.apply((ModelQualityAppSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageUri;
        private List<String> containerEntrypoint = DefaultSdkAutoConstructList.getInstance();
        private List<String> containerArguments = DefaultSdkAutoConstructList.getInstance();
        private String recordPreprocessorSourceUri;
        private String postAnalyticsProcessorSourceUri;
        private String problemType;
        private Map<String, String> environment = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ModelQualityAppSpecification model) {
            this.imageUri(model.imageUri);
            this.containerEntrypoint(model.containerEntrypoint);
            this.containerArguments(model.containerArguments);
            this.recordPreprocessorSourceUri(model.recordPreprocessorSourceUri);
            this.postAnalyticsProcessorSourceUri(model.postAnalyticsProcessorSourceUri);
            this.problemType(model.problemType);
            this.environment(model.environment);
        }

        public final String getImageUri() {
            return this.imageUri;
        }

        public final void setImageUri(String imageUri) {
            this.imageUri = imageUri;
        }

        @Override
        public final Builder imageUri(String imageUri) {
            this.imageUri = imageUri;
            return this;
        }

        public final Collection<String> getContainerEntrypoint() {
            if (this.containerEntrypoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerEntrypoint;
        }

        public final void setContainerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
        }

        @Override
        public final Builder containerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = ContainerEntrypointCopier.copy(containerEntrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerEntrypoint(String ... containerEntrypoint) {
            this.containerEntrypoint(Arrays.asList(containerEntrypoint));
            return this;
        }

        public final Collection<String> getContainerArguments() {
            if (this.containerArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerArguments;
        }

        public final void setContainerArguments(Collection<String> containerArguments) {
            this.containerArguments = MonitoringContainerArgumentsCopier.copy(containerArguments);
        }

        @Override
        public final Builder containerArguments(Collection<String> containerArguments) {
            this.containerArguments = MonitoringContainerArgumentsCopier.copy(containerArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerArguments(String ... containerArguments) {
            this.containerArguments(Arrays.asList(containerArguments));
            return this;
        }

        public final String getRecordPreprocessorSourceUri() {
            return this.recordPreprocessorSourceUri;
        }

        public final void setRecordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
            this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
        }

        @Override
        public final Builder recordPreprocessorSourceUri(String recordPreprocessorSourceUri) {
            this.recordPreprocessorSourceUri = recordPreprocessorSourceUri;
            return this;
        }

        public final String getPostAnalyticsProcessorSourceUri() {
            return this.postAnalyticsProcessorSourceUri;
        }

        public final void setPostAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
            this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
        }

        @Override
        public final Builder postAnalyticsProcessorSourceUri(String postAnalyticsProcessorSourceUri) {
            this.postAnalyticsProcessorSourceUri = postAnalyticsProcessorSourceUri;
            return this;
        }

        public final String getProblemType() {
            return this.problemType;
        }

        public final void setProblemType(String problemType) {
            this.problemType = problemType;
        }

        @Override
        public final Builder problemType(String problemType) {
            this.problemType = problemType;
            return this;
        }

        @Override
        public final Builder problemType(MonitoringProblemType problemType) {
            this.problemType(problemType == null ? null : problemType.toString());
            return this;
        }

        public final Map<String, String> getEnvironment() {
            if (this.environment instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environment;
        }

        public final void setEnvironment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
        }

        @Override
        public final Builder environment(Map<String, String> environment) {
            this.environment = MonitoringEnvironmentMapCopier.copy(environment);
            return this;
        }

        public ModelQualityAppSpecification build() {
            return new ModelQualityAppSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelQualityAppSpecification> {
        public Builder imageUri(String var1);

        public Builder containerEntrypoint(Collection<String> var1);

        public Builder containerEntrypoint(String ... var1);

        public Builder containerArguments(Collection<String> var1);

        public Builder containerArguments(String ... var1);

        public Builder recordPreprocessorSourceUri(String var1);

        public Builder postAnalyticsProcessorSourceUri(String var1);

        public Builder problemType(String var1);

        public Builder problemType(MonitoringProblemType var1);

        public Builder environment(Map<String, String> var1);
    }
}

