/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSummary;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSummaryListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAlgorithmsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListAlgorithmsResponse> {
    private static final SdkField<List<AlgorithmSummary>> ALGORITHM_SUMMARY_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AlgorithmSummaryList").getter(ListAlgorithmsResponse.getter(ListAlgorithmsResponse::algorithmSummaryList)).setter(ListAlgorithmsResponse.setter(Builder::algorithmSummaryList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSummaryList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AlgorithmSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListAlgorithmsResponse.getter(ListAlgorithmsResponse::nextToken)).setter(ListAlgorithmsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALGORITHM_SUMMARY_LIST_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("AlgorithmSummaryList", ALGORITHM_SUMMARY_LIST_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<AlgorithmSummary> algorithmSummaryList;
    private final String nextToken;

    private ListAlgorithmsResponse(BuilderImpl builder) {
        super(builder);
        this.algorithmSummaryList = builder.algorithmSummaryList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAlgorithmSummaryList() {
        return this.algorithmSummaryList != null && !(this.algorithmSummaryList instanceof SdkAutoConstructList);
    }

    public final List<AlgorithmSummary> algorithmSummaryList() {
        return this.algorithmSummaryList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAlgorithmSummaryList() ? this.algorithmSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAlgorithmsResponse)) {
            return false;
        }
        ListAlgorithmsResponse other = (ListAlgorithmsResponse)((Object)obj);
        return this.hasAlgorithmSummaryList() == other.hasAlgorithmSummaryList() && Objects.equals(this.algorithmSummaryList(), other.algorithmSummaryList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListAlgorithmsResponse").add("AlgorithmSummaryList", this.hasAlgorithmSummaryList() ? this.algorithmSummaryList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlgorithmSummaryList": {
                return Optional.ofNullable(clazz.cast(this.algorithmSummaryList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListAlgorithmsResponse, T> g) {
        return obj -> g.apply((ListAlgorithmsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<AlgorithmSummary> algorithmSummaryList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListAlgorithmsResponse model) {
            super(model);
            this.algorithmSummaryList(model.algorithmSummaryList);
            this.nextToken(model.nextToken);
        }

        public final List<AlgorithmSummary.Builder> getAlgorithmSummaryList() {
            List<AlgorithmSummary.Builder> result = AlgorithmSummaryListCopier.copyToBuilder(this.algorithmSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAlgorithmSummaryList(Collection<AlgorithmSummary.BuilderImpl> algorithmSummaryList) {
            this.algorithmSummaryList = AlgorithmSummaryListCopier.copyFromBuilder(algorithmSummaryList);
        }

        @Override
        public final Builder algorithmSummaryList(Collection<AlgorithmSummary> algorithmSummaryList) {
            this.algorithmSummaryList = AlgorithmSummaryListCopier.copy(algorithmSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmSummaryList(AlgorithmSummary ... algorithmSummaryList) {
            this.algorithmSummaryList(Arrays.asList(algorithmSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder algorithmSummaryList(Consumer<AlgorithmSummary.Builder> ... algorithmSummaryList) {
            this.algorithmSummaryList(Stream.of(algorithmSummaryList).map(c -> (AlgorithmSummary)((AlgorithmSummary.Builder)AlgorithmSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListAlgorithmsResponse build() {
            return new ListAlgorithmsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAlgorithmsResponse> {
        public Builder algorithmSummaryList(Collection<AlgorithmSummary> var1);

        public Builder algorithmSummaryList(AlgorithmSummary ... var1);

        public Builder algorithmSummaryList(Consumer<AlgorithmSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

