/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.InferenceComponentSummary;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListInferenceComponentsResponse;

public class ListInferenceComponentsIterable
implements SdkIterable<ListInferenceComponentsResponse> {
    private final SageMakerClient client;
    private final ListInferenceComponentsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInferenceComponentsIterable(SageMakerClient client, ListInferenceComponentsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInferenceComponentsResponseFetcher();
    }

    public Iterator<ListInferenceComponentsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<InferenceComponentSummary> inferenceComponents() {
        Function<ListInferenceComponentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.inferenceComponents() != null) {
                return response.inferenceComponents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInferenceComponentsResponseFetcher
    implements SyncPageFetcher<ListInferenceComponentsResponse> {
        private ListInferenceComponentsResponseFetcher() {
        }

        public boolean hasNextPage(ListInferenceComponentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInferenceComponentsResponse nextPage(ListInferenceComponentsResponse previousPage) {
            if (previousPage == null) {
                return ListInferenceComponentsIterable.this.client.listInferenceComponents(ListInferenceComponentsIterable.this.firstRequest);
            }
            return ListInferenceComponentsIterable.this.client.listInferenceComponents((ListInferenceComponentsRequest)((Object)ListInferenceComponentsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

