/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobInputConfig;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobStoppingConditions;
import software.amazon.awssdk.services.sagemaker.model.RecommendationJobType;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateInferenceRecommendationsJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateInferenceRecommendationsJobRequest> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::jobName)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> JOB_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobType").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::jobTypeAsString)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::jobType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobType").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::roleArn)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<RecommendationJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("InputConfig").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::inputConfig)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::inputConfig)).constructor(RecommendationJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<String> JOB_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobDescription").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::jobDescription)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::jobDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDescription").build()}).build();
    private static final SdkField<RecommendationJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingConditions").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::stoppingConditions)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::stoppingConditions)).constructor(RecommendationJobStoppingConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build()}).build();
    private static final SdkField<RecommendationJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputConfig").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::outputConfig)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::outputConfig)).constructor(RecommendationJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateInferenceRecommendationsJobRequest.getter(CreateInferenceRecommendationsJobRequest::tags)).setter(CreateInferenceRecommendationsJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, JOB_TYPE_FIELD, ROLE_ARN_FIELD, INPUT_CONFIG_FIELD, JOB_DESCRIPTION_FIELD, STOPPING_CONDITIONS_FIELD, OUTPUT_CONFIG_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateInferenceRecommendationsJobRequest.memberNameToFieldInitializer();
    private final String jobName;
    private final String jobType;
    private final String roleArn;
    private final RecommendationJobInputConfig inputConfig;
    private final String jobDescription;
    private final RecommendationJobStoppingConditions stoppingConditions;
    private final RecommendationJobOutputConfig outputConfig;
    private final List<Tag> tags;

    private CreateInferenceRecommendationsJobRequest(BuilderImpl builder) {
        super(builder);
        this.jobName = builder.jobName;
        this.jobType = builder.jobType;
        this.roleArn = builder.roleArn;
        this.inputConfig = builder.inputConfig;
        this.jobDescription = builder.jobDescription;
        this.stoppingConditions = builder.stoppingConditions;
        this.outputConfig = builder.outputConfig;
        this.tags = builder.tags;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final RecommendationJobType jobType() {
        return RecommendationJobType.fromValue(this.jobType);
    }

    public final String jobTypeAsString() {
        return this.jobType;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final RecommendationJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public final String jobDescription() {
        return this.jobDescription;
    }

    public final RecommendationJobStoppingConditions stoppingConditions() {
        return this.stoppingConditions;
    }

    public final RecommendationJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateInferenceRecommendationsJobRequest)) {
            return false;
        }
        CreateInferenceRecommendationsJobRequest other = (CreateInferenceRecommendationsJobRequest)((Object)obj);
        return Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.jobTypeAsString(), other.jobTypeAsString()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.jobDescription(), other.jobDescription()) && Objects.equals(this.stoppingConditions(), other.stoppingConditions()) && Objects.equals(this.outputConfig(), other.outputConfig()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateInferenceRecommendationsJobRequest").add("JobName", (Object)this.jobName()).add("JobType", (Object)this.jobTypeAsString()).add("RoleArn", (Object)this.roleArn()).add("InputConfig", (Object)this.inputConfig()).add("JobDescription", (Object)this.jobDescription()).add("StoppingConditions", (Object)this.stoppingConditions()).add("OutputConfig", (Object)this.outputConfig()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "JobType": {
                return Optional.ofNullable(clazz.cast(this.jobTypeAsString()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "JobDescription": {
                return Optional.ofNullable(clazz.cast(this.jobDescription()));
            }
            case "StoppingConditions": {
                return Optional.ofNullable(clazz.cast(this.stoppingConditions()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("JobName", JOB_NAME_FIELD);
        map.put("JobType", JOB_TYPE_FIELD);
        map.put("RoleArn", ROLE_ARN_FIELD);
        map.put("InputConfig", INPUT_CONFIG_FIELD);
        map.put("JobDescription", JOB_DESCRIPTION_FIELD);
        map.put("StoppingConditions", STOPPING_CONDITIONS_FIELD);
        map.put("OutputConfig", OUTPUT_CONFIG_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateInferenceRecommendationsJobRequest, T> g) {
        return obj -> g.apply((CreateInferenceRecommendationsJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String jobName;
        private String jobType;
        private String roleArn;
        private RecommendationJobInputConfig inputConfig;
        private String jobDescription;
        private RecommendationJobStoppingConditions stoppingConditions;
        private RecommendationJobOutputConfig outputConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateInferenceRecommendationsJobRequest model) {
            super(model);
            this.jobName(model.jobName);
            this.jobType(model.jobType);
            this.roleArn(model.roleArn);
            this.inputConfig(model.inputConfig);
            this.jobDescription(model.jobDescription);
            this.stoppingConditions(model.stoppingConditions);
            this.outputConfig(model.outputConfig);
            this.tags(model.tags);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getJobType() {
            return this.jobType;
        }

        public final void setJobType(String jobType) {
            this.jobType = jobType;
        }

        @Override
        public final Builder jobType(String jobType) {
            this.jobType = jobType;
            return this;
        }

        @Override
        public final Builder jobType(RecommendationJobType jobType) {
            this.jobType(jobType == null ? null : jobType.toString());
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final RecommendationJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        public final void setInputConfig(RecommendationJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        @Override
        public final Builder inputConfig(RecommendationJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final String getJobDescription() {
            return this.jobDescription;
        }

        public final void setJobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
        }

        @Override
        public final Builder jobDescription(String jobDescription) {
            this.jobDescription = jobDescription;
            return this;
        }

        public final RecommendationJobStoppingConditions.Builder getStoppingConditions() {
            return this.stoppingConditions != null ? this.stoppingConditions.toBuilder() : null;
        }

        public final void setStoppingConditions(RecommendationJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        @Override
        public final Builder stoppingConditions(RecommendationJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final RecommendationJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(RecommendationJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(RecommendationJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateInferenceRecommendationsJobRequest build() {
            return new CreateInferenceRecommendationsJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateInferenceRecommendationsJobRequest> {
        public Builder jobName(String var1);

        public Builder jobType(String var1);

        public Builder jobType(RecommendationJobType var1);

        public Builder roleArn(String var1);

        public Builder inputConfig(RecommendationJobInputConfig var1);

        default public Builder inputConfig(Consumer<RecommendationJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((RecommendationJobInputConfig)((RecommendationJobInputConfig.Builder)RecommendationJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder jobDescription(String var1);

        public Builder stoppingConditions(RecommendationJobStoppingConditions var1);

        default public Builder stoppingConditions(Consumer<RecommendationJobStoppingConditions.Builder> stoppingConditions) {
            return this.stoppingConditions((RecommendationJobStoppingConditions)((RecommendationJobStoppingConditions.Builder)RecommendationJobStoppingConditions.builder().applyMutation(stoppingConditions)).build());
        }

        public Builder outputConfig(RecommendationJobOutputConfig var1);

        default public Builder outputConfig(Consumer<RecommendationJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((RecommendationJobOutputConfig)((RecommendationJobOutputConfig.Builder)RecommendationJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

