/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.SchedulerConfig;
import software.amazon.awssdk.services.sagemaker.model.SchedulerResourceStatus;
import software.amazon.awssdk.services.sagemaker.model.UserContext;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeClusterSchedulerConfigResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeClusterSchedulerConfigResponse> {
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSchedulerConfigArn").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::clusterSchedulerConfigArn)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::clusterSchedulerConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigArn").build()}).build();
    private static final SdkField<String> CLUSTER_SCHEDULER_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterSchedulerConfigId").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::clusterSchedulerConfigId)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::clusterSchedulerConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigId").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::name)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<Integer> CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ClusterSchedulerConfigVersion").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::clusterSchedulerConfigVersion)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::clusterSchedulerConfigVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterSchedulerConfigVersion").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::statusAsString)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::failureReason)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterArn").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::clusterArn)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterArn").build()}).build();
    private static final SdkField<SchedulerConfig> SCHEDULER_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchedulerConfig").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::schedulerConfig)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::schedulerConfig)).constructor(SchedulerConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchedulerConfig").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::description)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::creationTime)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UserContext> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::createdBy)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::createdBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::lastModifiedTime)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<UserContext> LAST_MODIFIED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedBy").getter(DescribeClusterSchedulerConfigResponse.getter(DescribeClusterSchedulerConfigResponse::lastModifiedBy)).setter(DescribeClusterSchedulerConfigResponse.setter(Builder::lastModifiedBy)).constructor(UserContext::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_SCHEDULER_CONFIG_ARN_FIELD, CLUSTER_SCHEDULER_CONFIG_ID_FIELD, NAME_FIELD, CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD, STATUS_FIELD, FAILURE_REASON_FIELD, CLUSTER_ARN_FIELD, SCHEDULER_CONFIG_FIELD, DESCRIPTION_FIELD, CREATION_TIME_FIELD, CREATED_BY_FIELD, LAST_MODIFIED_TIME_FIELD, LAST_MODIFIED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ClusterSchedulerConfigArn", CLUSTER_SCHEDULER_CONFIG_ARN_FIELD);
            this.put("ClusterSchedulerConfigId", CLUSTER_SCHEDULER_CONFIG_ID_FIELD);
            this.put("Name", NAME_FIELD);
            this.put("ClusterSchedulerConfigVersion", CLUSTER_SCHEDULER_CONFIG_VERSION_FIELD);
            this.put("Status", STATUS_FIELD);
            this.put("FailureReason", FAILURE_REASON_FIELD);
            this.put("ClusterArn", CLUSTER_ARN_FIELD);
            this.put("SchedulerConfig", SCHEDULER_CONFIG_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("CreationTime", CREATION_TIME_FIELD);
            this.put("CreatedBy", CREATED_BY_FIELD);
            this.put("LastModifiedTime", LAST_MODIFIED_TIME_FIELD);
            this.put("LastModifiedBy", LAST_MODIFIED_BY_FIELD);
        }
    });
    private final String clusterSchedulerConfigArn;
    private final String clusterSchedulerConfigId;
    private final String name;
    private final Integer clusterSchedulerConfigVersion;
    private final String status;
    private final String failureReason;
    private final String clusterArn;
    private final SchedulerConfig schedulerConfig;
    private final String description;
    private final Instant creationTime;
    private final UserContext createdBy;
    private final Instant lastModifiedTime;
    private final UserContext lastModifiedBy;

    private DescribeClusterSchedulerConfigResponse(BuilderImpl builder) {
        super(builder);
        this.clusterSchedulerConfigArn = builder.clusterSchedulerConfigArn;
        this.clusterSchedulerConfigId = builder.clusterSchedulerConfigId;
        this.name = builder.name;
        this.clusterSchedulerConfigVersion = builder.clusterSchedulerConfigVersion;
        this.status = builder.status;
        this.failureReason = builder.failureReason;
        this.clusterArn = builder.clusterArn;
        this.schedulerConfig = builder.schedulerConfig;
        this.description = builder.description;
        this.creationTime = builder.creationTime;
        this.createdBy = builder.createdBy;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.lastModifiedBy = builder.lastModifiedBy;
    }

    public final String clusterSchedulerConfigArn() {
        return this.clusterSchedulerConfigArn;
    }

    public final String clusterSchedulerConfigId() {
        return this.clusterSchedulerConfigId;
    }

    public final String name() {
        return this.name;
    }

    public final Integer clusterSchedulerConfigVersion() {
        return this.clusterSchedulerConfigVersion;
    }

    public final SchedulerResourceStatus status() {
        return SchedulerResourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final SchedulerConfig schedulerConfig() {
        return this.schedulerConfig;
    }

    public final String description() {
        return this.description;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UserContext createdBy() {
        return this.createdBy;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final UserContext lastModifiedBy() {
        return this.lastModifiedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterSchedulerConfigVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedulerConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeClusterSchedulerConfigResponse)) {
            return false;
        }
        DescribeClusterSchedulerConfigResponse other = (DescribeClusterSchedulerConfigResponse)((Object)obj);
        return Objects.equals(this.clusterSchedulerConfigArn(), other.clusterSchedulerConfigArn()) && Objects.equals(this.clusterSchedulerConfigId(), other.clusterSchedulerConfigId()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.clusterSchedulerConfigVersion(), other.clusterSchedulerConfigVersion()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.schedulerConfig(), other.schedulerConfig()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.lastModifiedBy(), other.lastModifiedBy());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeClusterSchedulerConfigResponse").add("ClusterSchedulerConfigArn", (Object)this.clusterSchedulerConfigArn()).add("ClusterSchedulerConfigId", (Object)this.clusterSchedulerConfigId()).add("Name", (Object)this.name()).add("ClusterSchedulerConfigVersion", (Object)this.clusterSchedulerConfigVersion()).add("Status", (Object)this.statusAsString()).add("FailureReason", (Object)this.failureReason()).add("ClusterArn", (Object)this.clusterArn()).add("SchedulerConfig", (Object)this.schedulerConfig()).add("Description", (Object)this.description()).add("CreationTime", (Object)this.creationTime()).add("CreatedBy", (Object)this.createdBy()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("LastModifiedBy", (Object)this.lastModifiedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterSchedulerConfigArn": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigArn()));
            }
            case "ClusterSchedulerConfigId": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigId()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ClusterSchedulerConfigVersion": {
                return Optional.ofNullable(clazz.cast(this.clusterSchedulerConfigVersion()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "ClusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "SchedulerConfig": {
                return Optional.ofNullable(clazz.cast(this.schedulerConfig()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "LastModifiedBy": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DescribeClusterSchedulerConfigResponse, T> g) {
        return obj -> g.apply((DescribeClusterSchedulerConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String clusterSchedulerConfigArn;
        private String clusterSchedulerConfigId;
        private String name;
        private Integer clusterSchedulerConfigVersion;
        private String status;
        private String failureReason;
        private String clusterArn;
        private SchedulerConfig schedulerConfig;
        private String description;
        private Instant creationTime;
        private UserContext createdBy;
        private Instant lastModifiedTime;
        private UserContext lastModifiedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeClusterSchedulerConfigResponse model) {
            super(model);
            this.clusterSchedulerConfigArn(model.clusterSchedulerConfigArn);
            this.clusterSchedulerConfigId(model.clusterSchedulerConfigId);
            this.name(model.name);
            this.clusterSchedulerConfigVersion(model.clusterSchedulerConfigVersion);
            this.status(model.status);
            this.failureReason(model.failureReason);
            this.clusterArn(model.clusterArn);
            this.schedulerConfig(model.schedulerConfig);
            this.description(model.description);
            this.creationTime(model.creationTime);
            this.createdBy(model.createdBy);
            this.lastModifiedTime(model.lastModifiedTime);
            this.lastModifiedBy(model.lastModifiedBy);
        }

        public final String getClusterSchedulerConfigArn() {
            return this.clusterSchedulerConfigArn;
        }

        public final void setClusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
        }

        @Override
        public final Builder clusterSchedulerConfigArn(String clusterSchedulerConfigArn) {
            this.clusterSchedulerConfigArn = clusterSchedulerConfigArn;
            return this;
        }

        public final String getClusterSchedulerConfigId() {
            return this.clusterSchedulerConfigId;
        }

        public final void setClusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
        }

        @Override
        public final Builder clusterSchedulerConfigId(String clusterSchedulerConfigId) {
            this.clusterSchedulerConfigId = clusterSchedulerConfigId;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Integer getClusterSchedulerConfigVersion() {
            return this.clusterSchedulerConfigVersion;
        }

        public final void setClusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
        }

        @Override
        public final Builder clusterSchedulerConfigVersion(Integer clusterSchedulerConfigVersion) {
            this.clusterSchedulerConfigVersion = clusterSchedulerConfigVersion;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SchedulerResourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final SchedulerConfig.Builder getSchedulerConfig() {
            return this.schedulerConfig != null ? this.schedulerConfig.toBuilder() : null;
        }

        public final void setSchedulerConfig(SchedulerConfig.BuilderImpl schedulerConfig) {
            this.schedulerConfig = schedulerConfig != null ? schedulerConfig.build() : null;
        }

        @Override
        public final Builder schedulerConfig(SchedulerConfig schedulerConfig) {
            this.schedulerConfig = schedulerConfig;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final UserContext.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(UserContext.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(UserContext createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final UserContext.Builder getLastModifiedBy() {
            return this.lastModifiedBy != null ? this.lastModifiedBy.toBuilder() : null;
        }

        public final void setLastModifiedBy(UserContext.BuilderImpl lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy != null ? lastModifiedBy.build() : null;
        }

        @Override
        public final Builder lastModifiedBy(UserContext lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        @Override
        public DescribeClusterSchedulerConfigResponse build() {
            return new DescribeClusterSchedulerConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeClusterSchedulerConfigResponse> {
        public Builder clusterSchedulerConfigArn(String var1);

        public Builder clusterSchedulerConfigId(String var1);

        public Builder name(String var1);

        public Builder clusterSchedulerConfigVersion(Integer var1);

        public Builder status(String var1);

        public Builder status(SchedulerResourceStatus var1);

        public Builder failureReason(String var1);

        public Builder clusterArn(String var1);

        public Builder schedulerConfig(SchedulerConfig var1);

        default public Builder schedulerConfig(Consumer<SchedulerConfig.Builder> schedulerConfig) {
            return this.schedulerConfig((SchedulerConfig)((SchedulerConfig.Builder)SchedulerConfig.builder().applyMutation(schedulerConfig)).build());
        }

        public Builder description(String var1);

        public Builder creationTime(Instant var1);

        public Builder createdBy(UserContext var1);

        default public Builder createdBy(Consumer<UserContext.Builder> createdBy) {
            return this.createdBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(createdBy)).build());
        }

        public Builder lastModifiedTime(Instant var1);

        public Builder lastModifiedBy(UserContext var1);

        default public Builder lastModifiedBy(Consumer<UserContext.Builder> lastModifiedBy) {
            return this.lastModifiedBy((UserContext)((UserContext.Builder)UserContext.builder().applyMutation(lastModifiedBy)).build());
        }
    }
}

