/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.EFSFileSystem;
import software.amazon.awssdk.services.sagemaker.model.FSxLustreFileSystem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomFileSystem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomFileSystem> {
    private static final SdkField<EFSFileSystem> EFS_FILE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EFSFileSystem").getter(CustomFileSystem.getter(CustomFileSystem::efsFileSystem)).setter(CustomFileSystem.setter(Builder::efsFileSystem)).constructor(EFSFileSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EFSFileSystem").build()}).build();
    private static final SdkField<FSxLustreFileSystem> F_SX_LUSTRE_FILE_SYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FSxLustreFileSystem").getter(CustomFileSystem.getter(CustomFileSystem::fSxLustreFileSystem)).setter(CustomFileSystem.setter(Builder::fSxLustreFileSystem)).constructor(FSxLustreFileSystem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FSxLustreFileSystem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EFS_FILE_SYSTEM_FIELD, F_SX_LUSTRE_FILE_SYSTEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EFSFileSystem", EFS_FILE_SYSTEM_FIELD);
            this.put("FSxLustreFileSystem", F_SX_LUSTRE_FILE_SYSTEM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final EFSFileSystem efsFileSystem;
    private final FSxLustreFileSystem fSxLustreFileSystem;
    private final Type type;

    private CustomFileSystem(BuilderImpl builder) {
        this.efsFileSystem = builder.efsFileSystem;
        this.fSxLustreFileSystem = builder.fSxLustreFileSystem;
        this.type = builder.type;
    }

    public final EFSFileSystem efsFileSystem() {
        return this.efsFileSystem;
    }

    public final FSxLustreFileSystem fSxLustreFileSystem() {
        return this.fSxLustreFileSystem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.efsFileSystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.fSxLustreFileSystem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomFileSystem)) {
            return false;
        }
        CustomFileSystem other = (CustomFileSystem)obj;
        return Objects.equals(this.efsFileSystem(), other.efsFileSystem()) && Objects.equals(this.fSxLustreFileSystem(), other.fSxLustreFileSystem());
    }

    public final String toString() {
        return ToString.builder((String)"CustomFileSystem").add("EFSFileSystem", (Object)this.efsFileSystem()).add("FSxLustreFileSystem", (Object)this.fSxLustreFileSystem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EFSFileSystem": {
                return Optional.ofNullable(clazz.cast(this.efsFileSystem()));
            }
            case "FSxLustreFileSystem": {
                return Optional.ofNullable(clazz.cast(this.fSxLustreFileSystem()));
            }
        }
        return Optional.empty();
    }

    public static CustomFileSystem fromEfsFileSystem(EFSFileSystem efsFileSystem) {
        return (CustomFileSystem)CustomFileSystem.builder().efsFileSystem(efsFileSystem).build();
    }

    public static CustomFileSystem fromEfsFileSystem(Consumer<EFSFileSystem.Builder> efsFileSystem) {
        EFSFileSystem.Builder builder = EFSFileSystem.builder();
        efsFileSystem.accept(builder);
        return CustomFileSystem.fromEfsFileSystem((EFSFileSystem)builder.build());
    }

    public static CustomFileSystem fromFSxLustreFileSystem(FSxLustreFileSystem fSxLustreFileSystem) {
        return (CustomFileSystem)CustomFileSystem.builder().fSxLustreFileSystem(fSxLustreFileSystem).build();
    }

    public static CustomFileSystem fromFSxLustreFileSystem(Consumer<FSxLustreFileSystem.Builder> fSxLustreFileSystem) {
        FSxLustreFileSystem.Builder builder = FSxLustreFileSystem.builder();
        fSxLustreFileSystem.accept(builder);
        return CustomFileSystem.fromFSxLustreFileSystem((FSxLustreFileSystem)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CustomFileSystem, T> g) {
        return obj -> g.apply((CustomFileSystem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        EFS_FILE_SYSTEM,
        F_SX_LUSTRE_FILE_SYSTEM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private EFSFileSystem efsFileSystem;
        private FSxLustreFileSystem fSxLustreFileSystem;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(CustomFileSystem model) {
            this.efsFileSystem(model.efsFileSystem);
            this.fSxLustreFileSystem(model.fSxLustreFileSystem);
        }

        public final EFSFileSystem.Builder getEfsFileSystem() {
            return this.efsFileSystem != null ? this.efsFileSystem.toBuilder() : null;
        }

        public final void setEfsFileSystem(EFSFileSystem.BuilderImpl efsFileSystem) {
            EFSFileSystem oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem != null ? efsFileSystem.build() : null;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
        }

        @Override
        public final Builder efsFileSystem(EFSFileSystem efsFileSystem) {
            EFSFileSystem oldValue = this.efsFileSystem;
            this.efsFileSystem = efsFileSystem;
            this.handleUnionValueChange(Type.EFS_FILE_SYSTEM, oldValue, this.efsFileSystem);
            return this;
        }

        public final FSxLustreFileSystem.Builder getFSxLustreFileSystem() {
            return this.fSxLustreFileSystem != null ? this.fSxLustreFileSystem.toBuilder() : null;
        }

        public final void setFSxLustreFileSystem(FSxLustreFileSystem.BuilderImpl fSxLustreFileSystem) {
            FSxLustreFileSystem oldValue = this.fSxLustreFileSystem;
            this.fSxLustreFileSystem = fSxLustreFileSystem != null ? fSxLustreFileSystem.build() : null;
            this.handleUnionValueChange(Type.F_SX_LUSTRE_FILE_SYSTEM, oldValue, this.fSxLustreFileSystem);
        }

        @Override
        public final Builder fSxLustreFileSystem(FSxLustreFileSystem fSxLustreFileSystem) {
            FSxLustreFileSystem oldValue = this.fSxLustreFileSystem;
            this.fSxLustreFileSystem = fSxLustreFileSystem;
            this.handleUnionValueChange(Type.F_SX_LUSTRE_FILE_SYSTEM, oldValue, this.fSxLustreFileSystem);
            return this;
        }

        public CustomFileSystem build() {
            return new CustomFileSystem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomFileSystem> {
        public Builder efsFileSystem(EFSFileSystem var1);

        default public Builder efsFileSystem(Consumer<EFSFileSystem.Builder> efsFileSystem) {
            return this.efsFileSystem((EFSFileSystem)((EFSFileSystem.Builder)EFSFileSystem.builder().applyMutation(efsFileSystem)).build());
        }

        public Builder fSxLustreFileSystem(FSxLustreFileSystem var1);

        default public Builder fSxLustreFileSystem(Consumer<FSxLustreFileSystem.Builder> fSxLustreFileSystem) {
            return this.fSxLustreFileSystem((FSxLustreFileSystem)((FSxLustreFileSystem.Builder)FSxLustreFileSystem.builder().applyMutation(fSxLustreFileSystem)).build());
        }
    }
}

