/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ResourceSharingStrategy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceSharingConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceSharingConfig> {
    private static final SdkField<String> STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Strategy").getter(ResourceSharingConfig.getter(ResourceSharingConfig::strategyAsString)).setter(ResourceSharingConfig.setter(Builder::strategy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Strategy").build()}).build();
    private static final SdkField<Integer> BORROW_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("BorrowLimit").getter(ResourceSharingConfig.getter(ResourceSharingConfig::borrowLimit)).setter(ResourceSharingConfig.setter(Builder::borrowLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BorrowLimit").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STRATEGY_FIELD, BORROW_LIMIT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Strategy", STRATEGY_FIELD);
            this.put("BorrowLimit", BORROW_LIMIT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String strategy;
    private final Integer borrowLimit;

    private ResourceSharingConfig(BuilderImpl builder) {
        this.strategy = builder.strategy;
        this.borrowLimit = builder.borrowLimit;
    }

    public final ResourceSharingStrategy strategy() {
        return ResourceSharingStrategy.fromValue(this.strategy);
    }

    public final String strategyAsString() {
        return this.strategy;
    }

    public final Integer borrowLimit() {
        return this.borrowLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.strategyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.borrowLimit());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSharingConfig)) {
            return false;
        }
        ResourceSharingConfig other = (ResourceSharingConfig)obj;
        return Objects.equals(this.strategyAsString(), other.strategyAsString()) && Objects.equals(this.borrowLimit(), other.borrowLimit());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceSharingConfig").add("Strategy", (Object)this.strategyAsString()).add("BorrowLimit", (Object)this.borrowLimit()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Strategy": {
                return Optional.ofNullable(clazz.cast(this.strategyAsString()));
            }
            case "BorrowLimit": {
                return Optional.ofNullable(clazz.cast(this.borrowLimit()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ResourceSharingConfig, T> g) {
        return obj -> g.apply((ResourceSharingConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String strategy;
        private Integer borrowLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSharingConfig model) {
            this.strategy(model.strategy);
            this.borrowLimit(model.borrowLimit);
        }

        public final String getStrategy() {
            return this.strategy;
        }

        public final void setStrategy(String strategy) {
            this.strategy = strategy;
        }

        @Override
        public final Builder strategy(String strategy) {
            this.strategy = strategy;
            return this;
        }

        @Override
        public final Builder strategy(ResourceSharingStrategy strategy) {
            this.strategy(strategy == null ? null : strategy.toString());
            return this;
        }

        public final Integer getBorrowLimit() {
            return this.borrowLimit;
        }

        public final void setBorrowLimit(Integer borrowLimit) {
            this.borrowLimit = borrowLimit;
        }

        @Override
        public final Builder borrowLimit(Integer borrowLimit) {
            this.borrowLimit = borrowLimit;
            return this;
        }

        public ResourceSharingConfig build() {
            return new ResourceSharingConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceSharingConfig> {
        public Builder strategy(String var1);

        public Builder strategy(ResourceSharingStrategy var1);

        public Builder borrowLimit(Integer var1);
    }
}

