/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceType;
import software.amazon.awssdk.services.sagemaker.model.ClusterLifeCycleConfig;
import software.amazon.awssdk.services.sagemaker.model.DeepHealthCheckType;
import software.amazon.awssdk.services.sagemaker.model.OnStartDeepHealthChecksCopier;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterInstanceGroupSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterInstanceGroupSpecification> {
    private static final SdkField<Integer> INSTANCE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("InstanceCount").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceCount)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceCount").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceGroupName)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceTypeAsString)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycleConfig").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::lifeCycleConfig)).setter(ClusterInstanceGroupSpecification.setter(Builder::lifeCycleConfig)).constructor(ClusterLifeCycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::executionRole)).setter(ClusterInstanceGroupSpecification.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThreadsPerCore").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::threadsPerCore)).setter(ClusterInstanceGroupSpecification.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()}).build();
    private static final SdkField<List<ClusterInstanceStorageConfig>> INSTANCE_STORAGE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceStorageConfigs").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::instanceStorageConfigs)).setter(ClusterInstanceGroupSpecification.setter(Builder::instanceStorageConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ON_START_DEEP_HEALTH_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnStartDeepHealthChecks").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::onStartDeepHealthChecksAsStrings)).setter(ClusterInstanceGroupSpecification.setter(Builder::onStartDeepHealthChecksWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStartDeepHealthChecks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> OVERRIDE_VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OverrideVpcConfig").getter(ClusterInstanceGroupSpecification.getter(ClusterInstanceGroupSpecification::overrideVpcConfig)).setter(ClusterInstanceGroupSpecification.setter(Builder::overrideVpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OverrideVpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_COUNT_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_TYPE_FIELD, LIFE_CYCLE_CONFIG_FIELD, EXECUTION_ROLE_FIELD, THREADS_PER_CORE_FIELD, INSTANCE_STORAGE_CONFIGS_FIELD, ON_START_DEEP_HEALTH_CHECKS_FIELD, OVERRIDE_VPC_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InstanceCount", INSTANCE_COUNT_FIELD);
            this.put("InstanceGroupName", INSTANCE_GROUP_NAME_FIELD);
            this.put("InstanceType", INSTANCE_TYPE_FIELD);
            this.put("LifeCycleConfig", LIFE_CYCLE_CONFIG_FIELD);
            this.put("ExecutionRole", EXECUTION_ROLE_FIELD);
            this.put("ThreadsPerCore", THREADS_PER_CORE_FIELD);
            this.put("InstanceStorageConfigs", INSTANCE_STORAGE_CONFIGS_FIELD);
            this.put("OnStartDeepHealthChecks", ON_START_DEEP_HEALTH_CHECKS_FIELD);
            this.put("OverrideVpcConfig", OVERRIDE_VPC_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer instanceCount;
    private final String instanceGroupName;
    private final String instanceType;
    private final ClusterLifeCycleConfig lifeCycleConfig;
    private final String executionRole;
    private final Integer threadsPerCore;
    private final List<ClusterInstanceStorageConfig> instanceStorageConfigs;
    private final List<String> onStartDeepHealthChecks;
    private final VpcConfig overrideVpcConfig;

    private ClusterInstanceGroupSpecification(BuilderImpl builder) {
        this.instanceCount = builder.instanceCount;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceType = builder.instanceType;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.executionRole = builder.executionRole;
        this.threadsPerCore = builder.threadsPerCore;
        this.instanceStorageConfigs = builder.instanceStorageConfigs;
        this.onStartDeepHealthChecks = builder.onStartDeepHealthChecks;
        this.overrideVpcConfig = builder.overrideVpcConfig;
    }

    public final Integer instanceCount() {
        return this.instanceCount;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return this.lifeCycleConfig;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public final boolean hasInstanceStorageConfigs() {
        return this.instanceStorageConfigs != null && !(this.instanceStorageConfigs instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceStorageConfig> instanceStorageConfigs() {
        return this.instanceStorageConfigs;
    }

    public final List<DeepHealthCheckType> onStartDeepHealthChecks() {
        return OnStartDeepHealthChecksCopier.copyStringToEnum(this.onStartDeepHealthChecks);
    }

    public final boolean hasOnStartDeepHealthChecks() {
        return this.onStartDeepHealthChecks != null && !(this.onStartDeepHealthChecks instanceof SdkAutoConstructList);
    }

    public final List<String> onStartDeepHealthChecksAsStrings() {
        return this.onStartDeepHealthChecks;
    }

    public final VpcConfig overrideVpcConfig() {
        return this.overrideVpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideVpcConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInstanceGroupSpecification)) {
            return false;
        }
        ClusterInstanceGroupSpecification other = (ClusterInstanceGroupSpecification)obj;
        return Objects.equals(this.instanceCount(), other.instanceCount()) && Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.lifeCycleConfig(), other.lifeCycleConfig()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore()) && this.hasInstanceStorageConfigs() == other.hasInstanceStorageConfigs() && Objects.equals(this.instanceStorageConfigs(), other.instanceStorageConfigs()) && this.hasOnStartDeepHealthChecks() == other.hasOnStartDeepHealthChecks() && Objects.equals(this.onStartDeepHealthChecksAsStrings(), other.onStartDeepHealthChecksAsStrings()) && Objects.equals(this.overrideVpcConfig(), other.overrideVpcConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterInstanceGroupSpecification").add("InstanceCount", (Object)this.instanceCount()).add("InstanceGroupName", (Object)this.instanceGroupName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("LifeCycleConfig", (Object)this.lifeCycleConfig()).add("ExecutionRole", (Object)this.executionRole()).add("ThreadsPerCore", (Object)this.threadsPerCore()).add("InstanceStorageConfigs", this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null).add("OnStartDeepHealthChecks", this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null).add("OverrideVpcConfig", (Object)this.overrideVpcConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InstanceCount": {
                return Optional.ofNullable(clazz.cast(this.instanceCount()));
            }
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "LifeCycleConfig": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleConfig()));
            }
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
            case "InstanceStorageConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceStorageConfigs()));
            }
            case "OnStartDeepHealthChecks": {
                return Optional.ofNullable(clazz.cast(this.onStartDeepHealthChecksAsStrings()));
            }
            case "OverrideVpcConfig": {
                return Optional.ofNullable(clazz.cast(this.overrideVpcConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInstanceGroupSpecification, T> g) {
        return obj -> g.apply((ClusterInstanceGroupSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer instanceCount;
        private String instanceGroupName;
        private String instanceType;
        private ClusterLifeCycleConfig lifeCycleConfig;
        private String executionRole;
        private Integer threadsPerCore;
        private List<ClusterInstanceStorageConfig> instanceStorageConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<String> onStartDeepHealthChecks = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig overrideVpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInstanceGroupSpecification model) {
            this.instanceCount(model.instanceCount);
            this.instanceGroupName(model.instanceGroupName);
            this.instanceType(model.instanceType);
            this.lifeCycleConfig(model.lifeCycleConfig);
            this.executionRole(model.executionRole);
            this.threadsPerCore(model.threadsPerCore);
            this.instanceStorageConfigs(model.instanceStorageConfigs);
            this.onStartDeepHealthChecksWithStrings(model.onStartDeepHealthChecks);
            this.overrideVpcConfig(model.overrideVpcConfig);
        }

        public final Integer getInstanceCount() {
            return this.instanceCount;
        }

        public final void setInstanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
        }

        @Override
        public final Builder instanceCount(Integer instanceCount) {
            this.instanceCount = instanceCount;
            return this;
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return this.lifeCycleConfig != null ? this.lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final List<ClusterInstanceStorageConfig.Builder> getInstanceStorageConfigs() {
            List<ClusterInstanceStorageConfig.Builder> result = ClusterInstanceStorageConfigsCopier.copyToBuilder(this.instanceStorageConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceStorageConfigs(Collection<ClusterInstanceStorageConfig.BuilderImpl> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copyFromBuilder(instanceStorageConfigs);
        }

        @Override
        public final Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copy(instanceStorageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Arrays.asList(instanceStorageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Stream.of(instanceStorageConfigs).map(c -> (ClusterInstanceStorageConfig)((ClusterInstanceStorageConfig.Builder)ClusterInstanceStorageConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOnStartDeepHealthChecks() {
            if (this.onStartDeepHealthChecks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.onStartDeepHealthChecks;
        }

        public final void setOnStartDeepHealthChecks(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
        }

        @Override
        public final Builder onStartDeepHealthChecksWithStrings(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecksWithStrings(String ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecksWithStrings(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        @Override
        public final Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copyEnumToString(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecks(DeepHealthCheckType ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        public final VpcConfig.Builder getOverrideVpcConfig() {
            return this.overrideVpcConfig != null ? this.overrideVpcConfig.toBuilder() : null;
        }

        public final void setOverrideVpcConfig(VpcConfig.BuilderImpl overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig != null ? overrideVpcConfig.build() : null;
        }

        @Override
        public final Builder overrideVpcConfig(VpcConfig overrideVpcConfig) {
            this.overrideVpcConfig = overrideVpcConfig;
            return this;
        }

        public ClusterInstanceGroupSpecification build() {
            return new ClusterInstanceGroupSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterInstanceGroupSpecification> {
        public Builder instanceCount(Integer var1);

        public Builder instanceGroupName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ClusterInstanceType var1);

        public Builder lifeCycleConfig(ClusterLifeCycleConfig var1);

        default public Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return this.lifeCycleConfig((ClusterLifeCycleConfig)((ClusterLifeCycleConfig.Builder)ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig)).build());
        }

        public Builder executionRole(String var1);

        public Builder threadsPerCore(Integer var1);

        public Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> var1);

        public Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... var1);

        public Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... var1);

        public Builder onStartDeepHealthChecksWithStrings(Collection<String> var1);

        public Builder onStartDeepHealthChecksWithStrings(String ... var1);

        public Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> var1);

        public Builder onStartDeepHealthChecks(DeepHealthCheckType ... var1);

        public Builder overrideVpcConfig(VpcConfig var1);

        default public Builder overrideVpcConfig(Consumer<VpcConfig.Builder> overrideVpcConfig) {
            return this.overrideVpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(overrideVpcConfig)).build());
        }
    }
}

