/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HubContentInfo;
import software.amazon.awssdk.services.sagemaker.model.HubContentInfoListCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListHubContentVersionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListHubContentVersionsResponse> {
    private static final SdkField<List<HubContentInfo>> HUB_CONTENT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("HubContentSummaries").getter(ListHubContentVersionsResponse.getter(ListHubContentVersionsResponse::hubContentSummaries)).setter(ListHubContentVersionsResponse.setter(Builder::hubContentSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HubContentSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HubContentInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListHubContentVersionsResponse.getter(ListHubContentVersionsResponse::nextToken)).setter(ListHubContentVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUB_CONTENT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("HubContentSummaries", HUB_CONTENT_SUMMARIES_FIELD);
            this.put("NextToken", NEXT_TOKEN_FIELD);
        }
    });
    private final List<HubContentInfo> hubContentSummaries;
    private final String nextToken;

    private ListHubContentVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.hubContentSummaries = builder.hubContentSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHubContentSummaries() {
        return this.hubContentSummaries != null && !(this.hubContentSummaries instanceof SdkAutoConstructList);
    }

    public final List<HubContentInfo> hubContentSummaries() {
        return this.hubContentSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHubContentSummaries() ? this.hubContentSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListHubContentVersionsResponse)) {
            return false;
        }
        ListHubContentVersionsResponse other = (ListHubContentVersionsResponse)((Object)obj);
        return this.hasHubContentSummaries() == other.hasHubContentSummaries() && Objects.equals(this.hubContentSummaries(), other.hubContentSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListHubContentVersionsResponse").add("HubContentSummaries", this.hasHubContentSummaries() ? this.hubContentSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HubContentSummaries": {
                return Optional.ofNullable(clazz.cast(this.hubContentSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListHubContentVersionsResponse, T> g) {
        return obj -> g.apply((ListHubContentVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<HubContentInfo> hubContentSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListHubContentVersionsResponse model) {
            super(model);
            this.hubContentSummaries(model.hubContentSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<HubContentInfo.Builder> getHubContentSummaries() {
            List<HubContentInfo.Builder> result = HubContentInfoListCopier.copyToBuilder(this.hubContentSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHubContentSummaries(Collection<HubContentInfo.BuilderImpl> hubContentSummaries) {
            this.hubContentSummaries = HubContentInfoListCopier.copyFromBuilder(hubContentSummaries);
        }

        @Override
        public final Builder hubContentSummaries(Collection<HubContentInfo> hubContentSummaries) {
            this.hubContentSummaries = HubContentInfoListCopier.copy(hubContentSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSummaries(HubContentInfo ... hubContentSummaries) {
            this.hubContentSummaries(Arrays.asList(hubContentSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder hubContentSummaries(Consumer<HubContentInfo.Builder> ... hubContentSummaries) {
            this.hubContentSummaries(Stream.of(hubContentSummaries).map(c -> (HubContentInfo)((HubContentInfo.Builder)HubContentInfo.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListHubContentVersionsResponse build() {
            return new ListHubContentVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListHubContentVersionsResponse> {
        public Builder hubContentSummaries(Collection<HubContentInfo> var1);

        public Builder hubContentSummaries(HubContentInfo ... var1);

        public Builder hubContentSummaries(Consumer<HubContentInfo.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

