/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ModelInfrastructureType;
import software.amazon.awssdk.services.sagemaker.model.RealTimeInferenceConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelInfrastructureConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelInfrastructureConfig> {
    private static final SdkField<String> INFRASTRUCTURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InfrastructureType").getter(ModelInfrastructureConfig.getter(ModelInfrastructureConfig::infrastructureTypeAsString)).setter(ModelInfrastructureConfig.setter(Builder::infrastructureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InfrastructureType").build()}).build();
    private static final SdkField<RealTimeInferenceConfig> REAL_TIME_INFERENCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RealTimeInferenceConfig").getter(ModelInfrastructureConfig.getter(ModelInfrastructureConfig::realTimeInferenceConfig)).setter(ModelInfrastructureConfig.setter(Builder::realTimeInferenceConfig)).constructor(RealTimeInferenceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RealTimeInferenceConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INFRASTRUCTURE_TYPE_FIELD, REAL_TIME_INFERENCE_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("InfrastructureType", INFRASTRUCTURE_TYPE_FIELD);
            this.put("RealTimeInferenceConfig", REAL_TIME_INFERENCE_CONFIG_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String infrastructureType;
    private final RealTimeInferenceConfig realTimeInferenceConfig;

    private ModelInfrastructureConfig(BuilderImpl builder) {
        this.infrastructureType = builder.infrastructureType;
        this.realTimeInferenceConfig = builder.realTimeInferenceConfig;
    }

    public final ModelInfrastructureType infrastructureType() {
        return ModelInfrastructureType.fromValue(this.infrastructureType);
    }

    public final String infrastructureTypeAsString() {
        return this.infrastructureType;
    }

    public final RealTimeInferenceConfig realTimeInferenceConfig() {
        return this.realTimeInferenceConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.infrastructureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.realTimeInferenceConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelInfrastructureConfig)) {
            return false;
        }
        ModelInfrastructureConfig other = (ModelInfrastructureConfig)obj;
        return Objects.equals(this.infrastructureTypeAsString(), other.infrastructureTypeAsString()) && Objects.equals(this.realTimeInferenceConfig(), other.realTimeInferenceConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ModelInfrastructureConfig").add("InfrastructureType", (Object)this.infrastructureTypeAsString()).add("RealTimeInferenceConfig", (Object)this.realTimeInferenceConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "InfrastructureType": {
                return Optional.ofNullable(clazz.cast(this.infrastructureTypeAsString()));
            }
            case "RealTimeInferenceConfig": {
                return Optional.ofNullable(clazz.cast(this.realTimeInferenceConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ModelInfrastructureConfig, T> g) {
        return obj -> g.apply((ModelInfrastructureConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String infrastructureType;
        private RealTimeInferenceConfig realTimeInferenceConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelInfrastructureConfig model) {
            this.infrastructureType(model.infrastructureType);
            this.realTimeInferenceConfig(model.realTimeInferenceConfig);
        }

        public final String getInfrastructureType() {
            return this.infrastructureType;
        }

        public final void setInfrastructureType(String infrastructureType) {
            this.infrastructureType = infrastructureType;
        }

        @Override
        public final Builder infrastructureType(String infrastructureType) {
            this.infrastructureType = infrastructureType;
            return this;
        }

        @Override
        public final Builder infrastructureType(ModelInfrastructureType infrastructureType) {
            this.infrastructureType(infrastructureType == null ? null : infrastructureType.toString());
            return this;
        }

        public final RealTimeInferenceConfig.Builder getRealTimeInferenceConfig() {
            return this.realTimeInferenceConfig != null ? this.realTimeInferenceConfig.toBuilder() : null;
        }

        public final void setRealTimeInferenceConfig(RealTimeInferenceConfig.BuilderImpl realTimeInferenceConfig) {
            this.realTimeInferenceConfig = realTimeInferenceConfig != null ? realTimeInferenceConfig.build() : null;
        }

        @Override
        public final Builder realTimeInferenceConfig(RealTimeInferenceConfig realTimeInferenceConfig) {
            this.realTimeInferenceConfig = realTimeInferenceConfig;
            return this;
        }

        public ModelInfrastructureConfig build() {
            return new ModelInfrastructureConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelInfrastructureConfig> {
        public Builder infrastructureType(String var1);

        public Builder infrastructureType(ModelInfrastructureType var1);

        public Builder realTimeInferenceConfig(RealTimeInferenceConfig var1);

        default public Builder realTimeInferenceConfig(Consumer<RealTimeInferenceConfig.Builder> realTimeInferenceConfig) {
            return this.realTimeInferenceConfig((RealTimeInferenceConfig)((RealTimeInferenceConfig.Builder)RealTimeInferenceConfig.builder().applyMutation(realTimeInferenceConfig)).build());
        }
    }
}

