/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.CustomImageContainerArgumentsCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomImageContainerEntrypointCopier;
import software.amazon.awssdk.services.sagemaker.model.CustomImageContainerEnvironmentVariablesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerConfig> {
    private static final SdkField<List<String>> CONTAINER_ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerArguments").getter(ContainerConfig.getter(ContainerConfig::containerArguments)).setter(ContainerConfig.setter(Builder::containerArguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerArguments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> CONTAINER_ENTRYPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContainerEntrypoint").getter(ContainerConfig.getter(ContainerConfig::containerEntrypoint)).setter(ContainerConfig.setter(Builder::containerEntrypoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEntrypoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> CONTAINER_ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("ContainerEnvironmentVariables").getter(ContainerConfig.getter(ContainerConfig::containerEnvironmentVariables)).setter(ContainerConfig.setter(Builder::containerEnvironmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainerEnvironmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTAINER_ARGUMENTS_FIELD, CONTAINER_ENTRYPOINT_FIELD, CONTAINER_ENVIRONMENT_VARIABLES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ContainerArguments", CONTAINER_ARGUMENTS_FIELD);
            this.put("ContainerEntrypoint", CONTAINER_ENTRYPOINT_FIELD);
            this.put("ContainerEnvironmentVariables", CONTAINER_ENVIRONMENT_VARIABLES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> containerArguments;
    private final List<String> containerEntrypoint;
    private final Map<String, String> containerEnvironmentVariables;

    private ContainerConfig(BuilderImpl builder) {
        this.containerArguments = builder.containerArguments;
        this.containerEntrypoint = builder.containerEntrypoint;
        this.containerEnvironmentVariables = builder.containerEnvironmentVariables;
    }

    public final boolean hasContainerArguments() {
        return this.containerArguments != null && !(this.containerArguments instanceof SdkAutoConstructList);
    }

    public final List<String> containerArguments() {
        return this.containerArguments;
    }

    public final boolean hasContainerEntrypoint() {
        return this.containerEntrypoint != null && !(this.containerEntrypoint instanceof SdkAutoConstructList);
    }

    public final List<String> containerEntrypoint() {
        return this.containerEntrypoint;
    }

    public final boolean hasContainerEnvironmentVariables() {
        return this.containerEnvironmentVariables != null && !(this.containerEnvironmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> containerEnvironmentVariables() {
        return this.containerEnvironmentVariables;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerArguments() ? this.containerArguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerEntrypoint() ? this.containerEntrypoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContainerEnvironmentVariables() ? this.containerEnvironmentVariables() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerConfig)) {
            return false;
        }
        ContainerConfig other = (ContainerConfig)obj;
        return this.hasContainerArguments() == other.hasContainerArguments() && Objects.equals(this.containerArguments(), other.containerArguments()) && this.hasContainerEntrypoint() == other.hasContainerEntrypoint() && Objects.equals(this.containerEntrypoint(), other.containerEntrypoint()) && this.hasContainerEnvironmentVariables() == other.hasContainerEnvironmentVariables() && Objects.equals(this.containerEnvironmentVariables(), other.containerEnvironmentVariables());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerConfig").add("ContainerArguments", this.hasContainerArguments() ? this.containerArguments() : null).add("ContainerEntrypoint", this.hasContainerEntrypoint() ? this.containerEntrypoint() : null).add("ContainerEnvironmentVariables", this.hasContainerEnvironmentVariables() ? this.containerEnvironmentVariables() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ContainerArguments": {
                return Optional.ofNullable(clazz.cast(this.containerArguments()));
            }
            case "ContainerEntrypoint": {
                return Optional.ofNullable(clazz.cast(this.containerEntrypoint()));
            }
            case "ContainerEnvironmentVariables": {
                return Optional.ofNullable(clazz.cast(this.containerEnvironmentVariables()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ContainerConfig, T> g) {
        return obj -> g.apply((ContainerConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> containerArguments = DefaultSdkAutoConstructList.getInstance();
        private List<String> containerEntrypoint = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> containerEnvironmentVariables = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerConfig model) {
            this.containerArguments(model.containerArguments);
            this.containerEntrypoint(model.containerEntrypoint);
            this.containerEnvironmentVariables(model.containerEnvironmentVariables);
        }

        public final Collection<String> getContainerArguments() {
            if (this.containerArguments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerArguments;
        }

        public final void setContainerArguments(Collection<String> containerArguments) {
            this.containerArguments = CustomImageContainerArgumentsCopier.copy(containerArguments);
        }

        @Override
        public final Builder containerArguments(Collection<String> containerArguments) {
            this.containerArguments = CustomImageContainerArgumentsCopier.copy(containerArguments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerArguments(String ... containerArguments) {
            this.containerArguments(Arrays.asList(containerArguments));
            return this;
        }

        public final Collection<String> getContainerEntrypoint() {
            if (this.containerEntrypoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.containerEntrypoint;
        }

        public final void setContainerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = CustomImageContainerEntrypointCopier.copy(containerEntrypoint);
        }

        @Override
        public final Builder containerEntrypoint(Collection<String> containerEntrypoint) {
            this.containerEntrypoint = CustomImageContainerEntrypointCopier.copy(containerEntrypoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder containerEntrypoint(String ... containerEntrypoint) {
            this.containerEntrypoint(Arrays.asList(containerEntrypoint));
            return this;
        }

        public final Map<String, String> getContainerEnvironmentVariables() {
            if (this.containerEnvironmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.containerEnvironmentVariables;
        }

        public final void setContainerEnvironmentVariables(Map<String, String> containerEnvironmentVariables) {
            this.containerEnvironmentVariables = CustomImageContainerEnvironmentVariablesCopier.copy(containerEnvironmentVariables);
        }

        @Override
        public final Builder containerEnvironmentVariables(Map<String, String> containerEnvironmentVariables) {
            this.containerEnvironmentVariables = CustomImageContainerEnvironmentVariablesCopier.copy(containerEnvironmentVariables);
            return this;
        }

        public ContainerConfig build() {
            return new ContainerConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerConfig> {
        public Builder containerArguments(Collection<String> var1);

        public Builder containerArguments(String ... var1);

        public Builder containerEntrypoint(Collection<String> var1);

        public Builder containerEntrypoint(String ... var1);

        public Builder containerEnvironmentVariables(Map<String, String> var1);
    }
}

