/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelPackageGroupsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelPackageGroupSummary;

public class ListModelPackageGroupsPublisher
implements SdkPublisher<ListModelPackageGroupsResponse> {
    private final SageMakerAsyncClient client;
    private final ListModelPackageGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListModelPackageGroupsPublisher(SageMakerAsyncClient client, ListModelPackageGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListModelPackageGroupsPublisher(SageMakerAsyncClient client, ListModelPackageGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListModelPackageGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListModelPackageGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ModelPackageGroupSummary> modelPackageGroupSummaryList() {
        Function<ListModelPackageGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelPackageGroupSummaryList() != null) {
                return response.modelPackageGroupSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListModelPackageGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListModelPackageGroupsResponseFetcher
    implements AsyncPageFetcher<ListModelPackageGroupsResponse> {
        private ListModelPackageGroupsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelPackageGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListModelPackageGroupsResponse> nextPage(ListModelPackageGroupsResponse previousPage) {
            if (previousPage == null) {
                return ListModelPackageGroupsPublisher.this.client.listModelPackageGroups(ListModelPackageGroupsPublisher.this.firstRequest);
            }
            return ListModelPackageGroupsPublisher.this.client.listModelPackageGroups((ListModelPackageGroupsRequest)((Object)ListModelPackageGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

