/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageRequest;
import software.amazon.awssdk.services.sagemaker.model.QueryLineageResponse;

public class QueryLineageIterable
implements SdkIterable<QueryLineageResponse> {
    private final SageMakerClient client;
    private final QueryLineageRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public QueryLineageIterable(SageMakerClient client, QueryLineageRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new QueryLineageResponseFetcher();
    }

    public Iterator<QueryLineageResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class QueryLineageResponseFetcher
    implements SyncPageFetcher<QueryLineageResponse> {
        private QueryLineageResponseFetcher() {
        }

        public boolean hasNextPage(QueryLineageResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public QueryLineageResponse nextPage(QueryLineageResponse previousPage) {
            if (previousPage == null) {
                return QueryLineageIterable.this.client.queryLineage(QueryLineageIterable.this.firstRequest);
            }
            return QueryLineageIterable.this.client.queryLineage((QueryLineageRequest)((Object)QueryLineageIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

