/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfig;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceStorageConfigsCopier;
import software.amazon.awssdk.services.sagemaker.model.ClusterInstanceType;
import software.amazon.awssdk.services.sagemaker.model.ClusterLifeCycleConfig;
import software.amazon.awssdk.services.sagemaker.model.DeepHealthCheckType;
import software.amazon.awssdk.services.sagemaker.model.OnStartDeepHealthChecksCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ClusterInstanceGroupDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ClusterInstanceGroupDetails> {
    private static final SdkField<Integer> CURRENT_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("CurrentCount").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::currentCount)).setter(ClusterInstanceGroupDetails.setter(Builder::currentCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentCount").build()}).build();
    private static final SdkField<Integer> TARGET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("TargetCount").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::targetCount)).setter(ClusterInstanceGroupDetails.setter(Builder::targetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCount").build()}).build();
    private static final SdkField<String> INSTANCE_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceGroupName").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::instanceGroupName)).setter(ClusterInstanceGroupDetails.setter(Builder::instanceGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceGroupName").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceType").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::instanceTypeAsString)).setter(ClusterInstanceGroupDetails.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<ClusterLifeCycleConfig> LIFE_CYCLE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifeCycleConfig").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::lifeCycleConfig)).setter(ClusterInstanceGroupDetails.setter(Builder::lifeCycleConfig)).constructor(ClusterLifeCycleConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleConfig").build()}).build();
    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExecutionRole").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::executionRole)).setter(ClusterInstanceGroupDetails.setter(Builder::executionRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionRole").build()}).build();
    private static final SdkField<Integer> THREADS_PER_CORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ThreadsPerCore").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::threadsPerCore)).setter(ClusterInstanceGroupDetails.setter(Builder::threadsPerCore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThreadsPerCore").build()}).build();
    private static final SdkField<List<ClusterInstanceStorageConfig>> INSTANCE_STORAGE_CONFIGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InstanceStorageConfigs").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::instanceStorageConfigs)).setter(ClusterInstanceGroupDetails.setter(Builder::instanceStorageConfigs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceStorageConfigs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ClusterInstanceStorageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ON_START_DEEP_HEALTH_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OnStartDeepHealthChecks").getter(ClusterInstanceGroupDetails.getter(ClusterInstanceGroupDetails::onStartDeepHealthChecksAsStrings)).setter(ClusterInstanceGroupDetails.setter(Builder::onStartDeepHealthChecksWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnStartDeepHealthChecks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CURRENT_COUNT_FIELD, TARGET_COUNT_FIELD, INSTANCE_GROUP_NAME_FIELD, INSTANCE_TYPE_FIELD, LIFE_CYCLE_CONFIG_FIELD, EXECUTION_ROLE_FIELD, THREADS_PER_CORE_FIELD, INSTANCE_STORAGE_CONFIGS_FIELD, ON_START_DEEP_HEALTH_CHECKS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer currentCount;
    private final Integer targetCount;
    private final String instanceGroupName;
    private final String instanceType;
    private final ClusterLifeCycleConfig lifeCycleConfig;
    private final String executionRole;
    private final Integer threadsPerCore;
    private final List<ClusterInstanceStorageConfig> instanceStorageConfigs;
    private final List<String> onStartDeepHealthChecks;

    private ClusterInstanceGroupDetails(BuilderImpl builder) {
        this.currentCount = builder.currentCount;
        this.targetCount = builder.targetCount;
        this.instanceGroupName = builder.instanceGroupName;
        this.instanceType = builder.instanceType;
        this.lifeCycleConfig = builder.lifeCycleConfig;
        this.executionRole = builder.executionRole;
        this.threadsPerCore = builder.threadsPerCore;
        this.instanceStorageConfigs = builder.instanceStorageConfigs;
        this.onStartDeepHealthChecks = builder.onStartDeepHealthChecks;
    }

    public final Integer currentCount() {
        return this.currentCount;
    }

    public final Integer targetCount() {
        return this.targetCount;
    }

    public final String instanceGroupName() {
        return this.instanceGroupName;
    }

    public final ClusterInstanceType instanceType() {
        return ClusterInstanceType.fromValue(this.instanceType);
    }

    public final String instanceTypeAsString() {
        return this.instanceType;
    }

    public final ClusterLifeCycleConfig lifeCycleConfig() {
        return this.lifeCycleConfig;
    }

    public final String executionRole() {
        return this.executionRole;
    }

    public final Integer threadsPerCore() {
        return this.threadsPerCore;
    }

    public final boolean hasInstanceStorageConfigs() {
        return this.instanceStorageConfigs != null && !(this.instanceStorageConfigs instanceof SdkAutoConstructList);
    }

    public final List<ClusterInstanceStorageConfig> instanceStorageConfigs() {
        return this.instanceStorageConfigs;
    }

    public final List<DeepHealthCheckType> onStartDeepHealthChecks() {
        return OnStartDeepHealthChecksCopier.copyStringToEnum(this.onStartDeepHealthChecks);
    }

    public final boolean hasOnStartDeepHealthChecks() {
        return this.onStartDeepHealthChecks != null && !(this.onStartDeepHealthChecks instanceof SdkAutoConstructList);
    }

    public final List<String> onStartDeepHealthChecksAsStrings() {
        return this.onStartDeepHealthChecks;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.currentCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycleConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.threadsPerCore());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ClusterInstanceGroupDetails)) {
            return false;
        }
        ClusterInstanceGroupDetails other = (ClusterInstanceGroupDetails)obj;
        return Objects.equals(this.currentCount(), other.currentCount()) && Objects.equals(this.targetCount(), other.targetCount()) && Objects.equals(this.instanceGroupName(), other.instanceGroupName()) && Objects.equals(this.instanceTypeAsString(), other.instanceTypeAsString()) && Objects.equals(this.lifeCycleConfig(), other.lifeCycleConfig()) && Objects.equals(this.executionRole(), other.executionRole()) && Objects.equals(this.threadsPerCore(), other.threadsPerCore()) && this.hasInstanceStorageConfigs() == other.hasInstanceStorageConfigs() && Objects.equals(this.instanceStorageConfigs(), other.instanceStorageConfigs()) && this.hasOnStartDeepHealthChecks() == other.hasOnStartDeepHealthChecks() && Objects.equals(this.onStartDeepHealthChecksAsStrings(), other.onStartDeepHealthChecksAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ClusterInstanceGroupDetails").add("CurrentCount", (Object)this.currentCount()).add("TargetCount", (Object)this.targetCount()).add("InstanceGroupName", (Object)this.instanceGroupName()).add("InstanceType", (Object)this.instanceTypeAsString()).add("LifeCycleConfig", (Object)this.lifeCycleConfig()).add("ExecutionRole", (Object)this.executionRole()).add("ThreadsPerCore", (Object)this.threadsPerCore()).add("InstanceStorageConfigs", this.hasInstanceStorageConfigs() ? this.instanceStorageConfigs() : null).add("OnStartDeepHealthChecks", this.hasOnStartDeepHealthChecks() ? this.onStartDeepHealthChecksAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CurrentCount": {
                return Optional.ofNullable(clazz.cast(this.currentCount()));
            }
            case "TargetCount": {
                return Optional.ofNullable(clazz.cast(this.targetCount()));
            }
            case "InstanceGroupName": {
                return Optional.ofNullable(clazz.cast(this.instanceGroupName()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceTypeAsString()));
            }
            case "LifeCycleConfig": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleConfig()));
            }
            case "ExecutionRole": {
                return Optional.ofNullable(clazz.cast(this.executionRole()));
            }
            case "ThreadsPerCore": {
                return Optional.ofNullable(clazz.cast(this.threadsPerCore()));
            }
            case "InstanceStorageConfigs": {
                return Optional.ofNullable(clazz.cast(this.instanceStorageConfigs()));
            }
            case "OnStartDeepHealthChecks": {
                return Optional.ofNullable(clazz.cast(this.onStartDeepHealthChecksAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ClusterInstanceGroupDetails, T> g) {
        return obj -> g.apply((ClusterInstanceGroupDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer currentCount;
        private Integer targetCount;
        private String instanceGroupName;
        private String instanceType;
        private ClusterLifeCycleConfig lifeCycleConfig;
        private String executionRole;
        private Integer threadsPerCore;
        private List<ClusterInstanceStorageConfig> instanceStorageConfigs = DefaultSdkAutoConstructList.getInstance();
        private List<String> onStartDeepHealthChecks = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ClusterInstanceGroupDetails model) {
            this.currentCount(model.currentCount);
            this.targetCount(model.targetCount);
            this.instanceGroupName(model.instanceGroupName);
            this.instanceType(model.instanceType);
            this.lifeCycleConfig(model.lifeCycleConfig);
            this.executionRole(model.executionRole);
            this.threadsPerCore(model.threadsPerCore);
            this.instanceStorageConfigs(model.instanceStorageConfigs);
            this.onStartDeepHealthChecksWithStrings(model.onStartDeepHealthChecks);
        }

        public final Integer getCurrentCount() {
            return this.currentCount;
        }

        public final void setCurrentCount(Integer currentCount) {
            this.currentCount = currentCount;
        }

        @Override
        public final Builder currentCount(Integer currentCount) {
            this.currentCount = currentCount;
            return this;
        }

        public final Integer getTargetCount() {
            return this.targetCount;
        }

        public final void setTargetCount(Integer targetCount) {
            this.targetCount = targetCount;
        }

        @Override
        public final Builder targetCount(Integer targetCount) {
            this.targetCount = targetCount;
            return this;
        }

        public final String getInstanceGroupName() {
            return this.instanceGroupName;
        }

        public final void setInstanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
        }

        @Override
        public final Builder instanceGroupName(String instanceGroupName) {
            this.instanceGroupName = instanceGroupName;
            return this;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(ClusterInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final ClusterLifeCycleConfig.Builder getLifeCycleConfig() {
            return this.lifeCycleConfig != null ? this.lifeCycleConfig.toBuilder() : null;
        }

        public final void setLifeCycleConfig(ClusterLifeCycleConfig.BuilderImpl lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig != null ? lifeCycleConfig.build() : null;
        }

        @Override
        public final Builder lifeCycleConfig(ClusterLifeCycleConfig lifeCycleConfig) {
            this.lifeCycleConfig = lifeCycleConfig;
            return this;
        }

        public final String getExecutionRole() {
            return this.executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getThreadsPerCore() {
            return this.threadsPerCore;
        }

        public final void setThreadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
        }

        @Override
        public final Builder threadsPerCore(Integer threadsPerCore) {
            this.threadsPerCore = threadsPerCore;
            return this;
        }

        public final List<ClusterInstanceStorageConfig.Builder> getInstanceStorageConfigs() {
            List<ClusterInstanceStorageConfig.Builder> result = ClusterInstanceStorageConfigsCopier.copyToBuilder(this.instanceStorageConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceStorageConfigs(Collection<ClusterInstanceStorageConfig.BuilderImpl> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copyFromBuilder(instanceStorageConfigs);
        }

        @Override
        public final Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> instanceStorageConfigs) {
            this.instanceStorageConfigs = ClusterInstanceStorageConfigsCopier.copy(instanceStorageConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Arrays.asList(instanceStorageConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... instanceStorageConfigs) {
            this.instanceStorageConfigs(Stream.of(instanceStorageConfigs).map(c -> (ClusterInstanceStorageConfig)((ClusterInstanceStorageConfig.Builder)ClusterInstanceStorageConfig.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOnStartDeepHealthChecks() {
            if (this.onStartDeepHealthChecks instanceof SdkAutoConstructList) {
                return null;
            }
            return this.onStartDeepHealthChecks;
        }

        public final void setOnStartDeepHealthChecks(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
        }

        @Override
        public final Builder onStartDeepHealthChecksWithStrings(Collection<String> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copy(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecksWithStrings(String ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecksWithStrings(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        @Override
        public final Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks = OnStartDeepHealthChecksCopier.copyEnumToString(onStartDeepHealthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder onStartDeepHealthChecks(DeepHealthCheckType ... onStartDeepHealthChecks) {
            this.onStartDeepHealthChecks(Arrays.asList(onStartDeepHealthChecks));
            return this;
        }

        public ClusterInstanceGroupDetails build() {
            return new ClusterInstanceGroupDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ClusterInstanceGroupDetails> {
        public Builder currentCount(Integer var1);

        public Builder targetCount(Integer var1);

        public Builder instanceGroupName(String var1);

        public Builder instanceType(String var1);

        public Builder instanceType(ClusterInstanceType var1);

        public Builder lifeCycleConfig(ClusterLifeCycleConfig var1);

        default public Builder lifeCycleConfig(Consumer<ClusterLifeCycleConfig.Builder> lifeCycleConfig) {
            return this.lifeCycleConfig((ClusterLifeCycleConfig)((ClusterLifeCycleConfig.Builder)ClusterLifeCycleConfig.builder().applyMutation(lifeCycleConfig)).build());
        }

        public Builder executionRole(String var1);

        public Builder threadsPerCore(Integer var1);

        public Builder instanceStorageConfigs(Collection<ClusterInstanceStorageConfig> var1);

        public Builder instanceStorageConfigs(ClusterInstanceStorageConfig ... var1);

        public Builder instanceStorageConfigs(Consumer<ClusterInstanceStorageConfig.Builder> ... var1);

        public Builder onStartDeepHealthChecksWithStrings(Collection<String> var1);

        public Builder onStartDeepHealthChecksWithStrings(String ... var1);

        public Builder onStartDeepHealthChecks(Collection<DeepHealthCheckType> var1);

        public Builder onStartDeepHealthChecks(DeepHealthCheckType ... var1);
    }
}

