/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ClarifyTextLanguage {
    AF("af"),
    SQ("sq"),
    AR("ar"),
    HY("hy"),
    EU("eu"),
    BN("bn"),
    BG("bg"),
    CA("ca"),
    ZH("zh"),
    HR("hr"),
    CS("cs"),
    DA("da"),
    NL("nl"),
    EN("en"),
    ET("et"),
    FI("fi"),
    FR("fr"),
    DE("de"),
    EL("el"),
    GU("gu"),
    HE("he"),
    HI("hi"),
    HU("hu"),
    IS("is"),
    ID("id"),
    GA("ga"),
    IT("it"),
    KN("kn"),
    KY("ky"),
    LV("lv"),
    LT("lt"),
    LB("lb"),
    MK("mk"),
    ML("ml"),
    MR("mr"),
    NE("ne"),
    NB("nb"),
    FA("fa"),
    PL("pl"),
    PT("pt"),
    RO("ro"),
    RU("ru"),
    SA("sa"),
    SR("sr"),
    TN("tn"),
    SI("si"),
    SK("sk"),
    SL("sl"),
    ES("es"),
    SV("sv"),
    TL("tl"),
    TA("ta"),
    TT("tt"),
    TE("te"),
    TR("tr"),
    UK("uk"),
    UR("ur"),
    YO("yo"),
    LIJ("lij"),
    XX("xx"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClarifyTextLanguage> VALUE_MAP;
    private final String value;

    private ClarifyTextLanguage(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ClarifyTextLanguage fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ClarifyTextLanguage> knownValues() {
        EnumSet<ClarifyTextLanguage> knownValues = EnumSet.allOf(ClarifyTextLanguage.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ClarifyTextLanguage.class, ClarifyTextLanguage::toString);
    }
}

