/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.OwnershipSettingsSummary;
import software.amazon.awssdk.services.sagemaker.model.SpaceSettingsSummary;
import software.amazon.awssdk.services.sagemaker.model.SpaceSharingSettingsSummary;
import software.amazon.awssdk.services.sagemaker.model.SpaceStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SpaceDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SpaceDetails> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DomainId").getter(SpaceDetails.getter(SpaceDetails::domainId)).setter(SpaceDetails.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()}).build();
    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceName").getter(SpaceDetails.getter(SpaceDetails::spaceName)).setter(SpaceDetails.setter(Builder::spaceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(SpaceDetails.getter(SpaceDetails::statusAsString)).setter(SpaceDetails.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(SpaceDetails.getter(SpaceDetails::creationTime)).setter(SpaceDetails.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(SpaceDetails.getter(SpaceDetails::lastModifiedTime)).setter(SpaceDetails.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<SpaceSettingsSummary> SPACE_SETTINGS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceSettingsSummary").getter(SpaceDetails.getter(SpaceDetails::spaceSettingsSummary)).setter(SpaceDetails.setter(Builder::spaceSettingsSummary)).constructor(SpaceSettingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettingsSummary").build()}).build();
    private static final SdkField<SpaceSharingSettingsSummary> SPACE_SHARING_SETTINGS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SpaceSharingSettingsSummary").getter(SpaceDetails.getter(SpaceDetails::spaceSharingSettingsSummary)).setter(SpaceDetails.setter(Builder::spaceSharingSettingsSummary)).constructor(SpaceSharingSettingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSharingSettingsSummary").build()}).build();
    private static final SdkField<OwnershipSettingsSummary> OWNERSHIP_SETTINGS_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OwnershipSettingsSummary").getter(SpaceDetails.getter(SpaceDetails::ownershipSettingsSummary)).setter(SpaceDetails.setter(Builder::ownershipSettingsSummary)).constructor(OwnershipSettingsSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnershipSettingsSummary").build()}).build();
    private static final SdkField<String> SPACE_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SpaceDisplayName").getter(SpaceDetails.getter(SpaceDetails::spaceDisplayName)).setter(SpaceDetails.setter(Builder::spaceDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceDisplayName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, SPACE_NAME_FIELD, STATUS_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, SPACE_SETTINGS_SUMMARY_FIELD, SPACE_SHARING_SETTINGS_SUMMARY_FIELD, OWNERSHIP_SETTINGS_SUMMARY_FIELD, SPACE_DISPLAY_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String domainId;
    private final String spaceName;
    private final String status;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final SpaceSettingsSummary spaceSettingsSummary;
    private final SpaceSharingSettingsSummary spaceSharingSettingsSummary;
    private final OwnershipSettingsSummary ownershipSettingsSummary;
    private final String spaceDisplayName;

    private SpaceDetails(BuilderImpl builder) {
        this.domainId = builder.domainId;
        this.spaceName = builder.spaceName;
        this.status = builder.status;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.spaceSettingsSummary = builder.spaceSettingsSummary;
        this.spaceSharingSettingsSummary = builder.spaceSharingSettingsSummary;
        this.ownershipSettingsSummary = builder.ownershipSettingsSummary;
        this.spaceDisplayName = builder.spaceDisplayName;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String spaceName() {
        return this.spaceName;
    }

    public final SpaceStatus status() {
        return SpaceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public final SpaceSettingsSummary spaceSettingsSummary() {
        return this.spaceSettingsSummary;
    }

    public final SpaceSharingSettingsSummary spaceSharingSettingsSummary() {
        return this.spaceSharingSettingsSummary;
    }

    public final OwnershipSettingsSummary ownershipSettingsSummary() {
        return this.ownershipSettingsSummary;
    }

    public final String spaceDisplayName() {
        return this.spaceDisplayName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceSettingsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceSharingSettingsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownershipSettingsSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.spaceDisplayName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpaceDetails)) {
            return false;
        }
        SpaceDetails other = (SpaceDetails)obj;
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.spaceName(), other.spaceName()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.spaceSettingsSummary(), other.spaceSettingsSummary()) && Objects.equals(this.spaceSharingSettingsSummary(), other.spaceSharingSettingsSummary()) && Objects.equals(this.ownershipSettingsSummary(), other.ownershipSettingsSummary()) && Objects.equals(this.spaceDisplayName(), other.spaceDisplayName());
    }

    public final String toString() {
        return ToString.builder((String)"SpaceDetails").add("DomainId", (Object)this.domainId()).add("SpaceName", (Object)this.spaceName()).add("Status", (Object)this.statusAsString()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("SpaceSettingsSummary", (Object)this.spaceSettingsSummary()).add("SpaceSharingSettingsSummary", (Object)this.spaceSharingSettingsSummary()).add("OwnershipSettingsSummary", (Object)this.ownershipSettingsSummary()).add("SpaceDisplayName", (Object)this.spaceDisplayName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "SpaceName": {
                return Optional.ofNullable(clazz.cast(this.spaceName()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "SpaceSettingsSummary": {
                return Optional.ofNullable(clazz.cast(this.spaceSettingsSummary()));
            }
            case "SpaceSharingSettingsSummary": {
                return Optional.ofNullable(clazz.cast(this.spaceSharingSettingsSummary()));
            }
            case "OwnershipSettingsSummary": {
                return Optional.ofNullable(clazz.cast(this.ownershipSettingsSummary()));
            }
            case "SpaceDisplayName": {
                return Optional.ofNullable(clazz.cast(this.spaceDisplayName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SpaceDetails, T> g) {
        return obj -> g.apply((SpaceDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String domainId;
        private String spaceName;
        private String status;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private SpaceSettingsSummary spaceSettingsSummary;
        private SpaceSharingSettingsSummary spaceSharingSettingsSummary;
        private OwnershipSettingsSummary ownershipSettingsSummary;
        private String spaceDisplayName;

        private BuilderImpl() {
        }

        private BuilderImpl(SpaceDetails model) {
            this.domainId(model.domainId);
            this.spaceName(model.spaceName);
            this.status(model.status);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.spaceSettingsSummary(model.spaceSettingsSummary);
            this.spaceSharingSettingsSummary(model.spaceSharingSettingsSummary);
            this.ownershipSettingsSummary(model.ownershipSettingsSummary);
            this.spaceDisplayName(model.spaceDisplayName);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceName() {
            return this.spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SpaceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final SpaceSettingsSummary.Builder getSpaceSettingsSummary() {
            return this.spaceSettingsSummary != null ? this.spaceSettingsSummary.toBuilder() : null;
        }

        public final void setSpaceSettingsSummary(SpaceSettingsSummary.BuilderImpl spaceSettingsSummary) {
            this.spaceSettingsSummary = spaceSettingsSummary != null ? spaceSettingsSummary.build() : null;
        }

        @Override
        public final Builder spaceSettingsSummary(SpaceSettingsSummary spaceSettingsSummary) {
            this.spaceSettingsSummary = spaceSettingsSummary;
            return this;
        }

        public final SpaceSharingSettingsSummary.Builder getSpaceSharingSettingsSummary() {
            return this.spaceSharingSettingsSummary != null ? this.spaceSharingSettingsSummary.toBuilder() : null;
        }

        public final void setSpaceSharingSettingsSummary(SpaceSharingSettingsSummary.BuilderImpl spaceSharingSettingsSummary) {
            this.spaceSharingSettingsSummary = spaceSharingSettingsSummary != null ? spaceSharingSettingsSummary.build() : null;
        }

        @Override
        public final Builder spaceSharingSettingsSummary(SpaceSharingSettingsSummary spaceSharingSettingsSummary) {
            this.spaceSharingSettingsSummary = spaceSharingSettingsSummary;
            return this;
        }

        public final OwnershipSettingsSummary.Builder getOwnershipSettingsSummary() {
            return this.ownershipSettingsSummary != null ? this.ownershipSettingsSummary.toBuilder() : null;
        }

        public final void setOwnershipSettingsSummary(OwnershipSettingsSummary.BuilderImpl ownershipSettingsSummary) {
            this.ownershipSettingsSummary = ownershipSettingsSummary != null ? ownershipSettingsSummary.build() : null;
        }

        @Override
        public final Builder ownershipSettingsSummary(OwnershipSettingsSummary ownershipSettingsSummary) {
            this.ownershipSettingsSummary = ownershipSettingsSummary;
            return this;
        }

        public final String getSpaceDisplayName() {
            return this.spaceDisplayName;
        }

        public final void setSpaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
        }

        @Override
        public final Builder spaceDisplayName(String spaceDisplayName) {
            this.spaceDisplayName = spaceDisplayName;
            return this;
        }

        public SpaceDetails build() {
            return new SpaceDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SpaceDetails> {
        public Builder domainId(String var1);

        public Builder spaceName(String var1);

        public Builder status(String var1);

        public Builder status(SpaceStatus var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder spaceSettingsSummary(SpaceSettingsSummary var1);

        default public Builder spaceSettingsSummary(Consumer<SpaceSettingsSummary.Builder> spaceSettingsSummary) {
            return this.spaceSettingsSummary((SpaceSettingsSummary)((SpaceSettingsSummary.Builder)SpaceSettingsSummary.builder().applyMutation(spaceSettingsSummary)).build());
        }

        public Builder spaceSharingSettingsSummary(SpaceSharingSettingsSummary var1);

        default public Builder spaceSharingSettingsSummary(Consumer<SpaceSharingSettingsSummary.Builder> spaceSharingSettingsSummary) {
            return this.spaceSharingSettingsSummary((SpaceSharingSettingsSummary)((SpaceSharingSettingsSummary.Builder)SpaceSharingSettingsSummary.builder().applyMutation(spaceSharingSettingsSummary)).build());
        }

        public Builder ownershipSettingsSummary(OwnershipSettingsSummary var1);

        default public Builder ownershipSettingsSummary(Consumer<OwnershipSettingsSummary.Builder> ownershipSettingsSummary) {
            return this.ownershipSettingsSummary((OwnershipSettingsSummary)((OwnershipSettingsSummary.Builder)OwnershipSettingsSummary.builder().applyMutation(ownershipSettingsSummary)).build());
        }

        public Builder spaceDisplayName(String var1);
    }
}

