/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersRequest;
import software.amazon.awssdk.services.sagemaker.model.ListMlflowTrackingServersResponse;
import software.amazon.awssdk.services.sagemaker.model.TrackingServerSummary;

public class ListMlflowTrackingServersPublisher
implements SdkPublisher<ListMlflowTrackingServersResponse> {
    private final SageMakerAsyncClient client;
    private final ListMlflowTrackingServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListMlflowTrackingServersPublisher(SageMakerAsyncClient client, ListMlflowTrackingServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListMlflowTrackingServersPublisher(SageMakerAsyncClient client, ListMlflowTrackingServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListMlflowTrackingServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListMlflowTrackingServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TrackingServerSummary> trackingServerSummaries() {
        Function<ListMlflowTrackingServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.trackingServerSummaries() != null) {
                return response.trackingServerSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListMlflowTrackingServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListMlflowTrackingServersResponseFetcher
    implements AsyncPageFetcher<ListMlflowTrackingServersResponse> {
        private ListMlflowTrackingServersResponseFetcher() {
        }

        public boolean hasNextPage(ListMlflowTrackingServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListMlflowTrackingServersResponse> nextPage(ListMlflowTrackingServersResponse previousPage) {
            if (previousPage == null) {
                return ListMlflowTrackingServersPublisher.this.client.listMlflowTrackingServers(ListMlflowTrackingServersPublisher.this.firstRequest);
            }
            return ListMlflowTrackingServersPublisher.this.client.listMlflowTrackingServers((ListMlflowTrackingServersRequest)((Object)ListMlflowTrackingServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

