/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListModelCardVersionsResponse;
import software.amazon.awssdk.services.sagemaker.model.ModelCardVersionSummary;

public class ListModelCardVersionsIterable
implements SdkIterable<ListModelCardVersionsResponse> {
    private final SageMakerClient client;
    private final ListModelCardVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListModelCardVersionsIterable(SageMakerClient client, ListModelCardVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListModelCardVersionsResponseFetcher();
    }

    public Iterator<ListModelCardVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ModelCardVersionSummary> modelCardVersionSummaryList() {
        Function<ListModelCardVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.modelCardVersionSummaryList() != null) {
                return response.modelCardVersionSummaryList().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListModelCardVersionsResponseFetcher
    implements SyncPageFetcher<ListModelCardVersionsResponse> {
        private ListModelCardVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListModelCardVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListModelCardVersionsResponse nextPage(ListModelCardVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListModelCardVersionsIterable.this.client.listModelCardVersions(ListModelCardVersionsIterable.this.firstRequest);
            }
            return ListModelCardVersionsIterable.this.client.listModelCardVersions((ListModelCardVersionsRequest)((Object)ListModelCardVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

