/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the serverless update concurrency configuration for an endpoint variant.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProductionVariantServerlessUpdateConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<ProductionVariantServerlessUpdateConfig.Builder, ProductionVariantServerlessUpdateConfig> {
    private static final SdkField<Integer> MAX_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrency").getter(getter(ProductionVariantServerlessUpdateConfig::maxConcurrency))
            .setter(setter(Builder::maxConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrency").build()).build();

    private static final SdkField<Integer> PROVISIONED_CONCURRENCY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ProvisionedConcurrency").getter(getter(ProductionVariantServerlessUpdateConfig::provisionedConcurrency))
            .setter(setter(Builder::provisionedConcurrency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisionedConcurrency").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_CONCURRENCY_FIELD,
            PROVISIONED_CONCURRENCY_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer maxConcurrency;

    private final Integer provisionedConcurrency;

    private ProductionVariantServerlessUpdateConfig(BuilderImpl builder) {
        this.maxConcurrency = builder.maxConcurrency;
        this.provisionedConcurrency = builder.provisionedConcurrency;
    }

    /**
     * <p>
     * The updated maximum number of concurrent invocations your serverless endpoint can process.
     * </p>
     * 
     * @return The updated maximum number of concurrent invocations your serverless endpoint can process.
     */
    public final Integer maxConcurrency() {
        return maxConcurrency;
    }

    /**
     * <p>
     * The updated amount of provisioned concurrency to allocate for the serverless endpoint. Should be less than or
     * equal to <code>MaxConcurrency</code>.
     * </p>
     * 
     * @return The updated amount of provisioned concurrency to allocate for the serverless endpoint. Should be less
     *         than or equal to <code>MaxConcurrency</code>.
     */
    public final Integer provisionedConcurrency() {
        return provisionedConcurrency;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrency());
        hashCode = 31 * hashCode + Objects.hashCode(provisionedConcurrency());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProductionVariantServerlessUpdateConfig)) {
            return false;
        }
        ProductionVariantServerlessUpdateConfig other = (ProductionVariantServerlessUpdateConfig) obj;
        return Objects.equals(maxConcurrency(), other.maxConcurrency())
                && Objects.equals(provisionedConcurrency(), other.provisionedConcurrency());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProductionVariantServerlessUpdateConfig").add("MaxConcurrency", maxConcurrency())
                .add("ProvisionedConcurrency", provisionedConcurrency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MaxConcurrency":
            return Optional.ofNullable(clazz.cast(maxConcurrency()));
        case "ProvisionedConcurrency":
            return Optional.ofNullable(clazz.cast(provisionedConcurrency()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProductionVariantServerlessUpdateConfig, T> g) {
        return obj -> g.apply((ProductionVariantServerlessUpdateConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProductionVariantServerlessUpdateConfig> {
        /**
         * <p>
         * The updated maximum number of concurrent invocations your serverless endpoint can process.
         * </p>
         * 
         * @param maxConcurrency
         *        The updated maximum number of concurrent invocations your serverless endpoint can process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrency(Integer maxConcurrency);

        /**
         * <p>
         * The updated amount of provisioned concurrency to allocate for the serverless endpoint. Should be less than or
         * equal to <code>MaxConcurrency</code>.
         * </p>
         * 
         * @param provisionedConcurrency
         *        The updated amount of provisioned concurrency to allocate for the serverless endpoint. Should be less
         *        than or equal to <code>MaxConcurrency</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder provisionedConcurrency(Integer provisionedConcurrency);
    }

    static final class BuilderImpl implements Builder {
        private Integer maxConcurrency;

        private Integer provisionedConcurrency;

        private BuilderImpl() {
        }

        private BuilderImpl(ProductionVariantServerlessUpdateConfig model) {
            maxConcurrency(model.maxConcurrency);
            provisionedConcurrency(model.provisionedConcurrency);
        }

        public final Integer getMaxConcurrency() {
            return maxConcurrency;
        }

        public final void setMaxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
        }

        @Override
        public final Builder maxConcurrency(Integer maxConcurrency) {
            this.maxConcurrency = maxConcurrency;
            return this;
        }

        public final Integer getProvisionedConcurrency() {
            return provisionedConcurrency;
        }

        public final void setProvisionedConcurrency(Integer provisionedConcurrency) {
            this.provisionedConcurrency = provisionedConcurrency;
        }

        @Override
        public final Builder provisionedConcurrency(Integer provisionedConcurrency) {
            this.provisionedConcurrency = provisionedConcurrency;
            return this;
        }

        @Override
        public ProductionVariantServerlessUpdateConfig build() {
            return new ProductionVariantServerlessUpdateConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
