/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A collection of settings that configure the domain's Docker interaction.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DockerSettings implements SdkPojo, Serializable, ToCopyableBuilder<DockerSettings.Builder, DockerSettings> {
    private static final SdkField<String> ENABLE_DOCKER_ACCESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EnableDockerAccess").getter(getter(DockerSettings::enableDockerAccessAsString))
            .setter(setter(Builder::enableDockerAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDockerAccess").build())
            .build();

    private static final SdkField<List<String>> VPC_ONLY_TRUSTED_ACCOUNTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VpcOnlyTrustedAccounts")
            .getter(getter(DockerSettings::vpcOnlyTrustedAccounts))
            .setter(setter(Builder::vpcOnlyTrustedAccounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcOnlyTrustedAccounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_DOCKER_ACCESS_FIELD,
            VPC_ONLY_TRUSTED_ACCOUNTS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String enableDockerAccess;

    private final List<String> vpcOnlyTrustedAccounts;

    private DockerSettings(BuilderImpl builder) {
        this.enableDockerAccess = builder.enableDockerAccess;
        this.vpcOnlyTrustedAccounts = builder.vpcOnlyTrustedAccounts;
    }

    /**
     * <p>
     * Indicates whether the domain can access Docker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enableDockerAccess} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #enableDockerAccessAsString}.
     * </p>
     * 
     * @return Indicates whether the domain can access Docker.
     * @see FeatureStatus
     */
    public final FeatureStatus enableDockerAccess() {
        return FeatureStatus.fromValue(enableDockerAccess);
    }

    /**
     * <p>
     * Indicates whether the domain can access Docker.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #enableDockerAccess} will return {@link FeatureStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #enableDockerAccessAsString}.
     * </p>
     * 
     * @return Indicates whether the domain can access Docker.
     * @see FeatureStatus
     */
    public final String enableDockerAccessAsString() {
        return enableDockerAccess;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcOnlyTrustedAccounts property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcOnlyTrustedAccounts() {
        return vpcOnlyTrustedAccounts != null && !(vpcOnlyTrustedAccounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of Amazon Web Services accounts that are trusted when the domain is created in VPC-only mode.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcOnlyTrustedAccounts} method.
     * </p>
     * 
     * @return The list of Amazon Web Services accounts that are trusted when the domain is created in VPC-only mode.
     */
    public final List<String> vpcOnlyTrustedAccounts() {
        return vpcOnlyTrustedAccounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableDockerAccessAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcOnlyTrustedAccounts() ? vpcOnlyTrustedAccounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DockerSettings)) {
            return false;
        }
        DockerSettings other = (DockerSettings) obj;
        return Objects.equals(enableDockerAccessAsString(), other.enableDockerAccessAsString())
                && hasVpcOnlyTrustedAccounts() == other.hasVpcOnlyTrustedAccounts()
                && Objects.equals(vpcOnlyTrustedAccounts(), other.vpcOnlyTrustedAccounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DockerSettings").add("EnableDockerAccess", enableDockerAccessAsString())
                .add("VpcOnlyTrustedAccounts", hasVpcOnlyTrustedAccounts() ? vpcOnlyTrustedAccounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableDockerAccess":
            return Optional.ofNullable(clazz.cast(enableDockerAccessAsString()));
        case "VpcOnlyTrustedAccounts":
            return Optional.ofNullable(clazz.cast(vpcOnlyTrustedAccounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DockerSettings, T> g) {
        return obj -> g.apply((DockerSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DockerSettings> {
        /**
         * <p>
         * Indicates whether the domain can access Docker.
         * </p>
         * 
         * @param enableDockerAccess
         *        Indicates whether the domain can access Docker.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder enableDockerAccess(String enableDockerAccess);

        /**
         * <p>
         * Indicates whether the domain can access Docker.
         * </p>
         * 
         * @param enableDockerAccess
         *        Indicates whether the domain can access Docker.
         * @see FeatureStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FeatureStatus
         */
        Builder enableDockerAccess(FeatureStatus enableDockerAccess);

        /**
         * <p>
         * The list of Amazon Web Services accounts that are trusted when the domain is created in VPC-only mode.
         * </p>
         * 
         * @param vpcOnlyTrustedAccounts
         *        The list of Amazon Web Services accounts that are trusted when the domain is created in VPC-only mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOnlyTrustedAccounts(Collection<String> vpcOnlyTrustedAccounts);

        /**
         * <p>
         * The list of Amazon Web Services accounts that are trusted when the domain is created in VPC-only mode.
         * </p>
         * 
         * @param vpcOnlyTrustedAccounts
         *        The list of Amazon Web Services accounts that are trusted when the domain is created in VPC-only mode.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcOnlyTrustedAccounts(String... vpcOnlyTrustedAccounts);
    }

    static final class BuilderImpl implements Builder {
        private String enableDockerAccess;

        private List<String> vpcOnlyTrustedAccounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DockerSettings model) {
            enableDockerAccess(model.enableDockerAccess);
            vpcOnlyTrustedAccounts(model.vpcOnlyTrustedAccounts);
        }

        public final String getEnableDockerAccess() {
            return enableDockerAccess;
        }

        public final void setEnableDockerAccess(String enableDockerAccess) {
            this.enableDockerAccess = enableDockerAccess;
        }

        @Override
        public final Builder enableDockerAccess(String enableDockerAccess) {
            this.enableDockerAccess = enableDockerAccess;
            return this;
        }

        @Override
        public final Builder enableDockerAccess(FeatureStatus enableDockerAccess) {
            this.enableDockerAccess(enableDockerAccess == null ? null : enableDockerAccess.toString());
            return this;
        }

        public final Collection<String> getVpcOnlyTrustedAccounts() {
            if (vpcOnlyTrustedAccounts instanceof SdkAutoConstructList) {
                return null;
            }
            return vpcOnlyTrustedAccounts;
        }

        public final void setVpcOnlyTrustedAccounts(Collection<String> vpcOnlyTrustedAccounts) {
            this.vpcOnlyTrustedAccounts = VpcOnlyTrustedAccountsCopier.copy(vpcOnlyTrustedAccounts);
        }

        @Override
        public final Builder vpcOnlyTrustedAccounts(Collection<String> vpcOnlyTrustedAccounts) {
            this.vpcOnlyTrustedAccounts = VpcOnlyTrustedAccountsCopier.copy(vpcOnlyTrustedAccounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcOnlyTrustedAccounts(String... vpcOnlyTrustedAccounts) {
            vpcOnlyTrustedAccounts(Arrays.asList(vpcOnlyTrustedAccounts));
            return this;
        }

        @Override
        public DockerSettings build() {
            return new DockerSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
