/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.internal.UserAgentUtils;
import software.amazon.awssdk.services.sagemaker.model.ImageVersion;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListImageVersionsResponse;

public class ListImageVersionsIterable
implements SdkIterable<ListImageVersionsResponse> {
    private final SageMakerClient client;
    private final ListImageVersionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImageVersionsIterable(SageMakerClient client, ListImageVersionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImageVersionsResponseFetcher();
    }

    public Iterator<ListImageVersionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageVersion> imageVersions() {
        Function<ListImageVersionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageVersions() != null) {
                return response.imageVersions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImageVersionsResponseFetcher
    implements SyncPageFetcher<ListImageVersionsResponse> {
        private ListImageVersionsResponseFetcher() {
        }

        public boolean hasNextPage(ListImageVersionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImageVersionsResponse nextPage(ListImageVersionsResponse previousPage) {
            if (previousPage == null) {
                return ListImageVersionsIterable.this.client.listImageVersions(ListImageVersionsIterable.this.firstRequest);
            }
            return ListImageVersionsIterable.this.client.listImageVersions((ListImageVersionsRequest)((Object)ListImageVersionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

