/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum Processor {
    CPU("CPU"),
    GPU("GPU"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Processor> VALUE_MAP;
    private final String value;

    private Processor(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static Processor fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<Processor> knownValues() {
        EnumSet<Processor> knownValues = EnumSet.allOf(Processor.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(Processor.class, Processor::toString);
    }
}

