/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ImageVersion;
import software.amazon.awssdk.services.sagemaker.model.ImageVersionsCopier;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImageVersionsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListImageVersionsResponse> {
    private static final SdkField<List<ImageVersion>> IMAGE_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ImageVersions").getter(ListImageVersionsResponse.getter(ListImageVersionsResponse::imageVersions)).setter(ListImageVersionsResponse.setter(Builder::imageVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListImageVersionsResponse.getter(ListImageVersionsResponse::nextToken)).setter(ListImageVersionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_VERSIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ImageVersion> imageVersions;
    private final String nextToken;

    private ListImageVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.imageVersions = builder.imageVersions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasImageVersions() {
        return this.imageVersions != null && !(this.imageVersions instanceof SdkAutoConstructList);
    }

    public final List<ImageVersion> imageVersions() {
        return this.imageVersions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasImageVersions() ? this.imageVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageVersionsResponse)) {
            return false;
        }
        ListImageVersionsResponse other = (ListImageVersionsResponse)((Object)obj);
        return this.hasImageVersions() == other.hasImageVersions() && Objects.equals(this.imageVersions(), other.imageVersions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImageVersionsResponse").add("ImageVersions", this.hasImageVersions() ? this.imageVersions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ImageVersions": {
                return Optional.ofNullable(clazz.cast(this.imageVersions()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListImageVersionsResponse, T> g) {
        return obj -> g.apply((ListImageVersionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ImageVersion> imageVersions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageVersionsResponse model) {
            super(model);
            this.imageVersions(model.imageVersions);
            this.nextToken(model.nextToken);
        }

        public final List<ImageVersion.Builder> getImageVersions() {
            List<ImageVersion.Builder> result = ImageVersionsCopier.copyToBuilder(this.imageVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setImageVersions(Collection<ImageVersion.BuilderImpl> imageVersions) {
            this.imageVersions = ImageVersionsCopier.copyFromBuilder(imageVersions);
        }

        @Override
        public final Builder imageVersions(Collection<ImageVersion> imageVersions) {
            this.imageVersions = ImageVersionsCopier.copy(imageVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersions(ImageVersion ... imageVersions) {
            this.imageVersions(Arrays.asList(imageVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageVersions(Consumer<ImageVersion.Builder> ... imageVersions) {
            this.imageVersions(Stream.of(imageVersions).map(c -> (ImageVersion)((ImageVersion.Builder)ImageVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImageVersionsResponse build() {
            return new ListImageVersionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImageVersionsResponse> {
        public Builder imageVersions(Collection<ImageVersion> var1);

        public Builder imageVersions(ImageVersion ... var1);

        public Builder imageVersions(Consumer<ImageVersion.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

