/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ScalingPoliciesCopier;
import software.amazon.awssdk.services.sagemaker.model.ScalingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DynamicScalingConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DynamicScalingConfiguration> {
    private static final SdkField<Integer> MIN_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MinCapacity").getter(DynamicScalingConfiguration.getter(DynamicScalingConfiguration::minCapacity)).setter(DynamicScalingConfiguration.setter(Builder::minCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinCapacity").build()}).build();
    private static final SdkField<Integer> MAX_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxCapacity").getter(DynamicScalingConfiguration.getter(DynamicScalingConfiguration::maxCapacity)).setter(DynamicScalingConfiguration.setter(Builder::maxCapacity)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxCapacity").build()}).build();
    private static final SdkField<Integer> SCALE_IN_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScaleInCooldown").getter(DynamicScalingConfiguration.getter(DynamicScalingConfiguration::scaleInCooldown)).setter(DynamicScalingConfiguration.setter(Builder::scaleInCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleInCooldown").build()}).build();
    private static final SdkField<Integer> SCALE_OUT_COOLDOWN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ScaleOutCooldown").getter(DynamicScalingConfiguration.getter(DynamicScalingConfiguration::scaleOutCooldown)).setter(DynamicScalingConfiguration.setter(Builder::scaleOutCooldown)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleOutCooldown").build()}).build();
    private static final SdkField<List<ScalingPolicy>> SCALING_POLICIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScalingPolicies").getter(DynamicScalingConfiguration.getter(DynamicScalingConfiguration::scalingPolicies)).setter(DynamicScalingConfiguration.setter(Builder::scalingPolicies)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingPolicies").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScalingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MIN_CAPACITY_FIELD, MAX_CAPACITY_FIELD, SCALE_IN_COOLDOWN_FIELD, SCALE_OUT_COOLDOWN_FIELD, SCALING_POLICIES_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer minCapacity;
    private final Integer maxCapacity;
    private final Integer scaleInCooldown;
    private final Integer scaleOutCooldown;
    private final List<ScalingPolicy> scalingPolicies;

    private DynamicScalingConfiguration(BuilderImpl builder) {
        this.minCapacity = builder.minCapacity;
        this.maxCapacity = builder.maxCapacity;
        this.scaleInCooldown = builder.scaleInCooldown;
        this.scaleOutCooldown = builder.scaleOutCooldown;
        this.scalingPolicies = builder.scalingPolicies;
    }

    public final Integer minCapacity() {
        return this.minCapacity;
    }

    public final Integer maxCapacity() {
        return this.maxCapacity;
    }

    public final Integer scaleInCooldown() {
        return this.scaleInCooldown;
    }

    public final Integer scaleOutCooldown() {
        return this.scaleOutCooldown;
    }

    public final boolean hasScalingPolicies() {
        return this.scalingPolicies != null && !(this.scalingPolicies instanceof SdkAutoConstructList);
    }

    public final List<ScalingPolicy> scalingPolicies() {
        return this.scalingPolicies;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.minCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleInCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.scaleOutCooldown());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScalingPolicies() ? this.scalingPolicies() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DynamicScalingConfiguration)) {
            return false;
        }
        DynamicScalingConfiguration other = (DynamicScalingConfiguration)obj;
        return Objects.equals(this.minCapacity(), other.minCapacity()) && Objects.equals(this.maxCapacity(), other.maxCapacity()) && Objects.equals(this.scaleInCooldown(), other.scaleInCooldown()) && Objects.equals(this.scaleOutCooldown(), other.scaleOutCooldown()) && this.hasScalingPolicies() == other.hasScalingPolicies() && Objects.equals(this.scalingPolicies(), other.scalingPolicies());
    }

    public final String toString() {
        return ToString.builder((String)"DynamicScalingConfiguration").add("MinCapacity", (Object)this.minCapacity()).add("MaxCapacity", (Object)this.maxCapacity()).add("ScaleInCooldown", (Object)this.scaleInCooldown()).add("ScaleOutCooldown", (Object)this.scaleOutCooldown()).add("ScalingPolicies", this.hasScalingPolicies() ? this.scalingPolicies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MinCapacity": {
                return Optional.ofNullable(clazz.cast(this.minCapacity()));
            }
            case "MaxCapacity": {
                return Optional.ofNullable(clazz.cast(this.maxCapacity()));
            }
            case "ScaleInCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleInCooldown()));
            }
            case "ScaleOutCooldown": {
                return Optional.ofNullable(clazz.cast(this.scaleOutCooldown()));
            }
            case "ScalingPolicies": {
                return Optional.ofNullable(clazz.cast(this.scalingPolicies()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DynamicScalingConfiguration, T> g) {
        return obj -> g.apply((DynamicScalingConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer minCapacity;
        private Integer maxCapacity;
        private Integer scaleInCooldown;
        private Integer scaleOutCooldown;
        private List<ScalingPolicy> scalingPolicies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DynamicScalingConfiguration model) {
            this.minCapacity(model.minCapacity);
            this.maxCapacity(model.maxCapacity);
            this.scaleInCooldown(model.scaleInCooldown);
            this.scaleOutCooldown(model.scaleOutCooldown);
            this.scalingPolicies(model.scalingPolicies);
        }

        public final Integer getMinCapacity() {
            return this.minCapacity;
        }

        public final void setMinCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
        }

        @Override
        public final Builder minCapacity(Integer minCapacity) {
            this.minCapacity = minCapacity;
            return this;
        }

        public final Integer getMaxCapacity() {
            return this.maxCapacity;
        }

        public final void setMaxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
        }

        @Override
        public final Builder maxCapacity(Integer maxCapacity) {
            this.maxCapacity = maxCapacity;
            return this;
        }

        public final Integer getScaleInCooldown() {
            return this.scaleInCooldown;
        }

        public final void setScaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
        }

        @Override
        public final Builder scaleInCooldown(Integer scaleInCooldown) {
            this.scaleInCooldown = scaleInCooldown;
            return this;
        }

        public final Integer getScaleOutCooldown() {
            return this.scaleOutCooldown;
        }

        public final void setScaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
        }

        @Override
        public final Builder scaleOutCooldown(Integer scaleOutCooldown) {
            this.scaleOutCooldown = scaleOutCooldown;
            return this;
        }

        public final List<ScalingPolicy.Builder> getScalingPolicies() {
            List<ScalingPolicy.Builder> result = ScalingPoliciesCopier.copyToBuilder(this.scalingPolicies);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScalingPolicies(Collection<ScalingPolicy.BuilderImpl> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copyFromBuilder(scalingPolicies);
        }

        @Override
        public final Builder scalingPolicies(Collection<ScalingPolicy> scalingPolicies) {
            this.scalingPolicies = ScalingPoliciesCopier.copy(scalingPolicies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(ScalingPolicy ... scalingPolicies) {
            this.scalingPolicies(Arrays.asList(scalingPolicies));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... scalingPolicies) {
            this.scalingPolicies(Stream.of(scalingPolicies).map(c -> (ScalingPolicy)((ScalingPolicy.Builder)ScalingPolicy.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DynamicScalingConfiguration build() {
            return new DynamicScalingConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DynamicScalingConfiguration> {
        public Builder minCapacity(Integer var1);

        public Builder maxCapacity(Integer var1);

        public Builder scaleInCooldown(Integer var1);

        public Builder scaleOutCooldown(Integer var1);

        public Builder scalingPolicies(Collection<ScalingPolicy> var1);

        public Builder scalingPolicies(ScalingPolicy ... var1);

        public Builder scalingPolicies(Consumer<ScalingPolicy.Builder> ... var1);
    }
}

