/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSpaceRequest extends SageMakerRequest implements
        ToCopyableBuilder<UpdateSpaceRequest.Builder, UpdateSpaceRequest> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainId").getter(getter(UpdateSpaceRequest::domainId)).setter(setter(Builder::domainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainId").build()).build();

    private static final SdkField<String> SPACE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SpaceName").getter(getter(UpdateSpaceRequest::spaceName)).setter(setter(Builder::spaceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceName").build()).build();

    private static final SdkField<SpaceSettings> SPACE_SETTINGS_FIELD = SdkField
            .<SpaceSettings> builder(MarshallingType.SDK_POJO).memberName("SpaceSettings")
            .getter(getter(UpdateSpaceRequest::spaceSettings)).setter(setter(Builder::spaceSettings))
            .constructor(SpaceSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SpaceSettings").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD,
            SPACE_NAME_FIELD, SPACE_SETTINGS_FIELD));

    private final String domainId;

    private final String spaceName;

    private final SpaceSettings spaceSettings;

    private UpdateSpaceRequest(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.spaceName = builder.spaceName;
        this.spaceSettings = builder.spaceSettings;
    }

    /**
     * <p>
     * The ID of the associated Domain.
     * </p>
     * 
     * @return The ID of the associated Domain.
     */
    public final String domainId() {
        return domainId;
    }

    /**
     * <p>
     * The name of the space.
     * </p>
     * 
     * @return The name of the space.
     */
    public final String spaceName() {
        return spaceName;
    }

    /**
     * <p>
     * A collection of space settings.
     * </p>
     * 
     * @return A collection of space settings.
     */
    public final SpaceSettings spaceSettings() {
        return spaceSettings;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainId());
        hashCode = 31 * hashCode + Objects.hashCode(spaceName());
        hashCode = 31 * hashCode + Objects.hashCode(spaceSettings());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSpaceRequest)) {
            return false;
        }
        UpdateSpaceRequest other = (UpdateSpaceRequest) obj;
        return Objects.equals(domainId(), other.domainId()) && Objects.equals(spaceName(), other.spaceName())
                && Objects.equals(spaceSettings(), other.spaceSettings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSpaceRequest").add("DomainId", domainId()).add("SpaceName", spaceName())
                .add("SpaceSettings", spaceSettings()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainId":
            return Optional.ofNullable(clazz.cast(domainId()));
        case "SpaceName":
            return Optional.ofNullable(clazz.cast(spaceName()));
        case "SpaceSettings":
            return Optional.ofNullable(clazz.cast(spaceSettings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateSpaceRequest, T> g) {
        return obj -> g.apply((UpdateSpaceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateSpaceRequest> {
        /**
         * <p>
         * The ID of the associated Domain.
         * </p>
         * 
         * @param domainId
         *        The ID of the associated Domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainId(String domainId);

        /**
         * <p>
         * The name of the space.
         * </p>
         * 
         * @param spaceName
         *        The name of the space.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceName(String spaceName);

        /**
         * <p>
         * A collection of space settings.
         * </p>
         * 
         * @param spaceSettings
         *        A collection of space settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spaceSettings(SpaceSettings spaceSettings);

        /**
         * <p>
         * A collection of space settings.
         * </p>
         * This is a convenience method that creates an instance of the {@link SpaceSettings.Builder} avoiding the need
         * to create one manually via {@link SpaceSettings#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SpaceSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #spaceSettings(SpaceSettings)}.
         * 
         * @param spaceSettings
         *        a consumer that will call methods on {@link SpaceSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #spaceSettings(SpaceSettings)
         */
        default Builder spaceSettings(Consumer<SpaceSettings.Builder> spaceSettings) {
            return spaceSettings(SpaceSettings.builder().applyMutation(spaceSettings).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends SageMakerRequest.BuilderImpl implements Builder {
        private String domainId;

        private String spaceName;

        private SpaceSettings spaceSettings;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSpaceRequest model) {
            super(model);
            domainId(model.domainId);
            spaceName(model.spaceName);
            spaceSettings(model.spaceSettings);
        }

        public final String getDomainId() {
            return domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getSpaceName() {
            return spaceName;
        }

        public final void setSpaceName(String spaceName) {
            this.spaceName = spaceName;
        }

        @Override
        public final Builder spaceName(String spaceName) {
            this.spaceName = spaceName;
            return this;
        }

        public final SpaceSettings.Builder getSpaceSettings() {
            return spaceSettings != null ? spaceSettings.toBuilder() : null;
        }

        public final void setSpaceSettings(SpaceSettings.BuilderImpl spaceSettings) {
            this.spaceSettings = spaceSettings != null ? spaceSettings.build() : null;
        }

        @Override
        public final Builder spaceSettings(SpaceSettings spaceSettings) {
            this.spaceSettings = spaceSettings;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSpaceRequest build() {
            return new UpdateSpaceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
