/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerClient;
import software.amazon.awssdk.services.sagemaker.model.EdgeDeploymentPlanSummary;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansRequest;
import software.amazon.awssdk.services.sagemaker.model.ListEdgeDeploymentPlansResponse;

public class ListEdgeDeploymentPlansIterable
implements SdkIterable<ListEdgeDeploymentPlansResponse> {
    private final SageMakerClient client;
    private final ListEdgeDeploymentPlansRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEdgeDeploymentPlansIterable(SageMakerClient client, ListEdgeDeploymentPlansRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListEdgeDeploymentPlansResponseFetcher();
    }

    public Iterator<ListEdgeDeploymentPlansResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EdgeDeploymentPlanSummary> edgeDeploymentPlanSummaries() {
        Function<ListEdgeDeploymentPlansResponse, Iterator> getIterator = response -> {
            if (response != null && response.edgeDeploymentPlanSummaries() != null) {
                return response.edgeDeploymentPlanSummaries().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEdgeDeploymentPlansResponseFetcher
    implements SyncPageFetcher<ListEdgeDeploymentPlansResponse> {
        private ListEdgeDeploymentPlansResponseFetcher() {
        }

        public boolean hasNextPage(ListEdgeDeploymentPlansResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEdgeDeploymentPlansResponse nextPage(ListEdgeDeploymentPlansResponse previousPage) {
            if (previousPage == null) {
                return ListEdgeDeploymentPlansIterable.this.client.listEdgeDeploymentPlans(ListEdgeDeploymentPlansIterable.this.firstRequest);
            }
            return ListEdgeDeploymentPlansIterable.this.client.listEdgeDeploymentPlans((ListEdgeDeploymentPlansRequest)((Object)ListEdgeDeploymentPlansIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

