/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LineageType {
    TRIAL_COMPONENT("TrialComponent"),
    ARTIFACT("Artifact"),
    CONTEXT("Context"),
    ACTION("Action"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LineageType> VALUE_MAP;
    private final String value;

    private LineageType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LineageType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LineageType> knownValues() {
        EnumSet<LineageType> knownValues = EnumSet.allOf(LineageType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LineageType.class, LineageType::toString);
    }
}

