/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.sagemaker.SageMakerAsyncClient;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsRequest;
import software.amazon.awssdk.services.sagemaker.model.ListCompilationJobsResponse;

public class ListCompilationJobsPublisher
implements SdkPublisher<ListCompilationJobsResponse> {
    private final SageMakerAsyncClient client;
    private final ListCompilationJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCompilationJobsPublisher(SageMakerAsyncClient client, ListCompilationJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCompilationJobsPublisher(SageMakerAsyncClient client, ListCompilationJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCompilationJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCompilationJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private final ListCompilationJobsPublisher resume(ListCompilationJobsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListCompilationJobsPublisher(this.client, (ListCompilationJobsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListCompilationJobsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListCompilationJobsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListCompilationJobsResponseFetcher
    implements AsyncPageFetcher<ListCompilationJobsResponse> {
        private ListCompilationJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCompilationJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCompilationJobsResponse> nextPage(ListCompilationJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCompilationJobsPublisher.this.client.listCompilationJobs(ListCompilationJobsPublisher.this.firstRequest);
            }
            return ListCompilationJobsPublisher.this.client.listCompilationJobs((ListCompilationJobsRequest)((Object)ListCompilationJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

