/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.HumanTaskConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelCounters;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobAlgorithmsConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobInputConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobOutput;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobOutputConfig;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobStatus;
import software.amazon.awssdk.services.sagemaker.model.LabelingJobStoppingConditions;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeLabelingJobResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeLabelingJobResponse> {
    private static final SdkField<String> LABELING_JOB_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelingJobStatusAsString)).setter(DescribeLabelingJobResponse.setter(Builder::labelingJobStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobStatus").build()}).build();
    private static final SdkField<LabelCounters> LABEL_COUNTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelCounters)).setter(DescribeLabelingJobResponse.setter(Builder::labelCounters)).constructor(LabelCounters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCounters").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::failureReason)).setter(DescribeLabelingJobResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::creationTime)).setter(DescribeLabelingJobResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::lastModifiedTime)).setter(DescribeLabelingJobResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<String> JOB_REFERENCE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::jobReferenceCode)).setter(DescribeLabelingJobResponse.setter(Builder::jobReferenceCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobReferenceCode").build()}).build();
    private static final SdkField<String> LABELING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelingJobName)).setter(DescribeLabelingJobResponse.setter(Builder::labelingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobName").build()}).build();
    private static final SdkField<String> LABELING_JOB_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelingJobArn)).setter(DescribeLabelingJobResponse.setter(Builder::labelingJobArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobArn").build()}).build();
    private static final SdkField<String> LABEL_ATTRIBUTE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelAttributeName)).setter(DescribeLabelingJobResponse.setter(Builder::labelAttributeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelAttributeName").build()}).build();
    private static final SdkField<LabelingJobInputConfig> INPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::inputConfig)).setter(DescribeLabelingJobResponse.setter(Builder::inputConfig)).constructor(LabelingJobInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputConfig").build()}).build();
    private static final SdkField<LabelingJobOutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::outputConfig)).setter(DescribeLabelingJobResponse.setter(Builder::outputConfig)).constructor(LabelingJobOutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputConfig").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::roleArn)).setter(DescribeLabelingJobResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<String> LABEL_CATEGORY_CONFIG_S3_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelCategoryConfigS3Uri)).setter(DescribeLabelingJobResponse.setter(Builder::labelCategoryConfigS3Uri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelCategoryConfigS3Uri").build()}).build();
    private static final SdkField<LabelingJobStoppingConditions> STOPPING_CONDITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::stoppingConditions)).setter(DescribeLabelingJobResponse.setter(Builder::stoppingConditions)).constructor(LabelingJobStoppingConditions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingConditions").build()}).build();
    private static final SdkField<LabelingJobAlgorithmsConfig> LABELING_JOB_ALGORITHMS_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelingJobAlgorithmsConfig)).setter(DescribeLabelingJobResponse.setter(Builder::labelingJobAlgorithmsConfig)).constructor(LabelingJobAlgorithmsConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobAlgorithmsConfig").build()}).build();
    private static final SdkField<HumanTaskConfig> HUMAN_TASK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::humanTaskConfig)).setter(DescribeLabelingJobResponse.setter(Builder::humanTaskConfig)).constructor(HumanTaskConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskConfig").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::tags)).setter(DescribeLabelingJobResponse.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LabelingJobOutput> LABELING_JOB_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(DescribeLabelingJobResponse.getter(DescribeLabelingJobResponse::labelingJobOutput)).setter(DescribeLabelingJobResponse.setter(Builder::labelingJobOutput)).constructor(LabelingJobOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LabelingJobOutput").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LABELING_JOB_STATUS_FIELD, LABEL_COUNTERS_FIELD, FAILURE_REASON_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, JOB_REFERENCE_CODE_FIELD, LABELING_JOB_NAME_FIELD, LABELING_JOB_ARN_FIELD, LABEL_ATTRIBUTE_NAME_FIELD, INPUT_CONFIG_FIELD, OUTPUT_CONFIG_FIELD, ROLE_ARN_FIELD, LABEL_CATEGORY_CONFIG_S3_URI_FIELD, STOPPING_CONDITIONS_FIELD, LABELING_JOB_ALGORITHMS_CONFIG_FIELD, HUMAN_TASK_CONFIG_FIELD, TAGS_FIELD, LABELING_JOB_OUTPUT_FIELD));
    private final String labelingJobStatus;
    private final LabelCounters labelCounters;
    private final String failureReason;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final String jobReferenceCode;
    private final String labelingJobName;
    private final String labelingJobArn;
    private final String labelAttributeName;
    private final LabelingJobInputConfig inputConfig;
    private final LabelingJobOutputConfig outputConfig;
    private final String roleArn;
    private final String labelCategoryConfigS3Uri;
    private final LabelingJobStoppingConditions stoppingConditions;
    private final LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;
    private final HumanTaskConfig humanTaskConfig;
    private final List<Tag> tags;
    private final LabelingJobOutput labelingJobOutput;

    private DescribeLabelingJobResponse(BuilderImpl builder) {
        super(builder);
        this.labelingJobStatus = builder.labelingJobStatus;
        this.labelCounters = builder.labelCounters;
        this.failureReason = builder.failureReason;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.jobReferenceCode = builder.jobReferenceCode;
        this.labelingJobName = builder.labelingJobName;
        this.labelingJobArn = builder.labelingJobArn;
        this.labelAttributeName = builder.labelAttributeName;
        this.inputConfig = builder.inputConfig;
        this.outputConfig = builder.outputConfig;
        this.roleArn = builder.roleArn;
        this.labelCategoryConfigS3Uri = builder.labelCategoryConfigS3Uri;
        this.stoppingConditions = builder.stoppingConditions;
        this.labelingJobAlgorithmsConfig = builder.labelingJobAlgorithmsConfig;
        this.humanTaskConfig = builder.humanTaskConfig;
        this.tags = builder.tags;
        this.labelingJobOutput = builder.labelingJobOutput;
    }

    public LabelingJobStatus labelingJobStatus() {
        return LabelingJobStatus.fromValue(this.labelingJobStatus);
    }

    public String labelingJobStatusAsString() {
        return this.labelingJobStatus;
    }

    public LabelCounters labelCounters() {
        return this.labelCounters;
    }

    public String failureReason() {
        return this.failureReason;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public String jobReferenceCode() {
        return this.jobReferenceCode;
    }

    public String labelingJobName() {
        return this.labelingJobName;
    }

    public String labelingJobArn() {
        return this.labelingJobArn;
    }

    public String labelAttributeName() {
        return this.labelAttributeName;
    }

    public LabelingJobInputConfig inputConfig() {
        return this.inputConfig;
    }

    public LabelingJobOutputConfig outputConfig() {
        return this.outputConfig;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String labelCategoryConfigS3Uri() {
        return this.labelCategoryConfigS3Uri;
    }

    public LabelingJobStoppingConditions stoppingConditions() {
        return this.stoppingConditions;
    }

    public LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig() {
        return this.labelingJobAlgorithmsConfig;
    }

    public HumanTaskConfig humanTaskConfig() {
        return this.humanTaskConfig;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public LabelingJobOutput labelingJobOutput() {
        return this.labelingJobOutput;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelCounters());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobReferenceCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelAttributeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelCategoryConfigS3Uri());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingConditions());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobAlgorithmsConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanTaskConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelingJobOutput());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeLabelingJobResponse)) {
            return false;
        }
        DescribeLabelingJobResponse other = (DescribeLabelingJobResponse)((Object)obj);
        return Objects.equals(this.labelingJobStatusAsString(), other.labelingJobStatusAsString()) && Objects.equals(this.labelCounters(), other.labelCounters()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.jobReferenceCode(), other.jobReferenceCode()) && Objects.equals(this.labelingJobName(), other.labelingJobName()) && Objects.equals(this.labelingJobArn(), other.labelingJobArn()) && Objects.equals(this.labelAttributeName(), other.labelAttributeName()) && Objects.equals(this.inputConfig(), other.inputConfig()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.labelCategoryConfigS3Uri(), other.labelCategoryConfigS3Uri()) && Objects.equals(this.stoppingConditions(), other.stoppingConditions()) && Objects.equals(this.labelingJobAlgorithmsConfig(), other.labelingJobAlgorithmsConfig()) && Objects.equals(this.humanTaskConfig(), other.humanTaskConfig()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.labelingJobOutput(), other.labelingJobOutput());
    }

    public String toString() {
        return ToString.builder((String)"DescribeLabelingJobResponse").add("LabelingJobStatus", (Object)this.labelingJobStatusAsString()).add("LabelCounters", (Object)this.labelCounters()).add("FailureReason", (Object)this.failureReason()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("JobReferenceCode", (Object)this.jobReferenceCode()).add("LabelingJobName", (Object)this.labelingJobName()).add("LabelingJobArn", (Object)this.labelingJobArn()).add("LabelAttributeName", (Object)this.labelAttributeName()).add("InputConfig", (Object)this.inputConfig()).add("OutputConfig", (Object)this.outputConfig()).add("RoleArn", (Object)this.roleArn()).add("LabelCategoryConfigS3Uri", (Object)this.labelCategoryConfigS3Uri()).add("StoppingConditions", (Object)this.stoppingConditions()).add("LabelingJobAlgorithmsConfig", (Object)this.labelingJobAlgorithmsConfig()).add("HumanTaskConfig", (Object)this.humanTaskConfig()).add("Tags", this.tags()).add("LabelingJobOutput", (Object)this.labelingJobOutput()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LabelingJobStatus": {
                return Optional.ofNullable(clazz.cast(this.labelingJobStatusAsString()));
            }
            case "LabelCounters": {
                return Optional.ofNullable(clazz.cast(this.labelCounters()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "JobReferenceCode": {
                return Optional.ofNullable(clazz.cast(this.jobReferenceCode()));
            }
            case "LabelingJobName": {
                return Optional.ofNullable(clazz.cast(this.labelingJobName()));
            }
            case "LabelingJobArn": {
                return Optional.ofNullable(clazz.cast(this.labelingJobArn()));
            }
            case "LabelAttributeName": {
                return Optional.ofNullable(clazz.cast(this.labelAttributeName()));
            }
            case "InputConfig": {
                return Optional.ofNullable(clazz.cast(this.inputConfig()));
            }
            case "OutputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "LabelCategoryConfigS3Uri": {
                return Optional.ofNullable(clazz.cast(this.labelCategoryConfigS3Uri()));
            }
            case "StoppingConditions": {
                return Optional.ofNullable(clazz.cast(this.stoppingConditions()));
            }
            case "LabelingJobAlgorithmsConfig": {
                return Optional.ofNullable(clazz.cast(this.labelingJobAlgorithmsConfig()));
            }
            case "HumanTaskConfig": {
                return Optional.ofNullable(clazz.cast(this.humanTaskConfig()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "LabelingJobOutput": {
                return Optional.ofNullable(clazz.cast(this.labelingJobOutput()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeLabelingJobResponse, T> g) {
        return obj -> g.apply((DescribeLabelingJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String labelingJobStatus;
        private LabelCounters labelCounters;
        private String failureReason;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private String jobReferenceCode;
        private String labelingJobName;
        private String labelingJobArn;
        private String labelAttributeName;
        private LabelingJobInputConfig inputConfig;
        private LabelingJobOutputConfig outputConfig;
        private String roleArn;
        private String labelCategoryConfigS3Uri;
        private LabelingJobStoppingConditions stoppingConditions;
        private LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig;
        private HumanTaskConfig humanTaskConfig;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private LabelingJobOutput labelingJobOutput;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeLabelingJobResponse model) {
            super(model);
            this.labelingJobStatus(model.labelingJobStatus);
            this.labelCounters(model.labelCounters);
            this.failureReason(model.failureReason);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.jobReferenceCode(model.jobReferenceCode);
            this.labelingJobName(model.labelingJobName);
            this.labelingJobArn(model.labelingJobArn);
            this.labelAttributeName(model.labelAttributeName);
            this.inputConfig(model.inputConfig);
            this.outputConfig(model.outputConfig);
            this.roleArn(model.roleArn);
            this.labelCategoryConfigS3Uri(model.labelCategoryConfigS3Uri);
            this.stoppingConditions(model.stoppingConditions);
            this.labelingJobAlgorithmsConfig(model.labelingJobAlgorithmsConfig);
            this.humanTaskConfig(model.humanTaskConfig);
            this.tags(model.tags);
            this.labelingJobOutput(model.labelingJobOutput);
        }

        public final String getLabelingJobStatus() {
            return this.labelingJobStatus;
        }

        @Override
        public final Builder labelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
            return this;
        }

        @Override
        public final Builder labelingJobStatus(LabelingJobStatus labelingJobStatus) {
            this.labelingJobStatus(labelingJobStatus.toString());
            return this;
        }

        public final void setLabelingJobStatus(String labelingJobStatus) {
            this.labelingJobStatus = labelingJobStatus;
        }

        public final LabelCounters.Builder getLabelCounters() {
            return this.labelCounters != null ? this.labelCounters.toBuilder() : null;
        }

        @Override
        public final Builder labelCounters(LabelCounters labelCounters) {
            this.labelCounters = labelCounters;
            return this;
        }

        public final void setLabelCounters(LabelCounters.BuilderImpl labelCounters) {
            this.labelCounters = labelCounters != null ? labelCounters.build() : null;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final String getJobReferenceCode() {
            return this.jobReferenceCode;
        }

        @Override
        public final Builder jobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
            return this;
        }

        public final void setJobReferenceCode(String jobReferenceCode) {
            this.jobReferenceCode = jobReferenceCode;
        }

        public final String getLabelingJobName() {
            return this.labelingJobName;
        }

        @Override
        public final Builder labelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
            return this;
        }

        public final void setLabelingJobName(String labelingJobName) {
            this.labelingJobName = labelingJobName;
        }

        public final String getLabelingJobArn() {
            return this.labelingJobArn;
        }

        @Override
        public final Builder labelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
            return this;
        }

        public final void setLabelingJobArn(String labelingJobArn) {
            this.labelingJobArn = labelingJobArn;
        }

        public final String getLabelAttributeName() {
            return this.labelAttributeName;
        }

        @Override
        public final Builder labelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
            return this;
        }

        public final void setLabelAttributeName(String labelAttributeName) {
            this.labelAttributeName = labelAttributeName;
        }

        public final LabelingJobInputConfig.Builder getInputConfig() {
            return this.inputConfig != null ? this.inputConfig.toBuilder() : null;
        }

        @Override
        public final Builder inputConfig(LabelingJobInputConfig inputConfig) {
            this.inputConfig = inputConfig;
            return this;
        }

        public final void setInputConfig(LabelingJobInputConfig.BuilderImpl inputConfig) {
            this.inputConfig = inputConfig != null ? inputConfig.build() : null;
        }

        public final LabelingJobOutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputConfig(LabelingJobOutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final void setOutputConfig(LabelingJobOutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getLabelCategoryConfigS3Uri() {
            return this.labelCategoryConfigS3Uri;
        }

        @Override
        public final Builder labelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
            return this;
        }

        public final void setLabelCategoryConfigS3Uri(String labelCategoryConfigS3Uri) {
            this.labelCategoryConfigS3Uri = labelCategoryConfigS3Uri;
        }

        public final LabelingJobStoppingConditions.Builder getStoppingConditions() {
            return this.stoppingConditions != null ? this.stoppingConditions.toBuilder() : null;
        }

        @Override
        public final Builder stoppingConditions(LabelingJobStoppingConditions stoppingConditions) {
            this.stoppingConditions = stoppingConditions;
            return this;
        }

        public final void setStoppingConditions(LabelingJobStoppingConditions.BuilderImpl stoppingConditions) {
            this.stoppingConditions = stoppingConditions != null ? stoppingConditions.build() : null;
        }

        public final LabelingJobAlgorithmsConfig.Builder getLabelingJobAlgorithmsConfig() {
            return this.labelingJobAlgorithmsConfig != null ? this.labelingJobAlgorithmsConfig.toBuilder() : null;
        }

        @Override
        public final Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig;
            return this;
        }

        public final void setLabelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig.BuilderImpl labelingJobAlgorithmsConfig) {
            this.labelingJobAlgorithmsConfig = labelingJobAlgorithmsConfig != null ? labelingJobAlgorithmsConfig.build() : null;
        }

        public final HumanTaskConfig.Builder getHumanTaskConfig() {
            return this.humanTaskConfig != null ? this.humanTaskConfig.toBuilder() : null;
        }

        @Override
        public final Builder humanTaskConfig(HumanTaskConfig humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig;
            return this;
        }

        public final void setHumanTaskConfig(HumanTaskConfig.BuilderImpl humanTaskConfig) {
            this.humanTaskConfig = humanTaskConfig != null ? humanTaskConfig.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final LabelingJobOutput.Builder getLabelingJobOutput() {
            return this.labelingJobOutput != null ? this.labelingJobOutput.toBuilder() : null;
        }

        @Override
        public final Builder labelingJobOutput(LabelingJobOutput labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput;
            return this;
        }

        public final void setLabelingJobOutput(LabelingJobOutput.BuilderImpl labelingJobOutput) {
            this.labelingJobOutput = labelingJobOutput != null ? labelingJobOutput.build() : null;
        }

        @Override
        public DescribeLabelingJobResponse build() {
            return new DescribeLabelingJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeLabelingJobResponse> {
        public Builder labelingJobStatus(String var1);

        public Builder labelingJobStatus(LabelingJobStatus var1);

        public Builder labelCounters(LabelCounters var1);

        default public Builder labelCounters(Consumer<LabelCounters.Builder> labelCounters) {
            return this.labelCounters((LabelCounters)((LabelCounters.Builder)LabelCounters.builder().applyMutation(labelCounters)).build());
        }

        public Builder failureReason(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder jobReferenceCode(String var1);

        public Builder labelingJobName(String var1);

        public Builder labelingJobArn(String var1);

        public Builder labelAttributeName(String var1);

        public Builder inputConfig(LabelingJobInputConfig var1);

        default public Builder inputConfig(Consumer<LabelingJobInputConfig.Builder> inputConfig) {
            return this.inputConfig((LabelingJobInputConfig)((LabelingJobInputConfig.Builder)LabelingJobInputConfig.builder().applyMutation(inputConfig)).build());
        }

        public Builder outputConfig(LabelingJobOutputConfig var1);

        default public Builder outputConfig(Consumer<LabelingJobOutputConfig.Builder> outputConfig) {
            return this.outputConfig((LabelingJobOutputConfig)((LabelingJobOutputConfig.Builder)LabelingJobOutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder roleArn(String var1);

        public Builder labelCategoryConfigS3Uri(String var1);

        public Builder stoppingConditions(LabelingJobStoppingConditions var1);

        default public Builder stoppingConditions(Consumer<LabelingJobStoppingConditions.Builder> stoppingConditions) {
            return this.stoppingConditions((LabelingJobStoppingConditions)((LabelingJobStoppingConditions.Builder)LabelingJobStoppingConditions.builder().applyMutation(stoppingConditions)).build());
        }

        public Builder labelingJobAlgorithmsConfig(LabelingJobAlgorithmsConfig var1);

        default public Builder labelingJobAlgorithmsConfig(Consumer<LabelingJobAlgorithmsConfig.Builder> labelingJobAlgorithmsConfig) {
            return this.labelingJobAlgorithmsConfig((LabelingJobAlgorithmsConfig)((LabelingJobAlgorithmsConfig.Builder)LabelingJobAlgorithmsConfig.builder().applyMutation(labelingJobAlgorithmsConfig)).build());
        }

        public Builder humanTaskConfig(HumanTaskConfig var1);

        default public Builder humanTaskConfig(Consumer<HumanTaskConfig.Builder> humanTaskConfig) {
            return this.humanTaskConfig((HumanTaskConfig)((HumanTaskConfig.Builder)HumanTaskConfig.builder().applyMutation(humanTaskConfig)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder labelingJobOutput(LabelingJobOutput var1);

        default public Builder labelingJobOutput(Consumer<LabelingJobOutput.Builder> labelingJobOutput) {
            return this.labelingJobOutput((LabelingJobOutput)((LabelingJobOutput.Builder)LabelingJobOutput.builder().applyMutation(labelingJobOutput)).build());
        }
    }
}

