/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.AlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.Tag;
import software.amazon.awssdk.services.sagemaker.model.TagListCopier;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTrainingJobRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, CreateTrainingJobRequest> {
    private static final SdkField<String> TRAINING_JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::trainingJobName)).setter(CreateTrainingJobRequest.setter(Builder::trainingJobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingJobName").build()}).build();
    private static final SdkField<Map<String, String>> HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::hyperParameters)).setter(CreateTrainingJobRequest.setter(Builder::hyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::algorithmSpecification)).setter(CreateTrainingJobRequest.setter(Builder::algorithmSpecification)).constructor(AlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::roleArn)).setter(CreateTrainingJobRequest.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::inputDataConfig)).setter(CreateTrainingJobRequest.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::outputDataConfig)).setter(CreateTrainingJobRequest.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::resourceConfig)).setter(CreateTrainingJobRequest.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::vpcConfig)).setter(CreateTrainingJobRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::stoppingCondition)).setter(CreateTrainingJobRequest.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::tags)).setter(CreateTrainingJobRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateTrainingJobRequest.getter(CreateTrainingJobRequest::enableNetworkIsolation)).setter(CreateTrainingJobRequest.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_JOB_NAME_FIELD, HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, VPC_CONFIG_FIELD, STOPPING_CONDITION_FIELD, TAGS_FIELD, ENABLE_NETWORK_ISOLATION_FIELD));
    private final String trainingJobName;
    private final Map<String, String> hyperParameters;
    private final AlgorithmSpecification algorithmSpecification;
    private final String roleArn;
    private final List<Channel> inputDataConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final VpcConfig vpcConfig;
    private final StoppingCondition stoppingCondition;
    private final List<Tag> tags;
    private final Boolean enableNetworkIsolation;

    private CreateTrainingJobRequest(BuilderImpl builder) {
        super(builder);
        this.trainingJobName = builder.trainingJobName;
        this.hyperParameters = builder.hyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.vpcConfig = builder.vpcConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.tags = builder.tags;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
    }

    public String trainingJobName() {
        return this.trainingJobName;
    }

    public Map<String, String> hyperParameters() {
        return this.hyperParameters;
    }

    public AlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public List<Tag> tags() {
        return this.tags;
    }

    public Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingJobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTrainingJobRequest)) {
            return false;
        }
        CreateTrainingJobRequest other = (CreateTrainingJobRequest)((Object)obj);
        return Objects.equals(this.trainingJobName(), other.trainingJobName()) && Objects.equals(this.hyperParameters(), other.hyperParameters()) && Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation());
    }

    public String toString() {
        return ToString.builder((String)"CreateTrainingJobRequest").add("TrainingJobName", (Object)this.trainingJobName()).add("HyperParameters", this.hyperParameters()).add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("RoleArn", (Object)this.roleArn()).add("InputDataConfig", this.inputDataConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("VpcConfig", (Object)this.vpcConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("Tags", this.tags()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingJobName": {
                return Optional.ofNullable(clazz.cast(this.trainingJobName()));
            }
            case "HyperParameters": {
                return Optional.ofNullable(clazz.cast(this.hyperParameters()));
            }
            case "AlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateTrainingJobRequest, T> g) {
        return obj -> g.apply((CreateTrainingJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String trainingJobName;
        private Map<String, String> hyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private AlgorithmSpecification algorithmSpecification;
        private String roleArn;
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private VpcConfig vpcConfig;
        private StoppingCondition stoppingCondition;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private Boolean enableNetworkIsolation;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTrainingJobRequest model) {
            super(model);
            this.trainingJobName(model.trainingJobName);
            this.hyperParameters(model.hyperParameters);
            this.algorithmSpecification(model.algorithmSpecification);
            this.roleArn(model.roleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.vpcConfig(model.vpcConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.tags(model.tags);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
        }

        public final String getTrainingJobName() {
            return this.trainingJobName;
        }

        @Override
        public final Builder trainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
            return this;
        }

        public final void setTrainingJobName(String trainingJobName) {
            this.trainingJobName = trainingJobName;
        }

        public final Map<String, String> getHyperParameters() {
            return this.hyperParameters;
        }

        @Override
        public final Builder hyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
            return this;
        }

        public final void setHyperParameters(Map<String, String> hyperParameters) {
            this.hyperParameters = HyperParametersCopier.copy(hyperParameters);
        }

        public final AlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        @Override
        public final Builder algorithmSpecification(AlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final void setAlgorithmSpecification(AlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final Collection<Channel.Builder> getInputDataConfig() {
            return this.inputDataConfig != null ? (Collection)this.inputDataConfig.stream().map(Channel::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        public final Collection<Tag.Builder> getTags() {
            return this.tags != null ? (Collection)this.tags.stream().map(Tag::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTrainingJobRequest build() {
            return new CreateTrainingJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTrainingJobRequest> {
        public Builder trainingJobName(String var1);

        public Builder hyperParameters(Map<String, String> var1);

        public Builder algorithmSpecification(AlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<AlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((AlgorithmSpecification)((AlgorithmSpecification.Builder)AlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

