/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.EndpointOutputConfiguration;
import software.amazon.awssdk.services.sagemaker.model.ModelConfiguration;
import software.amazon.awssdk.services.sagemaker.model.RecommendationMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationJobInferenceBenchmark
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationJobInferenceBenchmark> {
    private static final SdkField<RecommendationMetrics> METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Metrics").getter(RecommendationJobInferenceBenchmark.getter(RecommendationJobInferenceBenchmark::metrics)).setter(RecommendationJobInferenceBenchmark.setter(Builder::metrics)).constructor(RecommendationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metrics").build()}).build();
    private static final SdkField<EndpointOutputConfiguration> ENDPOINT_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("EndpointConfiguration").getter(RecommendationJobInferenceBenchmark.getter(RecommendationJobInferenceBenchmark::endpointConfiguration)).setter(RecommendationJobInferenceBenchmark.setter(Builder::endpointConfiguration)).constructor(EndpointOutputConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndpointConfiguration").build()}).build();
    private static final SdkField<ModelConfiguration> MODEL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ModelConfiguration").getter(RecommendationJobInferenceBenchmark.getter(RecommendationJobInferenceBenchmark::modelConfiguration)).setter(RecommendationJobInferenceBenchmark.setter(Builder::modelConfiguration)).constructor(ModelConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelConfiguration").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FailureReason").getter(RecommendationJobInferenceBenchmark.getter(RecommendationJobInferenceBenchmark::failureReason)).setter(RecommendationJobInferenceBenchmark.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FailureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRICS_FIELD, ENDPOINT_CONFIGURATION_FIELD, MODEL_CONFIGURATION_FIELD, FAILURE_REASON_FIELD));
    private static final long serialVersionUID = 1L;
    private final RecommendationMetrics metrics;
    private final EndpointOutputConfiguration endpointConfiguration;
    private final ModelConfiguration modelConfiguration;
    private final String failureReason;

    private RecommendationJobInferenceBenchmark(BuilderImpl builder) {
        this.metrics = builder.metrics;
        this.endpointConfiguration = builder.endpointConfiguration;
        this.modelConfiguration = builder.modelConfiguration;
        this.failureReason = builder.failureReason;
    }

    public final RecommendationMetrics metrics() {
        return this.metrics;
    }

    public final EndpointOutputConfiguration endpointConfiguration() {
        return this.endpointConfiguration;
    }

    public final ModelConfiguration modelConfiguration() {
        return this.modelConfiguration;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.endpointConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationJobInferenceBenchmark)) {
            return false;
        }
        RecommendationJobInferenceBenchmark other = (RecommendationJobInferenceBenchmark)obj;
        return Objects.equals(this.metrics(), other.metrics()) && Objects.equals(this.endpointConfiguration(), other.endpointConfiguration()) && Objects.equals(this.modelConfiguration(), other.modelConfiguration()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationJobInferenceBenchmark").add("Metrics", (Object)this.metrics()).add("EndpointConfiguration", (Object)this.endpointConfiguration()).add("ModelConfiguration", (Object)this.modelConfiguration()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Metrics": {
                return Optional.ofNullable(clazz.cast(this.metrics()));
            }
            case "EndpointConfiguration": {
                return Optional.ofNullable(clazz.cast(this.endpointConfiguration()));
            }
            case "ModelConfiguration": {
                return Optional.ofNullable(clazz.cast(this.modelConfiguration()));
            }
            case "FailureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationJobInferenceBenchmark, T> g) {
        return obj -> g.apply((RecommendationJobInferenceBenchmark)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RecommendationMetrics metrics;
        private EndpointOutputConfiguration endpointConfiguration;
        private ModelConfiguration modelConfiguration;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationJobInferenceBenchmark model) {
            this.metrics(model.metrics);
            this.endpointConfiguration(model.endpointConfiguration);
            this.modelConfiguration(model.modelConfiguration);
            this.failureReason(model.failureReason);
        }

        public final RecommendationMetrics.Builder getMetrics() {
            return this.metrics != null ? this.metrics.toBuilder() : null;
        }

        public final void setMetrics(RecommendationMetrics.BuilderImpl metrics) {
            this.metrics = metrics != null ? metrics.build() : null;
        }

        @Override
        public final Builder metrics(RecommendationMetrics metrics) {
            this.metrics = metrics;
            return this;
        }

        public final EndpointOutputConfiguration.Builder getEndpointConfiguration() {
            return this.endpointConfiguration != null ? this.endpointConfiguration.toBuilder() : null;
        }

        public final void setEndpointConfiguration(EndpointOutputConfiguration.BuilderImpl endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration != null ? endpointConfiguration.build() : null;
        }

        @Override
        public final Builder endpointConfiguration(EndpointOutputConfiguration endpointConfiguration) {
            this.endpointConfiguration = endpointConfiguration;
            return this;
        }

        public final ModelConfiguration.Builder getModelConfiguration() {
            return this.modelConfiguration != null ? this.modelConfiguration.toBuilder() : null;
        }

        public final void setModelConfiguration(ModelConfiguration.BuilderImpl modelConfiguration) {
            this.modelConfiguration = modelConfiguration != null ? modelConfiguration.build() : null;
        }

        @Override
        public final Builder modelConfiguration(ModelConfiguration modelConfiguration) {
            this.modelConfiguration = modelConfiguration;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public RecommendationJobInferenceBenchmark build() {
            return new RecommendationJobInferenceBenchmark(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationJobInferenceBenchmark> {
        public Builder metrics(RecommendationMetrics var1);

        default public Builder metrics(Consumer<RecommendationMetrics.Builder> metrics) {
            return this.metrics((RecommendationMetrics)((RecommendationMetrics.Builder)RecommendationMetrics.builder().applyMutation(metrics)).build());
        }

        public Builder endpointConfiguration(EndpointOutputConfiguration var1);

        default public Builder endpointConfiguration(Consumer<EndpointOutputConfiguration.Builder> endpointConfiguration) {
            return this.endpointConfiguration((EndpointOutputConfiguration)((EndpointOutputConfiguration.Builder)EndpointOutputConfiguration.builder().applyMutation(endpointConfiguration)).build());
        }

        public Builder modelConfiguration(ModelConfiguration var1);

        default public Builder modelConfiguration(Consumer<ModelConfiguration.Builder> modelConfiguration) {
            return this.modelConfiguration((ModelConfiguration)((ModelConfiguration.Builder)ModelConfiguration.builder().applyMutation(modelConfiguration)).build());
        }

        public Builder failureReason(String var1);
    }
}

