/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InferenceMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InferenceMetrics> {
    private static final SdkField<Integer> MAX_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInvocations").getter(InferenceMetrics.getter(InferenceMetrics::maxInvocations)).setter(InferenceMetrics.setter(Builder::maxInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocations").build()}).build();
    private static final SdkField<Integer> MODEL_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelLatency").getter(InferenceMetrics.getter(InferenceMetrics::modelLatency)).setter(InferenceMetrics.setter(Builder::modelLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_INVOCATIONS_FIELD, MODEL_LATENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Integer maxInvocations;
    private final Integer modelLatency;

    private InferenceMetrics(BuilderImpl builder) {
        this.maxInvocations = builder.maxInvocations;
        this.modelLatency = builder.modelLatency;
    }

    public final Integer maxInvocations() {
        return this.maxInvocations;
    }

    public final Integer modelLatency() {
        return this.modelLatency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelLatency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InferenceMetrics)) {
            return false;
        }
        InferenceMetrics other = (InferenceMetrics)obj;
        return Objects.equals(this.maxInvocations(), other.maxInvocations()) && Objects.equals(this.modelLatency(), other.modelLatency());
    }

    public final String toString() {
        return ToString.builder((String)"InferenceMetrics").add("MaxInvocations", (Object)this.maxInvocations()).add("ModelLatency", (Object)this.modelLatency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MaxInvocations": {
                return Optional.ofNullable(clazz.cast(this.maxInvocations()));
            }
            case "ModelLatency": {
                return Optional.ofNullable(clazz.cast(this.modelLatency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InferenceMetrics, T> g) {
        return obj -> g.apply((InferenceMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer maxInvocations;
        private Integer modelLatency;

        private BuilderImpl() {
        }

        private BuilderImpl(InferenceMetrics model) {
            this.maxInvocations(model.maxInvocations);
            this.modelLatency(model.modelLatency);
        }

        public final Integer getMaxInvocations() {
            return this.maxInvocations;
        }

        public final void setMaxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
        }

        @Override
        public final Builder maxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
            return this;
        }

        public final Integer getModelLatency() {
            return this.modelLatency;
        }

        public final void setModelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
        }

        @Override
        public final Builder modelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
            return this;
        }

        public InferenceMetrics build() {
            return new InferenceMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InferenceMetrics> {
        public Builder maxInvocations(Integer var1);

        public Builder modelLatency(Integer var1);
    }
}

