/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ModelLatencyThreshold
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ModelLatencyThreshold> {
    private static final SdkField<String> PERCENTILE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Percentile").getter(ModelLatencyThreshold.getter(ModelLatencyThreshold::percentile)).setter(ModelLatencyThreshold.setter(Builder::percentile)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Percentile").build()}).build();
    private static final SdkField<Integer> VALUE_IN_MILLISECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ValueInMilliseconds").getter(ModelLatencyThreshold.getter(ModelLatencyThreshold::valueInMilliseconds)).setter(ModelLatencyThreshold.setter(Builder::valueInMilliseconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueInMilliseconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PERCENTILE_FIELD, VALUE_IN_MILLISECONDS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String percentile;
    private final Integer valueInMilliseconds;

    private ModelLatencyThreshold(BuilderImpl builder) {
        this.percentile = builder.percentile;
        this.valueInMilliseconds = builder.valueInMilliseconds;
    }

    public final String percentile() {
        return this.percentile;
    }

    public final Integer valueInMilliseconds() {
        return this.valueInMilliseconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.percentile());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueInMilliseconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModelLatencyThreshold)) {
            return false;
        }
        ModelLatencyThreshold other = (ModelLatencyThreshold)obj;
        return Objects.equals(this.percentile(), other.percentile()) && Objects.equals(this.valueInMilliseconds(), other.valueInMilliseconds());
    }

    public final String toString() {
        return ToString.builder((String)"ModelLatencyThreshold").add("Percentile", (Object)this.percentile()).add("ValueInMilliseconds", (Object)this.valueInMilliseconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Percentile": {
                return Optional.ofNullable(clazz.cast(this.percentile()));
            }
            case "ValueInMilliseconds": {
                return Optional.ofNullable(clazz.cast(this.valueInMilliseconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelLatencyThreshold, T> g) {
        return obj -> g.apply((ModelLatencyThreshold)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String percentile;
        private Integer valueInMilliseconds;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelLatencyThreshold model) {
            this.percentile(model.percentile);
            this.valueInMilliseconds(model.valueInMilliseconds);
        }

        public final String getPercentile() {
            return this.percentile;
        }

        public final void setPercentile(String percentile) {
            this.percentile = percentile;
        }

        @Override
        public final Builder percentile(String percentile) {
            this.percentile = percentile;
            return this;
        }

        public final Integer getValueInMilliseconds() {
            return this.valueInMilliseconds;
        }

        public final void setValueInMilliseconds(Integer valueInMilliseconds) {
            this.valueInMilliseconds = valueInMilliseconds;
        }

        @Override
        public final Builder valueInMilliseconds(Integer valueInMilliseconds) {
            this.valueInMilliseconds = valueInMilliseconds;
            return this;
        }

        public ModelLatencyThreshold build() {
            return new ModelLatencyThreshold(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ModelLatencyThreshold> {
        public Builder percentile(String var1);

        public Builder valueInMilliseconds(Integer var1);
    }
}

