/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.HumanTaskUiStatus;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.services.sagemaker.model.UiTemplateInfo;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeHumanTaskUiResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeHumanTaskUiResponse> {
    private static final SdkField<String> HUMAN_TASK_UI_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanTaskUiArn").getter(DescribeHumanTaskUiResponse.getter(DescribeHumanTaskUiResponse::humanTaskUiArn)).setter(DescribeHumanTaskUiResponse.setter(Builder::humanTaskUiArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiArn").build()}).build();
    private static final SdkField<String> HUMAN_TASK_UI_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanTaskUiName").getter(DescribeHumanTaskUiResponse.getter(DescribeHumanTaskUiResponse::humanTaskUiName)).setter(DescribeHumanTaskUiResponse.setter(Builder::humanTaskUiName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiName").build()}).build();
    private static final SdkField<String> HUMAN_TASK_UI_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HumanTaskUiStatus").getter(DescribeHumanTaskUiResponse.getter(DescribeHumanTaskUiResponse::humanTaskUiStatusAsString)).setter(DescribeHumanTaskUiResponse.setter(Builder::humanTaskUiStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HumanTaskUiStatus").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeHumanTaskUiResponse.getter(DescribeHumanTaskUiResponse::creationTime)).setter(DescribeHumanTaskUiResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<UiTemplateInfo> UI_TEMPLATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UiTemplate").getter(DescribeHumanTaskUiResponse.getter(DescribeHumanTaskUiResponse::uiTemplate)).setter(DescribeHumanTaskUiResponse.setter(Builder::uiTemplate)).constructor(UiTemplateInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UiTemplate").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HUMAN_TASK_UI_ARN_FIELD, HUMAN_TASK_UI_NAME_FIELD, HUMAN_TASK_UI_STATUS_FIELD, CREATION_TIME_FIELD, UI_TEMPLATE_FIELD));
    private final String humanTaskUiArn;
    private final String humanTaskUiName;
    private final String humanTaskUiStatus;
    private final Instant creationTime;
    private final UiTemplateInfo uiTemplate;

    private DescribeHumanTaskUiResponse(BuilderImpl builder) {
        super(builder);
        this.humanTaskUiArn = builder.humanTaskUiArn;
        this.humanTaskUiName = builder.humanTaskUiName;
        this.humanTaskUiStatus = builder.humanTaskUiStatus;
        this.creationTime = builder.creationTime;
        this.uiTemplate = builder.uiTemplate;
    }

    public final String humanTaskUiArn() {
        return this.humanTaskUiArn;
    }

    public final String humanTaskUiName() {
        return this.humanTaskUiName;
    }

    public final HumanTaskUiStatus humanTaskUiStatus() {
        return HumanTaskUiStatus.fromValue(this.humanTaskUiStatus);
    }

    public final String humanTaskUiStatusAsString() {
        return this.humanTaskUiStatus;
    }

    public final Instant creationTime() {
        return this.creationTime;
    }

    public final UiTemplateInfo uiTemplate() {
        return this.uiTemplate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.humanTaskUiArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanTaskUiName());
        hashCode = 31 * hashCode + Objects.hashCode(this.humanTaskUiStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.uiTemplate());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeHumanTaskUiResponse)) {
            return false;
        }
        DescribeHumanTaskUiResponse other = (DescribeHumanTaskUiResponse)((Object)obj);
        return Objects.equals(this.humanTaskUiArn(), other.humanTaskUiArn()) && Objects.equals(this.humanTaskUiName(), other.humanTaskUiName()) && Objects.equals(this.humanTaskUiStatusAsString(), other.humanTaskUiStatusAsString()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.uiTemplate(), other.uiTemplate());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeHumanTaskUiResponse").add("HumanTaskUiArn", (Object)this.humanTaskUiArn()).add("HumanTaskUiName", (Object)this.humanTaskUiName()).add("HumanTaskUiStatus", (Object)this.humanTaskUiStatusAsString()).add("CreationTime", (Object)this.creationTime()).add("UiTemplate", (Object)this.uiTemplate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "HumanTaskUiArn": {
                return Optional.ofNullable(clazz.cast(this.humanTaskUiArn()));
            }
            case "HumanTaskUiName": {
                return Optional.ofNullable(clazz.cast(this.humanTaskUiName()));
            }
            case "HumanTaskUiStatus": {
                return Optional.ofNullable(clazz.cast(this.humanTaskUiStatusAsString()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "UiTemplate": {
                return Optional.ofNullable(clazz.cast(this.uiTemplate()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeHumanTaskUiResponse, T> g) {
        return obj -> g.apply((DescribeHumanTaskUiResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String humanTaskUiArn;
        private String humanTaskUiName;
        private String humanTaskUiStatus;
        private Instant creationTime;
        private UiTemplateInfo uiTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeHumanTaskUiResponse model) {
            super(model);
            this.humanTaskUiArn(model.humanTaskUiArn);
            this.humanTaskUiName(model.humanTaskUiName);
            this.humanTaskUiStatus(model.humanTaskUiStatus);
            this.creationTime(model.creationTime);
            this.uiTemplate(model.uiTemplate);
        }

        public final String getHumanTaskUiArn() {
            return this.humanTaskUiArn;
        }

        @Override
        public final Builder humanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
            return this;
        }

        public final void setHumanTaskUiArn(String humanTaskUiArn) {
            this.humanTaskUiArn = humanTaskUiArn;
        }

        public final String getHumanTaskUiName() {
            return this.humanTaskUiName;
        }

        @Override
        public final Builder humanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
            return this;
        }

        public final void setHumanTaskUiName(String humanTaskUiName) {
            this.humanTaskUiName = humanTaskUiName;
        }

        public final String getHumanTaskUiStatus() {
            return this.humanTaskUiStatus;
        }

        @Override
        public final Builder humanTaskUiStatus(String humanTaskUiStatus) {
            this.humanTaskUiStatus = humanTaskUiStatus;
            return this;
        }

        @Override
        public final Builder humanTaskUiStatus(HumanTaskUiStatus humanTaskUiStatus) {
            this.humanTaskUiStatus(humanTaskUiStatus == null ? null : humanTaskUiStatus.toString());
            return this;
        }

        public final void setHumanTaskUiStatus(String humanTaskUiStatus) {
            this.humanTaskUiStatus = humanTaskUiStatus;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final UiTemplateInfo.Builder getUiTemplate() {
            return this.uiTemplate != null ? this.uiTemplate.toBuilder() : null;
        }

        @Override
        public final Builder uiTemplate(UiTemplateInfo uiTemplate) {
            this.uiTemplate = uiTemplate;
            return this;
        }

        public final void setUiTemplate(UiTemplateInfo.BuilderImpl uiTemplate) {
            this.uiTemplate = uiTemplate != null ? uiTemplate.build() : null;
        }

        @Override
        public DescribeHumanTaskUiResponse build() {
            return new DescribeHumanTaskUiResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeHumanTaskUiResponse> {
        public Builder humanTaskUiArn(String var1);

        public Builder humanTaskUiName(String var1);

        public Builder humanTaskUiStatus(String var1);

        public Builder humanTaskUiStatus(HumanTaskUiStatus var1);

        public Builder creationTime(Instant var1);

        public Builder uiTemplate(UiTemplateInfo var1);

        default public Builder uiTemplate(Consumer<UiTemplateInfo.Builder> uiTemplate) {
            return this.uiTemplate((UiTemplateInfo)((UiTemplateInfo.Builder)UiTemplateInfo.builder().applyMutation(uiTemplate)).build());
        }
    }
}

