/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListArtifactsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListArtifactsResponse> {
    private static final SdkField<List<ArtifactSummary>> ARTIFACT_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ArtifactSummaries").getter(ListArtifactsResponse.getter(ListArtifactsResponse::artifactSummaries)).setter(ListArtifactsResponse.setter(Builder::artifactSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ArtifactSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListArtifactsResponse.getter(ListArtifactsResponse::nextToken)).setter(ListArtifactsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<ArtifactSummary> artifactSummaries;
    private final String nextToken;

    private ListArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.artifactSummaries = builder.artifactSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasArtifactSummaries() {
        return this.artifactSummaries != null && !(this.artifactSummaries instanceof SdkAutoConstructList);
    }

    public final List<ArtifactSummary> artifactSummaries() {
        return this.artifactSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifactSummaries() ? this.artifactSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListArtifactsResponse)) {
            return false;
        }
        ListArtifactsResponse other = (ListArtifactsResponse)((Object)obj);
        return this.hasArtifactSummaries() == other.hasArtifactSummaries() && Objects.equals(this.artifactSummaries(), other.artifactSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListArtifactsResponse").add("ArtifactSummaries", this.hasArtifactSummaries() ? this.artifactSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArtifactSummaries": {
                return Optional.ofNullable(clazz.cast(this.artifactSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListArtifactsResponse, T> g) {
        return obj -> g.apply((ListArtifactsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<ArtifactSummary> artifactSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListArtifactsResponse model) {
            super(model);
            this.artifactSummaries(model.artifactSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<ArtifactSummary.Builder> getArtifactSummaries() {
            List<ArtifactSummary.Builder> result = ArtifactSummariesCopier.copyToBuilder(this.artifactSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setArtifactSummaries(Collection<ArtifactSummary.BuilderImpl> artifactSummaries) {
            this.artifactSummaries = ArtifactSummariesCopier.copyFromBuilder(artifactSummaries);
        }

        @Override
        @Transient
        public final Builder artifactSummaries(Collection<ArtifactSummary> artifactSummaries) {
            this.artifactSummaries = ArtifactSummariesCopier.copy(artifactSummaries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder artifactSummaries(ArtifactSummary ... artifactSummaries) {
            this.artifactSummaries(Arrays.asList(artifactSummaries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder artifactSummaries(Consumer<ArtifactSummary.Builder> ... artifactSummaries) {
            this.artifactSummaries(Stream.of(artifactSummaries).map(c -> (ArtifactSummary)((ArtifactSummary.Builder)ArtifactSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListArtifactsResponse build() {
            return new ListArtifactsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListArtifactsResponse> {
        public Builder artifactSummaries(Collection<ArtifactSummary> var1);

        public Builder artifactSummaries(ArtifactSummary ... var1);

        public Builder artifactSummaries(Consumer<ArtifactSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

