/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.sagemaker.model.Channel;
import software.amazon.awssdk.services.sagemaker.model.CheckpointConfig;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterAlgorithmSpecification;
import software.amazon.awssdk.services.sagemaker.model.HyperParameterTuningJobObjective;
import software.amazon.awssdk.services.sagemaker.model.HyperParametersCopier;
import software.amazon.awssdk.services.sagemaker.model.InputDataConfigCopier;
import software.amazon.awssdk.services.sagemaker.model.OutputDataConfig;
import software.amazon.awssdk.services.sagemaker.model.ParameterRanges;
import software.amazon.awssdk.services.sagemaker.model.ResourceConfig;
import software.amazon.awssdk.services.sagemaker.model.RetryStrategy;
import software.amazon.awssdk.services.sagemaker.model.StoppingCondition;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterTrainingJobDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterTrainingJobDefinition> {
    private static final SdkField<String> DEFINITION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DefinitionName").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::definitionName)).setter(HyperParameterTrainingJobDefinition.setter(Builder::definitionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefinitionName").build()}).build();
    private static final SdkField<HyperParameterTuningJobObjective> TUNING_OBJECTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TuningObjective").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::tuningObjective)).setter(HyperParameterTrainingJobDefinition.setter(Builder::tuningObjective)).constructor(HyperParameterTuningJobObjective::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TuningObjective").build()}).build();
    private static final SdkField<ParameterRanges> HYPER_PARAMETER_RANGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("HyperParameterRanges").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::hyperParameterRanges)).setter(HyperParameterTrainingJobDefinition.setter(Builder::hyperParameterRanges)).constructor(ParameterRanges::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HyperParameterRanges").build()}).build();
    private static final SdkField<Map<String, String>> STATIC_HYPER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("StaticHyperParameters").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::staticHyperParameters)).setter(HyperParameterTrainingJobDefinition.setter(Builder::staticHyperParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StaticHyperParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<HyperParameterAlgorithmSpecification> ALGORITHM_SPECIFICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AlgorithmSpecification").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::algorithmSpecification)).setter(HyperParameterTrainingJobDefinition.setter(Builder::algorithmSpecification)).constructor(HyperParameterAlgorithmSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmSpecification").build()}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RoleArn").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::roleArn)).setter(HyperParameterTrainingJobDefinition.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RoleArn").build()}).build();
    private static final SdkField<List<Channel>> INPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("InputDataConfig").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::inputDataConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::inputDataConfig)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InputDataConfig").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Channel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::vpcConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<OutputDataConfig> OUTPUT_DATA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("OutputDataConfig").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::outputDataConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::outputDataConfig)).constructor(OutputDataConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputDataConfig").build()}).build();
    private static final SdkField<ResourceConfig> RESOURCE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ResourceConfig").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::resourceConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::resourceConfig)).constructor(ResourceConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceConfig").build()}).build();
    private static final SdkField<StoppingCondition> STOPPING_CONDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StoppingCondition").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::stoppingCondition)).setter(HyperParameterTrainingJobDefinition.setter(Builder::stoppingCondition)).constructor(StoppingCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StoppingCondition").build()}).build();
    private static final SdkField<Boolean> ENABLE_NETWORK_ISOLATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableNetworkIsolation").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::enableNetworkIsolation)).setter(HyperParameterTrainingJobDefinition.setter(Builder::enableNetworkIsolation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableNetworkIsolation").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableInterContainerTrafficEncryption").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::enableInterContainerTrafficEncryption)).setter(HyperParameterTrainingJobDefinition.setter(Builder::enableInterContainerTrafficEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInterContainerTrafficEncryption").build()}).build();
    private static final SdkField<Boolean> ENABLE_MANAGED_SPOT_TRAINING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableManagedSpotTraining").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::enableManagedSpotTraining)).setter(HyperParameterTrainingJobDefinition.setter(Builder::enableManagedSpotTraining)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableManagedSpotTraining").build()}).build();
    private static final SdkField<CheckpointConfig> CHECKPOINT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CheckpointConfig").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::checkpointConfig)).setter(HyperParameterTrainingJobDefinition.setter(Builder::checkpointConfig)).constructor(CheckpointConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CheckpointConfig").build()}).build();
    private static final SdkField<RetryStrategy> RETRY_STRATEGY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RetryStrategy").getter(HyperParameterTrainingJobDefinition.getter(HyperParameterTrainingJobDefinition::retryStrategy)).setter(HyperParameterTrainingJobDefinition.setter(Builder::retryStrategy)).constructor(RetryStrategy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetryStrategy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFINITION_NAME_FIELD, TUNING_OBJECTIVE_FIELD, HYPER_PARAMETER_RANGES_FIELD, STATIC_HYPER_PARAMETERS_FIELD, ALGORITHM_SPECIFICATION_FIELD, ROLE_ARN_FIELD, INPUT_DATA_CONFIG_FIELD, VPC_CONFIG_FIELD, OUTPUT_DATA_CONFIG_FIELD, RESOURCE_CONFIG_FIELD, STOPPING_CONDITION_FIELD, ENABLE_NETWORK_ISOLATION_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, ENABLE_MANAGED_SPOT_TRAINING_FIELD, CHECKPOINT_CONFIG_FIELD, RETRY_STRATEGY_FIELD));
    private static final long serialVersionUID = 1L;
    private final String definitionName;
    private final HyperParameterTuningJobObjective tuningObjective;
    private final ParameterRanges hyperParameterRanges;
    private final Map<String, String> staticHyperParameters;
    private final HyperParameterAlgorithmSpecification algorithmSpecification;
    private final String roleArn;
    private final List<Channel> inputDataConfig;
    private final VpcConfig vpcConfig;
    private final OutputDataConfig outputDataConfig;
    private final ResourceConfig resourceConfig;
    private final StoppingCondition stoppingCondition;
    private final Boolean enableNetworkIsolation;
    private final Boolean enableInterContainerTrafficEncryption;
    private final Boolean enableManagedSpotTraining;
    private final CheckpointConfig checkpointConfig;
    private final RetryStrategy retryStrategy;

    private HyperParameterTrainingJobDefinition(BuilderImpl builder) {
        this.definitionName = builder.definitionName;
        this.tuningObjective = builder.tuningObjective;
        this.hyperParameterRanges = builder.hyperParameterRanges;
        this.staticHyperParameters = builder.staticHyperParameters;
        this.algorithmSpecification = builder.algorithmSpecification;
        this.roleArn = builder.roleArn;
        this.inputDataConfig = builder.inputDataConfig;
        this.vpcConfig = builder.vpcConfig;
        this.outputDataConfig = builder.outputDataConfig;
        this.resourceConfig = builder.resourceConfig;
        this.stoppingCondition = builder.stoppingCondition;
        this.enableNetworkIsolation = builder.enableNetworkIsolation;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.enableManagedSpotTraining = builder.enableManagedSpotTraining;
        this.checkpointConfig = builder.checkpointConfig;
        this.retryStrategy = builder.retryStrategy;
    }

    public final String definitionName() {
        return this.definitionName;
    }

    public final HyperParameterTuningJobObjective tuningObjective() {
        return this.tuningObjective;
    }

    public final ParameterRanges hyperParameterRanges() {
        return this.hyperParameterRanges;
    }

    public final boolean hasStaticHyperParameters() {
        return this.staticHyperParameters != null && !(this.staticHyperParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> staticHyperParameters() {
        return this.staticHyperParameters;
    }

    public final HyperParameterAlgorithmSpecification algorithmSpecification() {
        return this.algorithmSpecification;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final boolean hasInputDataConfig() {
        return this.inputDataConfig != null && !(this.inputDataConfig instanceof SdkAutoConstructList);
    }

    public final List<Channel> inputDataConfig() {
        return this.inputDataConfig;
    }

    public final VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public final OutputDataConfig outputDataConfig() {
        return this.outputDataConfig;
    }

    public final ResourceConfig resourceConfig() {
        return this.resourceConfig;
    }

    public final StoppingCondition stoppingCondition() {
        return this.stoppingCondition;
    }

    public final Boolean enableNetworkIsolation() {
        return this.enableNetworkIsolation;
    }

    public final Boolean enableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public final Boolean enableManagedSpotTraining() {
        return this.enableManagedSpotTraining;
    }

    public final CheckpointConfig checkpointConfig() {
        return this.checkpointConfig;
    }

    public final RetryStrategy retryStrategy() {
        return this.retryStrategy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.definitionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tuningObjective());
        hashCode = 31 * hashCode + Objects.hashCode(this.hyperParameterRanges());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasStaticHyperParameters() ? this.staticHyperParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmSpecification());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputDataConfig() ? this.inputDataConfig() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputDataConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.stoppingCondition());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableNetworkIsolation());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableManagedSpotTraining());
        hashCode = 31 * hashCode + Objects.hashCode(this.checkpointConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.retryStrategy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterTrainingJobDefinition)) {
            return false;
        }
        HyperParameterTrainingJobDefinition other = (HyperParameterTrainingJobDefinition)obj;
        return Objects.equals(this.definitionName(), other.definitionName()) && Objects.equals(this.tuningObjective(), other.tuningObjective()) && Objects.equals(this.hyperParameterRanges(), other.hyperParameterRanges()) && this.hasStaticHyperParameters() == other.hasStaticHyperParameters() && Objects.equals(this.staticHyperParameters(), other.staticHyperParameters()) && Objects.equals(this.algorithmSpecification(), other.algorithmSpecification()) && Objects.equals(this.roleArn(), other.roleArn()) && this.hasInputDataConfig() == other.hasInputDataConfig() && Objects.equals(this.inputDataConfig(), other.inputDataConfig()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.outputDataConfig(), other.outputDataConfig()) && Objects.equals(this.resourceConfig(), other.resourceConfig()) && Objects.equals(this.stoppingCondition(), other.stoppingCondition()) && Objects.equals(this.enableNetworkIsolation(), other.enableNetworkIsolation()) && Objects.equals(this.enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption()) && Objects.equals(this.enableManagedSpotTraining(), other.enableManagedSpotTraining()) && Objects.equals(this.checkpointConfig(), other.checkpointConfig()) && Objects.equals(this.retryStrategy(), other.retryStrategy());
    }

    public final String toString() {
        return ToString.builder((String)"HyperParameterTrainingJobDefinition").add("DefinitionName", (Object)this.definitionName()).add("TuningObjective", (Object)this.tuningObjective()).add("HyperParameterRanges", (Object)this.hyperParameterRanges()).add("StaticHyperParameters", this.hasStaticHyperParameters() ? this.staticHyperParameters() : null).add("AlgorithmSpecification", (Object)this.algorithmSpecification()).add("RoleArn", (Object)this.roleArn()).add("InputDataConfig", this.hasInputDataConfig() ? this.inputDataConfig() : null).add("VpcConfig", (Object)this.vpcConfig()).add("OutputDataConfig", (Object)this.outputDataConfig()).add("ResourceConfig", (Object)this.resourceConfig()).add("StoppingCondition", (Object)this.stoppingCondition()).add("EnableNetworkIsolation", (Object)this.enableNetworkIsolation()).add("EnableInterContainerTrafficEncryption", (Object)this.enableInterContainerTrafficEncryption()).add("EnableManagedSpotTraining", (Object)this.enableManagedSpotTraining()).add("CheckpointConfig", (Object)this.checkpointConfig()).add("RetryStrategy", (Object)this.retryStrategy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefinitionName": {
                return Optional.ofNullable(clazz.cast(this.definitionName()));
            }
            case "TuningObjective": {
                return Optional.ofNullable(clazz.cast(this.tuningObjective()));
            }
            case "HyperParameterRanges": {
                return Optional.ofNullable(clazz.cast(this.hyperParameterRanges()));
            }
            case "StaticHyperParameters": {
                return Optional.ofNullable(clazz.cast(this.staticHyperParameters()));
            }
            case "AlgorithmSpecification": {
                return Optional.ofNullable(clazz.cast(this.algorithmSpecification()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "InputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.inputDataConfig()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "OutputDataConfig": {
                return Optional.ofNullable(clazz.cast(this.outputDataConfig()));
            }
            case "ResourceConfig": {
                return Optional.ofNullable(clazz.cast(this.resourceConfig()));
            }
            case "StoppingCondition": {
                return Optional.ofNullable(clazz.cast(this.stoppingCondition()));
            }
            case "EnableNetworkIsolation": {
                return Optional.ofNullable(clazz.cast(this.enableNetworkIsolation()));
            }
            case "EnableInterContainerTrafficEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableInterContainerTrafficEncryption()));
            }
            case "EnableManagedSpotTraining": {
                return Optional.ofNullable(clazz.cast(this.enableManagedSpotTraining()));
            }
            case "CheckpointConfig": {
                return Optional.ofNullable(clazz.cast(this.checkpointConfig()));
            }
            case "RetryStrategy": {
                return Optional.ofNullable(clazz.cast(this.retryStrategy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterTrainingJobDefinition, T> g) {
        return obj -> g.apply((HyperParameterTrainingJobDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String definitionName;
        private HyperParameterTuningJobObjective tuningObjective;
        private ParameterRanges hyperParameterRanges;
        private Map<String, String> staticHyperParameters = DefaultSdkAutoConstructMap.getInstance();
        private HyperParameterAlgorithmSpecification algorithmSpecification;
        private String roleArn;
        private List<Channel> inputDataConfig = DefaultSdkAutoConstructList.getInstance();
        private VpcConfig vpcConfig;
        private OutputDataConfig outputDataConfig;
        private ResourceConfig resourceConfig;
        private StoppingCondition stoppingCondition;
        private Boolean enableNetworkIsolation;
        private Boolean enableInterContainerTrafficEncryption;
        private Boolean enableManagedSpotTraining;
        private CheckpointConfig checkpointConfig;
        private RetryStrategy retryStrategy;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterTrainingJobDefinition model) {
            this.definitionName(model.definitionName);
            this.tuningObjective(model.tuningObjective);
            this.hyperParameterRanges(model.hyperParameterRanges);
            this.staticHyperParameters(model.staticHyperParameters);
            this.algorithmSpecification(model.algorithmSpecification);
            this.roleArn(model.roleArn);
            this.inputDataConfig(model.inputDataConfig);
            this.vpcConfig(model.vpcConfig);
            this.outputDataConfig(model.outputDataConfig);
            this.resourceConfig(model.resourceConfig);
            this.stoppingCondition(model.stoppingCondition);
            this.enableNetworkIsolation(model.enableNetworkIsolation);
            this.enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            this.enableManagedSpotTraining(model.enableManagedSpotTraining);
            this.checkpointConfig(model.checkpointConfig);
            this.retryStrategy(model.retryStrategy);
        }

        public final String getDefinitionName() {
            return this.definitionName;
        }

        public final void setDefinitionName(String definitionName) {
            this.definitionName = definitionName;
        }

        @Override
        public final Builder definitionName(String definitionName) {
            this.definitionName = definitionName;
            return this;
        }

        public final HyperParameterTuningJobObjective.Builder getTuningObjective() {
            return this.tuningObjective != null ? this.tuningObjective.toBuilder() : null;
        }

        public final void setTuningObjective(HyperParameterTuningJobObjective.BuilderImpl tuningObjective) {
            this.tuningObjective = tuningObjective != null ? tuningObjective.build() : null;
        }

        @Override
        public final Builder tuningObjective(HyperParameterTuningJobObjective tuningObjective) {
            this.tuningObjective = tuningObjective;
            return this;
        }

        public final ParameterRanges.Builder getHyperParameterRanges() {
            return this.hyperParameterRanges != null ? this.hyperParameterRanges.toBuilder() : null;
        }

        public final void setHyperParameterRanges(ParameterRanges.BuilderImpl hyperParameterRanges) {
            this.hyperParameterRanges = hyperParameterRanges != null ? hyperParameterRanges.build() : null;
        }

        @Override
        public final Builder hyperParameterRanges(ParameterRanges hyperParameterRanges) {
            this.hyperParameterRanges = hyperParameterRanges;
            return this;
        }

        public final Map<String, String> getStaticHyperParameters() {
            if (this.staticHyperParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.staticHyperParameters;
        }

        public final void setStaticHyperParameters(Map<String, String> staticHyperParameters) {
            this.staticHyperParameters = HyperParametersCopier.copy(staticHyperParameters);
        }

        @Override
        public final Builder staticHyperParameters(Map<String, String> staticHyperParameters) {
            this.staticHyperParameters = HyperParametersCopier.copy(staticHyperParameters);
            return this;
        }

        public final HyperParameterAlgorithmSpecification.Builder getAlgorithmSpecification() {
            return this.algorithmSpecification != null ? this.algorithmSpecification.toBuilder() : null;
        }

        public final void setAlgorithmSpecification(HyperParameterAlgorithmSpecification.BuilderImpl algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification != null ? algorithmSpecification.build() : null;
        }

        @Override
        public final Builder algorithmSpecification(HyperParameterAlgorithmSpecification algorithmSpecification) {
            this.algorithmSpecification = algorithmSpecification;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final List<Channel.Builder> getInputDataConfig() {
            List<Channel.Builder> result = InputDataConfigCopier.copyToBuilder(this.inputDataConfig);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputDataConfig(Collection<Channel.BuilderImpl> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copyFromBuilder(inputDataConfig);
        }

        @Override
        public final Builder inputDataConfig(Collection<Channel> inputDataConfig) {
            this.inputDataConfig = InputDataConfigCopier.copy(inputDataConfig);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Channel ... inputDataConfig) {
            this.inputDataConfig(Arrays.asList(inputDataConfig));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputDataConfig(Consumer<Channel.Builder> ... inputDataConfig) {
            this.inputDataConfig(Stream.of(inputDataConfig).map(c -> (Channel)((Channel.Builder)Channel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final OutputDataConfig.Builder getOutputDataConfig() {
            return this.outputDataConfig != null ? this.outputDataConfig.toBuilder() : null;
        }

        public final void setOutputDataConfig(OutputDataConfig.BuilderImpl outputDataConfig) {
            this.outputDataConfig = outputDataConfig != null ? outputDataConfig.build() : null;
        }

        @Override
        public final Builder outputDataConfig(OutputDataConfig outputDataConfig) {
            this.outputDataConfig = outputDataConfig;
            return this;
        }

        public final ResourceConfig.Builder getResourceConfig() {
            return this.resourceConfig != null ? this.resourceConfig.toBuilder() : null;
        }

        public final void setResourceConfig(ResourceConfig.BuilderImpl resourceConfig) {
            this.resourceConfig = resourceConfig != null ? resourceConfig.build() : null;
        }

        @Override
        public final Builder resourceConfig(ResourceConfig resourceConfig) {
            this.resourceConfig = resourceConfig;
            return this;
        }

        public final StoppingCondition.Builder getStoppingCondition() {
            return this.stoppingCondition != null ? this.stoppingCondition.toBuilder() : null;
        }

        public final void setStoppingCondition(StoppingCondition.BuilderImpl stoppingCondition) {
            this.stoppingCondition = stoppingCondition != null ? stoppingCondition.build() : null;
        }

        @Override
        public final Builder stoppingCondition(StoppingCondition stoppingCondition) {
            this.stoppingCondition = stoppingCondition;
            return this;
        }

        public final Boolean getEnableNetworkIsolation() {
            return this.enableNetworkIsolation;
        }

        public final void setEnableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
        }

        @Override
        public final Builder enableNetworkIsolation(Boolean enableNetworkIsolation) {
            this.enableNetworkIsolation = enableNetworkIsolation;
            return this;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return this.enableInterContainerTrafficEncryption;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final Boolean getEnableManagedSpotTraining() {
            return this.enableManagedSpotTraining;
        }

        public final void setEnableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
        }

        @Override
        public final Builder enableManagedSpotTraining(Boolean enableManagedSpotTraining) {
            this.enableManagedSpotTraining = enableManagedSpotTraining;
            return this;
        }

        public final CheckpointConfig.Builder getCheckpointConfig() {
            return this.checkpointConfig != null ? this.checkpointConfig.toBuilder() : null;
        }

        public final void setCheckpointConfig(CheckpointConfig.BuilderImpl checkpointConfig) {
            this.checkpointConfig = checkpointConfig != null ? checkpointConfig.build() : null;
        }

        @Override
        public final Builder checkpointConfig(CheckpointConfig checkpointConfig) {
            this.checkpointConfig = checkpointConfig;
            return this;
        }

        public final RetryStrategy.Builder getRetryStrategy() {
            return this.retryStrategy != null ? this.retryStrategy.toBuilder() : null;
        }

        public final void setRetryStrategy(RetryStrategy.BuilderImpl retryStrategy) {
            this.retryStrategy = retryStrategy != null ? retryStrategy.build() : null;
        }

        @Override
        public final Builder retryStrategy(RetryStrategy retryStrategy) {
            this.retryStrategy = retryStrategy;
            return this;
        }

        public HyperParameterTrainingJobDefinition build() {
            return new HyperParameterTrainingJobDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterTrainingJobDefinition> {
        public Builder definitionName(String var1);

        public Builder tuningObjective(HyperParameterTuningJobObjective var1);

        default public Builder tuningObjective(Consumer<HyperParameterTuningJobObjective.Builder> tuningObjective) {
            return this.tuningObjective((HyperParameterTuningJobObjective)((HyperParameterTuningJobObjective.Builder)HyperParameterTuningJobObjective.builder().applyMutation(tuningObjective)).build());
        }

        public Builder hyperParameterRanges(ParameterRanges var1);

        default public Builder hyperParameterRanges(Consumer<ParameterRanges.Builder> hyperParameterRanges) {
            return this.hyperParameterRanges((ParameterRanges)((ParameterRanges.Builder)ParameterRanges.builder().applyMutation(hyperParameterRanges)).build());
        }

        public Builder staticHyperParameters(Map<String, String> var1);

        public Builder algorithmSpecification(HyperParameterAlgorithmSpecification var1);

        default public Builder algorithmSpecification(Consumer<HyperParameterAlgorithmSpecification.Builder> algorithmSpecification) {
            return this.algorithmSpecification((HyperParameterAlgorithmSpecification)((HyperParameterAlgorithmSpecification.Builder)HyperParameterAlgorithmSpecification.builder().applyMutation(algorithmSpecification)).build());
        }

        public Builder roleArn(String var1);

        public Builder inputDataConfig(Collection<Channel> var1);

        public Builder inputDataConfig(Channel ... var1);

        public Builder inputDataConfig(Consumer<Channel.Builder> ... var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder outputDataConfig(OutputDataConfig var1);

        default public Builder outputDataConfig(Consumer<OutputDataConfig.Builder> outputDataConfig) {
            return this.outputDataConfig((OutputDataConfig)((OutputDataConfig.Builder)OutputDataConfig.builder().applyMutation(outputDataConfig)).build());
        }

        public Builder resourceConfig(ResourceConfig var1);

        default public Builder resourceConfig(Consumer<ResourceConfig.Builder> resourceConfig) {
            return this.resourceConfig((ResourceConfig)((ResourceConfig.Builder)ResourceConfig.builder().applyMutation(resourceConfig)).build());
        }

        public Builder stoppingCondition(StoppingCondition var1);

        default public Builder stoppingCondition(Consumer<StoppingCondition.Builder> stoppingCondition) {
            return this.stoppingCondition((StoppingCondition)((StoppingCondition.Builder)StoppingCondition.builder().applyMutation(stoppingCondition)).build());
        }

        public Builder enableNetworkIsolation(Boolean var1);

        public Builder enableInterContainerTrafficEncryption(Boolean var1);

        public Builder enableManagedSpotTraining(Boolean var1);

        public Builder checkpointConfig(CheckpointConfig var1);

        default public Builder checkpointConfig(Consumer<CheckpointConfig.Builder> checkpointConfig) {
            return this.checkpointConfig((CheckpointConfig)((CheckpointConfig.Builder)CheckpointConfig.builder().applyMutation(checkpointConfig)).build());
        }

        public Builder retryStrategy(RetryStrategy var1);

        default public Builder retryStrategy(Consumer<RetryStrategy.Builder> retryStrategy) {
            return this.retryStrategy((RetryStrategy)((RetryStrategy.Builder)RetryStrategy.builder().applyMutation(retryStrategy)).build());
        }
    }
}

