/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.LineageGroupSummariesCopier;
import software.amazon.awssdk.services.sagemaker.model.LineageGroupSummary;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLineageGroupsResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, ListLineageGroupsResponse> {
    private static final SdkField<List<LineageGroupSummary>> LINEAGE_GROUP_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LineageGroupSummaries").getter(ListLineageGroupsResponse.getter(ListLineageGroupsResponse::lineageGroupSummaries)).setter(ListLineageGroupsResponse.setter(Builder::lineageGroupSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LineageGroupSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineageGroupSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListLineageGroupsResponse.getter(ListLineageGroupsResponse::nextToken)).setter(ListLineageGroupsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LINEAGE_GROUP_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private final List<LineageGroupSummary> lineageGroupSummaries;
    private final String nextToken;

    private ListLineageGroupsResponse(BuilderImpl builder) {
        super(builder);
        this.lineageGroupSummaries = builder.lineageGroupSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasLineageGroupSummaries() {
        return this.lineageGroupSummaries != null && !(this.lineageGroupSummaries instanceof SdkAutoConstructList);
    }

    public final List<LineageGroupSummary> lineageGroupSummaries() {
        return this.lineageGroupSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLineageGroupSummaries() ? this.lineageGroupSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLineageGroupsResponse)) {
            return false;
        }
        ListLineageGroupsResponse other = (ListLineageGroupsResponse)((Object)obj);
        return this.hasLineageGroupSummaries() == other.hasLineageGroupSummaries() && Objects.equals(this.lineageGroupSummaries(), other.lineageGroupSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListLineageGroupsResponse").add("LineageGroupSummaries", this.hasLineageGroupSummaries() ? this.lineageGroupSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LineageGroupSummaries": {
                return Optional.ofNullable(clazz.cast(this.lineageGroupSummaries()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListLineageGroupsResponse, T> g) {
        return obj -> g.apply((ListLineageGroupsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private List<LineageGroupSummary> lineageGroupSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListLineageGroupsResponse model) {
            super(model);
            this.lineageGroupSummaries(model.lineageGroupSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<LineageGroupSummary.Builder> getLineageGroupSummaries() {
            List<LineageGroupSummary.Builder> result = LineageGroupSummariesCopier.copyToBuilder(this.lineageGroupSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setLineageGroupSummaries(Collection<LineageGroupSummary.BuilderImpl> lineageGroupSummaries) {
            this.lineageGroupSummaries = LineageGroupSummariesCopier.copyFromBuilder(lineageGroupSummaries);
        }

        @Override
        public final Builder lineageGroupSummaries(Collection<LineageGroupSummary> lineageGroupSummaries) {
            this.lineageGroupSummaries = LineageGroupSummariesCopier.copy(lineageGroupSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineageGroupSummaries(LineageGroupSummary ... lineageGroupSummaries) {
            this.lineageGroupSummaries(Arrays.asList(lineageGroupSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lineageGroupSummaries(Consumer<LineageGroupSummary.Builder> ... lineageGroupSummaries) {
            this.lineageGroupSummaries(Stream.of(lineageGroupSummaries).map(c -> (LineageGroupSummary)((LineageGroupSummary.Builder)LineageGroupSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListLineageGroupsResponse build() {
            return new ListLineageGroupsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLineageGroupsResponse> {
        public Builder lineageGroupSummaries(Collection<LineageGroupSummary> var1);

        public Builder lineageGroupSummaries(LineageGroupSummary ... var1);

        public Builder lineageGroupSummaries(Consumer<LineageGroupSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

