/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecommendationMetrics
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecommendationMetrics> {
    private static final SdkField<Float> COST_PER_HOUR_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("CostPerHour").getter(RecommendationMetrics.getter(RecommendationMetrics::costPerHour)).setter(RecommendationMetrics.setter(Builder::costPerHour)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostPerHour").build()}).build();
    private static final SdkField<Float> COST_PER_INFERENCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("CostPerInference").getter(RecommendationMetrics.getter(RecommendationMetrics::costPerInference)).setter(RecommendationMetrics.setter(Builder::costPerInference)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CostPerInference").build()}).build();
    private static final SdkField<Integer> MAX_INVOCATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxInvocations").getter(RecommendationMetrics.getter(RecommendationMetrics::maxInvocations)).setter(RecommendationMetrics.setter(Builder::maxInvocations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxInvocations").build()}).build();
    private static final SdkField<Integer> MODEL_LATENCY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("ModelLatency").getter(RecommendationMetrics.getter(RecommendationMetrics::modelLatency)).setter(RecommendationMetrics.setter(Builder::modelLatency)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ModelLatency").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COST_PER_HOUR_FIELD, COST_PER_INFERENCE_FIELD, MAX_INVOCATIONS_FIELD, MODEL_LATENCY_FIELD));
    private static final long serialVersionUID = 1L;
    private final Float costPerHour;
    private final Float costPerInference;
    private final Integer maxInvocations;
    private final Integer modelLatency;

    private RecommendationMetrics(BuilderImpl builder) {
        this.costPerHour = builder.costPerHour;
        this.costPerInference = builder.costPerInference;
        this.maxInvocations = builder.maxInvocations;
        this.modelLatency = builder.modelLatency;
    }

    public final Float costPerHour() {
        return this.costPerHour;
    }

    public final Float costPerInference() {
        return this.costPerInference;
    }

    public final Integer maxInvocations() {
        return this.maxInvocations;
    }

    public final Integer modelLatency() {
        return this.modelLatency;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.costPerHour());
        hashCode = 31 * hashCode + Objects.hashCode(this.costPerInference());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxInvocations());
        hashCode = 31 * hashCode + Objects.hashCode(this.modelLatency());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecommendationMetrics)) {
            return false;
        }
        RecommendationMetrics other = (RecommendationMetrics)obj;
        return Objects.equals(this.costPerHour(), other.costPerHour()) && Objects.equals(this.costPerInference(), other.costPerInference()) && Objects.equals(this.maxInvocations(), other.maxInvocations()) && Objects.equals(this.modelLatency(), other.modelLatency());
    }

    public final String toString() {
        return ToString.builder((String)"RecommendationMetrics").add("CostPerHour", (Object)this.costPerHour()).add("CostPerInference", (Object)this.costPerInference()).add("MaxInvocations", (Object)this.maxInvocations()).add("ModelLatency", (Object)this.modelLatency()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CostPerHour": {
                return Optional.ofNullable(clazz.cast(this.costPerHour()));
            }
            case "CostPerInference": {
                return Optional.ofNullable(clazz.cast(this.costPerInference()));
            }
            case "MaxInvocations": {
                return Optional.ofNullable(clazz.cast(this.maxInvocations()));
            }
            case "ModelLatency": {
                return Optional.ofNullable(clazz.cast(this.modelLatency()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecommendationMetrics, T> g) {
        return obj -> g.apply((RecommendationMetrics)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Float costPerHour;
        private Float costPerInference;
        private Integer maxInvocations;
        private Integer modelLatency;

        private BuilderImpl() {
        }

        private BuilderImpl(RecommendationMetrics model) {
            this.costPerHour(model.costPerHour);
            this.costPerInference(model.costPerInference);
            this.maxInvocations(model.maxInvocations);
            this.modelLatency(model.modelLatency);
        }

        public final Float getCostPerHour() {
            return this.costPerHour;
        }

        public final void setCostPerHour(Float costPerHour) {
            this.costPerHour = costPerHour;
        }

        @Override
        @Transient
        public final Builder costPerHour(Float costPerHour) {
            this.costPerHour = costPerHour;
            return this;
        }

        public final Float getCostPerInference() {
            return this.costPerInference;
        }

        public final void setCostPerInference(Float costPerInference) {
            this.costPerInference = costPerInference;
        }

        @Override
        @Transient
        public final Builder costPerInference(Float costPerInference) {
            this.costPerInference = costPerInference;
            return this;
        }

        public final Integer getMaxInvocations() {
            return this.maxInvocations;
        }

        public final void setMaxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
        }

        @Override
        @Transient
        public final Builder maxInvocations(Integer maxInvocations) {
            this.maxInvocations = maxInvocations;
            return this;
        }

        public final Integer getModelLatency() {
            return this.modelLatency;
        }

        public final void setModelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
        }

        @Override
        @Transient
        public final Builder modelLatency(Integer modelLatency) {
            this.modelLatency = modelLatency;
            return this;
        }

        public RecommendationMetrics build() {
            return new RecommendationMetrics(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecommendationMetrics> {
        public Builder costPerHour(Float var1);

        public Builder costPerInference(Float var1);

        public Builder maxInvocations(Integer var1);

        public Builder modelLatency(Integer var1);
    }
}

