/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.SageMakerRequest;
import software.amazon.awssdk.services.sagemaker.model.SortOrder;
import software.amazon.awssdk.services.sagemaker.model.SortTrialsBy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTrialsRequest
extends SageMakerRequest
implements ToCopyableBuilder<Builder, ListTrialsRequest> {
    private static final SdkField<String> EXPERIMENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ExperimentName").getter(ListTrialsRequest.getter(ListTrialsRequest::experimentName)).setter(ListTrialsRequest.setter(Builder::experimentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperimentName").build()}).build();
    private static final SdkField<String> TRIAL_COMPONENT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrialComponentName").getter(ListTrialsRequest.getter(ListTrialsRequest::trialComponentName)).setter(ListTrialsRequest.setter(Builder::trialComponentName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrialComponentName").build()}).build();
    private static final SdkField<Instant> CREATED_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAfter").getter(ListTrialsRequest.getter(ListTrialsRequest::createdAfter)).setter(ListTrialsRequest.setter(Builder::createdAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAfter").build()}).build();
    private static final SdkField<Instant> CREATED_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedBefore").getter(ListTrialsRequest.getter(ListTrialsRequest::createdBefore)).setter(ListTrialsRequest.setter(Builder::createdBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBefore").build()}).build();
    private static final SdkField<String> SORT_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortBy").getter(ListTrialsRequest.getter(ListTrialsRequest::sortByAsString)).setter(ListTrialsRequest.setter(Builder::sortBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()}).build();
    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SortOrder").getter(ListTrialsRequest.getter(ListTrialsRequest::sortOrderAsString)).setter(ListTrialsRequest.setter(Builder::sortOrder)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListTrialsRequest.getter(ListTrialsRequest::maxResults)).setter(ListTrialsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTrialsRequest.getter(ListTrialsRequest::nextToken)).setter(ListTrialsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPERIMENT_NAME_FIELD, TRIAL_COMPONENT_NAME_FIELD, CREATED_AFTER_FIELD, CREATED_BEFORE_FIELD, SORT_BY_FIELD, SORT_ORDER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private final String experimentName;
    private final String trialComponentName;
    private final Instant createdAfter;
    private final Instant createdBefore;
    private final String sortBy;
    private final String sortOrder;
    private final Integer maxResults;
    private final String nextToken;

    private ListTrialsRequest(BuilderImpl builder) {
        super(builder);
        this.experimentName = builder.experimentName;
        this.trialComponentName = builder.trialComponentName;
        this.createdAfter = builder.createdAfter;
        this.createdBefore = builder.createdBefore;
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String experimentName() {
        return this.experimentName;
    }

    public final String trialComponentName() {
        return this.trialComponentName;
    }

    public final Instant createdAfter() {
        return this.createdAfter;
    }

    public final Instant createdBefore() {
        return this.createdBefore;
    }

    public final SortTrialsBy sortBy() {
        return SortTrialsBy.fromValue(this.sortBy);
    }

    public final String sortByAsString() {
        return this.sortBy;
    }

    public final SortOrder sortOrder() {
        return SortOrder.fromValue(this.sortOrder);
    }

    public final String sortOrderAsString() {
        return this.sortOrder;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.experimentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.trialComponentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortOrderAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTrialsRequest)) {
            return false;
        }
        ListTrialsRequest other = (ListTrialsRequest)((Object)obj);
        return Objects.equals(this.experimentName(), other.experimentName()) && Objects.equals(this.trialComponentName(), other.trialComponentName()) && Objects.equals(this.createdAfter(), other.createdAfter()) && Objects.equals(this.createdBefore(), other.createdBefore()) && Objects.equals(this.sortByAsString(), other.sortByAsString()) && Objects.equals(this.sortOrderAsString(), other.sortOrderAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTrialsRequest").add("ExperimentName", (Object)this.experimentName()).add("TrialComponentName", (Object)this.trialComponentName()).add("CreatedAfter", (Object)this.createdAfter()).add("CreatedBefore", (Object)this.createdBefore()).add("SortBy", (Object)this.sortByAsString()).add("SortOrder", (Object)this.sortOrderAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExperimentName": {
                return Optional.ofNullable(clazz.cast(this.experimentName()));
            }
            case "TrialComponentName": {
                return Optional.ofNullable(clazz.cast(this.trialComponentName()));
            }
            case "CreatedAfter": {
                return Optional.ofNullable(clazz.cast(this.createdAfter()));
            }
            case "CreatedBefore": {
                return Optional.ofNullable(clazz.cast(this.createdBefore()));
            }
            case "SortBy": {
                return Optional.ofNullable(clazz.cast(this.sortByAsString()));
            }
            case "SortOrder": {
                return Optional.ofNullable(clazz.cast(this.sortOrderAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTrialsRequest, T> g) {
        return obj -> g.apply((ListTrialsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerRequest.BuilderImpl
    implements Builder {
        private String experimentName;
        private String trialComponentName;
        private Instant createdAfter;
        private Instant createdBefore;
        private String sortBy;
        private String sortOrder;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTrialsRequest model) {
            super(model);
            this.experimentName(model.experimentName);
            this.trialComponentName(model.trialComponentName);
            this.createdAfter(model.createdAfter);
            this.createdBefore(model.createdBefore);
            this.sortBy(model.sortBy);
            this.sortOrder(model.sortOrder);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getExperimentName() {
            return this.experimentName;
        }

        @Override
        public final Builder experimentName(String experimentName) {
            this.experimentName = experimentName;
            return this;
        }

        public final void setExperimentName(String experimentName) {
            this.experimentName = experimentName;
        }

        public final String getTrialComponentName() {
            return this.trialComponentName;
        }

        @Override
        public final Builder trialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
            return this;
        }

        public final void setTrialComponentName(String trialComponentName) {
            this.trialComponentName = trialComponentName;
        }

        public final Instant getCreatedAfter() {
            return this.createdAfter;
        }

        @Override
        public final Builder createdAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
            return this;
        }

        public final void setCreatedAfter(Instant createdAfter) {
            this.createdAfter = createdAfter;
        }

        public final Instant getCreatedBefore() {
            return this.createdBefore;
        }

        @Override
        public final Builder createdBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
            return this;
        }

        public final void setCreatedBefore(Instant createdBefore) {
            this.createdBefore = createdBefore;
        }

        public final String getSortBy() {
            return this.sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(SortTrialsBy sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        public final String getSortOrder() {
            return this.sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTrialsRequest build() {
            return new ListTrialsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTrialsRequest> {
        public Builder experimentName(String var1);

        public Builder trialComponentName(String var1);

        public Builder createdAfter(Instant var1);

        public Builder createdBefore(Instant var1);

        public Builder sortBy(String var1);

        public Builder sortBy(SortTrialsBy var1);

        public Builder sortOrder(String var1);

        public Builder sortOrder(SortOrder var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

