/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.SourceAlgorithm;
import software.amazon.awssdk.services.sagemaker.model.SourceAlgorithmListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceAlgorithmSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceAlgorithmSpecification> {
    private static final SdkField<List<SourceAlgorithm>> SOURCE_ALGORITHMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SourceAlgorithms").getter(SourceAlgorithmSpecification.getter(SourceAlgorithmSpecification::sourceAlgorithms)).setter(SourceAlgorithmSpecification.setter(Builder::sourceAlgorithms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceAlgorithms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SourceAlgorithm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_ALGORITHMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<SourceAlgorithm> sourceAlgorithms;

    private SourceAlgorithmSpecification(BuilderImpl builder) {
        this.sourceAlgorithms = builder.sourceAlgorithms;
    }

    public final boolean hasSourceAlgorithms() {
        return this.sourceAlgorithms != null && !(this.sourceAlgorithms instanceof SdkAutoConstructList);
    }

    public final List<SourceAlgorithm> sourceAlgorithms() {
        return this.sourceAlgorithms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceAlgorithms() ? this.sourceAlgorithms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceAlgorithmSpecification)) {
            return false;
        }
        SourceAlgorithmSpecification other = (SourceAlgorithmSpecification)obj;
        return this.hasSourceAlgorithms() == other.hasSourceAlgorithms() && Objects.equals(this.sourceAlgorithms(), other.sourceAlgorithms());
    }

    public final String toString() {
        return ToString.builder((String)"SourceAlgorithmSpecification").add("SourceAlgorithms", this.hasSourceAlgorithms() ? this.sourceAlgorithms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceAlgorithms": {
                return Optional.ofNullable(clazz.cast(this.sourceAlgorithms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceAlgorithmSpecification, T> g) {
        return obj -> g.apply((SourceAlgorithmSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<SourceAlgorithm> sourceAlgorithms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceAlgorithmSpecification model) {
            this.sourceAlgorithms(model.sourceAlgorithms);
        }

        public final List<SourceAlgorithm.Builder> getSourceAlgorithms() {
            List<SourceAlgorithm.Builder> result = SourceAlgorithmListCopier.copyToBuilder(this.sourceAlgorithms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder sourceAlgorithms(Collection<SourceAlgorithm> sourceAlgorithms) {
            this.sourceAlgorithms = SourceAlgorithmListCopier.copy(sourceAlgorithms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAlgorithms(SourceAlgorithm ... sourceAlgorithms) {
            this.sourceAlgorithms(Arrays.asList(sourceAlgorithms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceAlgorithms(Consumer<SourceAlgorithm.Builder> ... sourceAlgorithms) {
            this.sourceAlgorithms(Stream.of(sourceAlgorithms).map(c -> (SourceAlgorithm)((SourceAlgorithm.Builder)SourceAlgorithm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSourceAlgorithms(Collection<SourceAlgorithm.BuilderImpl> sourceAlgorithms) {
            this.sourceAlgorithms = SourceAlgorithmListCopier.copyFromBuilder(sourceAlgorithms);
        }

        public SourceAlgorithmSpecification build() {
            return new SourceAlgorithmSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceAlgorithmSpecification> {
        public Builder sourceAlgorithms(Collection<SourceAlgorithm> var1);

        public Builder sourceAlgorithms(SourceAlgorithm ... var1);

        public Builder sourceAlgorithms(Consumer<SourceAlgorithm.Builder> ... var1);
    }
}

