/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum AutoMLS3DataType {
    MANIFEST_FILE("ManifestFile"),
    S3_PREFIX("S3Prefix"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private AutoMLS3DataType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AutoMLS3DataType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(AutoMLS3DataType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AutoMLS3DataType> knownValues() {
        return Stream.of(AutoMLS3DataType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

