/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.sagemaker.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListModelExplainabilityJobDefinitionsResponse extends SageMakerResponse implements
        ToCopyableBuilder<ListModelExplainabilityJobDefinitionsResponse.Builder, ListModelExplainabilityJobDefinitionsResponse> {
    private static final SdkField<List<MonitoringJobDefinitionSummary>> JOB_DEFINITION_SUMMARIES_FIELD = SdkField
            .<List<MonitoringJobDefinitionSummary>> builder(MarshallingType.LIST)
            .memberName("JobDefinitionSummaries")
            .getter(getter(ListModelExplainabilityJobDefinitionsResponse::jobDefinitionSummaries))
            .setter(setter(Builder::jobDefinitionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDefinitionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MonitoringJobDefinitionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MonitoringJobDefinitionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListModelExplainabilityJobDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JOB_DEFINITION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private final List<MonitoringJobDefinitionSummary> jobDefinitionSummaries;

    private final String nextToken;

    private ListModelExplainabilityJobDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.jobDefinitionSummaries = builder.jobDefinitionSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * Returns true if the JobDefinitionSummaries property was specified by the sender (it may be empty), or false if
     * the sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public final boolean hasJobDefinitionSummaries() {
        return jobDefinitionSummaries != null && !(jobDefinitionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A JSON array in which each element is a summary for a explainability bias jobs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasJobDefinitionSummaries()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A JSON array in which each element is a summary for a explainability bias jobs.
     */
    public final List<MonitoringJobDefinitionSummary> jobDefinitionSummaries() {
        return jobDefinitionSummaries;
    }

    /**
     * <p>
     * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it in
     * the subsequent request.
     * </p>
     * 
     * @return If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use
     *         it in the subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobDefinitionSummaries() ? jobDefinitionSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListModelExplainabilityJobDefinitionsResponse)) {
            return false;
        }
        ListModelExplainabilityJobDefinitionsResponse other = (ListModelExplainabilityJobDefinitionsResponse) obj;
        return hasJobDefinitionSummaries() == other.hasJobDefinitionSummaries()
                && Objects.equals(jobDefinitionSummaries(), other.jobDefinitionSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListModelExplainabilityJobDefinitionsResponse")
                .add("JobDefinitionSummaries", hasJobDefinitionSummaries() ? jobDefinitionSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "JobDefinitionSummaries":
            return Optional.ofNullable(clazz.cast(jobDefinitionSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListModelExplainabilityJobDefinitionsResponse, T> g) {
        return obj -> g.apply((ListModelExplainabilityJobDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SageMakerResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListModelExplainabilityJobDefinitionsResponse> {
        /**
         * <p>
         * A JSON array in which each element is a summary for a explainability bias jobs.
         * </p>
         * 
         * @param jobDefinitionSummaries
         *        A JSON array in which each element is a summary for a explainability bias jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionSummaries(Collection<MonitoringJobDefinitionSummary> jobDefinitionSummaries);

        /**
         * <p>
         * A JSON array in which each element is a summary for a explainability bias jobs.
         * </p>
         * 
         * @param jobDefinitionSummaries
         *        A JSON array in which each element is a summary for a explainability bias jobs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDefinitionSummaries(MonitoringJobDefinitionSummary... jobDefinitionSummaries);

        /**
         * <p>
         * A JSON array in which each element is a summary for a explainability bias jobs.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MonitoringJobDefinitionSummary>.Builder}
         * avoiding the need to create one manually via {@link List<MonitoringJobDefinitionSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MonitoringJobDefinitionSummary>.Builder#build()} is called
         * immediately and its result is passed to {@link #jobDefinitionSummaries(List<MonitoringJobDefinitionSummary>)}
         * .
         * 
         * @param jobDefinitionSummaries
         *        a consumer that will call methods on {@link List<MonitoringJobDefinitionSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #jobDefinitionSummaries(List<MonitoringJobDefinitionSummary>)
         */
        Builder jobDefinitionSummaries(Consumer<MonitoringJobDefinitionSummary.Builder>... jobDefinitionSummaries);

        /**
         * <p>
         * If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs, use it
         * in the subsequent request.
         * </p>
         * 
         * @param nextToken
         *        If the response is truncated, Amazon SageMaker returns this token. To retrieve the next set of jobs,
         *        use it in the subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends SageMakerResponse.BuilderImpl implements Builder {
        private List<MonitoringJobDefinitionSummary> jobDefinitionSummaries = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListModelExplainabilityJobDefinitionsResponse model) {
            super(model);
            jobDefinitionSummaries(model.jobDefinitionSummaries);
            nextToken(model.nextToken);
        }

        public final Collection<MonitoringJobDefinitionSummary.Builder> getJobDefinitionSummaries() {
            if (jobDefinitionSummaries instanceof SdkAutoConstructList) {
                return null;
            }
            return jobDefinitionSummaries != null ? jobDefinitionSummaries.stream()
                    .map(MonitoringJobDefinitionSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder jobDefinitionSummaries(Collection<MonitoringJobDefinitionSummary> jobDefinitionSummaries) {
            this.jobDefinitionSummaries = MonitoringJobDefinitionSummaryListCopier.copy(jobDefinitionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitionSummaries(MonitoringJobDefinitionSummary... jobDefinitionSummaries) {
            jobDefinitionSummaries(Arrays.asList(jobDefinitionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobDefinitionSummaries(Consumer<MonitoringJobDefinitionSummary.Builder>... jobDefinitionSummaries) {
            jobDefinitionSummaries(Stream.of(jobDefinitionSummaries)
                    .map(c -> MonitoringJobDefinitionSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setJobDefinitionSummaries(Collection<MonitoringJobDefinitionSummary.BuilderImpl> jobDefinitionSummaries) {
            this.jobDefinitionSummaries = MonitoringJobDefinitionSummaryListCopier.copyFromBuilder(jobDefinitionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListModelExplainabilityJobDefinitionsResponse build() {
            return new ListModelExplainabilityJobDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
