/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.ProvisioningParameter;
import software.amazon.awssdk.services.sagemaker.model.ProvisioningParametersCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceCatalogProvisioningDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceCatalogProvisioningDetails> {
    private static final SdkField<String> PRODUCT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProductId").getter(ServiceCatalogProvisioningDetails.getter(ServiceCatalogProvisioningDetails::productId)).setter(ServiceCatalogProvisioningDetails.setter(Builder::productId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProductId").build()}).build();
    private static final SdkField<String> PROVISIONING_ARTIFACT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ProvisioningArtifactId").getter(ServiceCatalogProvisioningDetails.getter(ServiceCatalogProvisioningDetails::provisioningArtifactId)).setter(ServiceCatalogProvisioningDetails.setter(Builder::provisioningArtifactId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningArtifactId").build()}).build();
    private static final SdkField<String> PATH_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("PathId").getter(ServiceCatalogProvisioningDetails.getter(ServiceCatalogProvisioningDetails::pathId)).setter(ServiceCatalogProvisioningDetails.setter(Builder::pathId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PathId").build()}).build();
    private static final SdkField<List<ProvisioningParameter>> PROVISIONING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ProvisioningParameters").getter(ServiceCatalogProvisioningDetails.getter(ServiceCatalogProvisioningDetails::provisioningParameters)).setter(ServiceCatalogProvisioningDetails.setter(Builder::provisioningParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProvisioningParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRODUCT_ID_FIELD, PROVISIONING_ARTIFACT_ID_FIELD, PATH_ID_FIELD, PROVISIONING_PARAMETERS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String productId;
    private final String provisioningArtifactId;
    private final String pathId;
    private final List<ProvisioningParameter> provisioningParameters;

    private ServiceCatalogProvisioningDetails(BuilderImpl builder) {
        this.productId = builder.productId;
        this.provisioningArtifactId = builder.provisioningArtifactId;
        this.pathId = builder.pathId;
        this.provisioningParameters = builder.provisioningParameters;
    }

    public final String productId() {
        return this.productId;
    }

    public final String provisioningArtifactId() {
        return this.provisioningArtifactId;
    }

    public final String pathId() {
        return this.pathId;
    }

    public final boolean hasProvisioningParameters() {
        return this.provisioningParameters != null && !(this.provisioningParameters instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningParameter> provisioningParameters() {
        return this.provisioningParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.productId());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningArtifactId());
        hashCode = 31 * hashCode + Objects.hashCode(this.pathId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningParameters() ? this.provisioningParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceCatalogProvisioningDetails)) {
            return false;
        }
        ServiceCatalogProvisioningDetails other = (ServiceCatalogProvisioningDetails)obj;
        return Objects.equals(this.productId(), other.productId()) && Objects.equals(this.provisioningArtifactId(), other.provisioningArtifactId()) && Objects.equals(this.pathId(), other.pathId()) && this.hasProvisioningParameters() == other.hasProvisioningParameters() && Objects.equals(this.provisioningParameters(), other.provisioningParameters());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceCatalogProvisioningDetails").add("ProductId", (Object)this.productId()).add("ProvisioningArtifactId", (Object)this.provisioningArtifactId()).add("PathId", (Object)this.pathId()).add("ProvisioningParameters", this.hasProvisioningParameters() ? this.provisioningParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProductId": {
                return Optional.ofNullable(clazz.cast(this.productId()));
            }
            case "ProvisioningArtifactId": {
                return Optional.ofNullable(clazz.cast(this.provisioningArtifactId()));
            }
            case "PathId": {
                return Optional.ofNullable(clazz.cast(this.pathId()));
            }
            case "ProvisioningParameters": {
                return Optional.ofNullable(clazz.cast(this.provisioningParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceCatalogProvisioningDetails, T> g) {
        return obj -> g.apply((ServiceCatalogProvisioningDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String productId;
        private String provisioningArtifactId;
        private String pathId;
        private List<ProvisioningParameter> provisioningParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceCatalogProvisioningDetails model) {
            this.productId(model.productId);
            this.provisioningArtifactId(model.provisioningArtifactId);
            this.pathId(model.pathId);
            this.provisioningParameters(model.provisioningParameters);
        }

        public final String getProductId() {
            return this.productId;
        }

        @Override
        public final Builder productId(String productId) {
            this.productId = productId;
            return this;
        }

        public final void setProductId(String productId) {
            this.productId = productId;
        }

        public final String getProvisioningArtifactId() {
            return this.provisioningArtifactId;
        }

        @Override
        public final Builder provisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
            return this;
        }

        public final void setProvisioningArtifactId(String provisioningArtifactId) {
            this.provisioningArtifactId = provisioningArtifactId;
        }

        public final String getPathId() {
            return this.pathId;
        }

        @Override
        public final Builder pathId(String pathId) {
            this.pathId = pathId;
            return this;
        }

        public final void setPathId(String pathId) {
            this.pathId = pathId;
        }

        public final List<ProvisioningParameter.Builder> getProvisioningParameters() {
            List<ProvisioningParameter.Builder> result = ProvisioningParametersCopier.copyToBuilder(this.provisioningParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder provisioningParameters(Collection<ProvisioningParameter> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copy(provisioningParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(ProvisioningParameter ... provisioningParameters) {
            this.provisioningParameters(Arrays.asList(provisioningParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... provisioningParameters) {
            this.provisioningParameters(Stream.of(provisioningParameters).map(c -> (ProvisioningParameter)((ProvisioningParameter.Builder)ProvisioningParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setProvisioningParameters(Collection<ProvisioningParameter.BuilderImpl> provisioningParameters) {
            this.provisioningParameters = ProvisioningParametersCopier.copyFromBuilder(provisioningParameters);
        }

        public ServiceCatalogProvisioningDetails build() {
            return new ServiceCatalogProvisioningDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceCatalogProvisioningDetails> {
        public Builder productId(String var1);

        public Builder provisioningArtifactId(String var1);

        public Builder pathId(String var1);

        public Builder provisioningParameters(Collection<ProvisioningParameter> var1);

        public Builder provisioningParameters(ProvisioningParameter ... var1);

        public Builder provisioningParameters(Consumer<ProvisioningParameter.Builder> ... var1);
    }
}

