/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Device
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Device> {
    private static final SdkField<String> DEVICE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DeviceName").getter(Device.getter(Device::deviceName)).setter(Device.setter(Builder::deviceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeviceName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Device.getter(Device::description)).setter(Device.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> IOT_THING_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IotThingName").getter(Device.getter(Device::iotThingName)).setter(Device.setter(Builder::iotThingName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IotThingName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEVICE_NAME_FIELD, DESCRIPTION_FIELD, IOT_THING_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String deviceName;
    private final String description;
    private final String iotThingName;

    private Device(BuilderImpl builder) {
        this.deviceName = builder.deviceName;
        this.description = builder.description;
        this.iotThingName = builder.iotThingName;
    }

    public String deviceName() {
        return this.deviceName;
    }

    public String description() {
        return this.description;
    }

    public String iotThingName() {
        return this.iotThingName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.deviceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.iotThingName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Device)) {
            return false;
        }
        Device other = (Device)obj;
        return Objects.equals(this.deviceName(), other.deviceName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.iotThingName(), other.iotThingName());
    }

    public String toString() {
        return ToString.builder((String)"Device").add("DeviceName", (Object)this.deviceName()).add("Description", (Object)this.description()).add("IotThingName", (Object)this.iotThingName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DeviceName": {
                return Optional.ofNullable(clazz.cast(this.deviceName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "IotThingName": {
                return Optional.ofNullable(clazz.cast(this.iotThingName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Device, T> g) {
        return obj -> g.apply((Device)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String deviceName;
        private String description;
        private String iotThingName;

        private BuilderImpl() {
        }

        private BuilderImpl(Device model) {
            this.deviceName(model.deviceName);
            this.description(model.description);
            this.iotThingName(model.iotThingName);
        }

        public final String getDeviceName() {
            return this.deviceName;
        }

        @Override
        public final Builder deviceName(String deviceName) {
            this.deviceName = deviceName;
            return this;
        }

        public final void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getIotThingName() {
            return this.iotThingName;
        }

        @Override
        public final Builder iotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
            return this;
        }

        public final void setIotThingName(String iotThingName) {
            this.iotThingName = iotThingName;
        }

        public Device build() {
            return new Device(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Device> {
        public Builder deviceName(String var1);

        public Builder description(String var1);

        public Builder iotThingName(String var1);
    }
}

