/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AutoMLSecurityConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AutoMLSecurityConfig> {
    private static final SdkField<String> VOLUME_KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VolumeKmsKeyId").getter(AutoMLSecurityConfig.getter(AutoMLSecurityConfig::volumeKmsKeyId)).setter(AutoMLSecurityConfig.setter(Builder::volumeKmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VolumeKmsKeyId").build()}).build();
    private static final SdkField<Boolean> ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("EnableInterContainerTrafficEncryption").getter(AutoMLSecurityConfig.getter(AutoMLSecurityConfig::enableInterContainerTrafficEncryption)).setter(AutoMLSecurityConfig.setter(Builder::enableInterContainerTrafficEncryption)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableInterContainerTrafficEncryption").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VpcConfig").getter(AutoMLSecurityConfig.getter(AutoMLSecurityConfig::vpcConfig)).setter(AutoMLSecurityConfig.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOLUME_KMS_KEY_ID_FIELD, ENABLE_INTER_CONTAINER_TRAFFIC_ENCRYPTION_FIELD, VPC_CONFIG_FIELD));
    private static final long serialVersionUID = 1L;
    private final String volumeKmsKeyId;
    private final Boolean enableInterContainerTrafficEncryption;
    private final VpcConfig vpcConfig;

    private AutoMLSecurityConfig(BuilderImpl builder) {
        this.volumeKmsKeyId = builder.volumeKmsKeyId;
        this.enableInterContainerTrafficEncryption = builder.enableInterContainerTrafficEncryption;
        this.vpcConfig = builder.vpcConfig;
    }

    public String volumeKmsKeyId() {
        return this.volumeKmsKeyId;
    }

    public Boolean enableInterContainerTrafficEncryption() {
        return this.enableInterContainerTrafficEncryption;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeKmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableInterContainerTrafficEncryption());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AutoMLSecurityConfig)) {
            return false;
        }
        AutoMLSecurityConfig other = (AutoMLSecurityConfig)obj;
        return Objects.equals(this.volumeKmsKeyId(), other.volumeKmsKeyId()) && Objects.equals(this.enableInterContainerTrafficEncryption(), other.enableInterContainerTrafficEncryption()) && Objects.equals(this.vpcConfig(), other.vpcConfig());
    }

    public String toString() {
        return ToString.builder((String)"AutoMLSecurityConfig").add("VolumeKmsKeyId", (Object)this.volumeKmsKeyId()).add("EnableInterContainerTrafficEncryption", (Object)this.enableInterContainerTrafficEncryption()).add("VpcConfig", (Object)this.vpcConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VolumeKmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.volumeKmsKeyId()));
            }
            case "EnableInterContainerTrafficEncryption": {
                return Optional.ofNullable(clazz.cast(this.enableInterContainerTrafficEncryption()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AutoMLSecurityConfig, T> g) {
        return obj -> g.apply((AutoMLSecurityConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String volumeKmsKeyId;
        private Boolean enableInterContainerTrafficEncryption;
        private VpcConfig vpcConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AutoMLSecurityConfig model) {
            this.volumeKmsKeyId(model.volumeKmsKeyId);
            this.enableInterContainerTrafficEncryption(model.enableInterContainerTrafficEncryption);
            this.vpcConfig(model.vpcConfig);
        }

        public final String getVolumeKmsKeyId() {
            return this.volumeKmsKeyId;
        }

        @Override
        public final Builder volumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
            return this;
        }

        public final void setVolumeKmsKeyId(String volumeKmsKeyId) {
            this.volumeKmsKeyId = volumeKmsKeyId;
        }

        public final Boolean getEnableInterContainerTrafficEncryption() {
            return this.enableInterContainerTrafficEncryption;
        }

        @Override
        public final Builder enableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
            return this;
        }

        public final void setEnableInterContainerTrafficEncryption(Boolean enableInterContainerTrafficEncryption) {
            this.enableInterContainerTrafficEncryption = enableInterContainerTrafficEncryption;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public AutoMLSecurityConfig build() {
            return new AutoMLSecurityConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AutoMLSecurityConfig> {
        public Builder volumeKmsKeyId(String var1);

        public Builder enableInterContainerTrafficEncryption(Boolean var1);

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }
    }
}

