/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.ArtifactSource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ArtifactSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ArtifactSummary> {
    private static final SdkField<String> ARTIFACT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactArn").getter(ArtifactSummary.getter(ArtifactSummary::artifactArn)).setter(ArtifactSummary.setter(Builder::artifactArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactArn").build()}).build();
    private static final SdkField<String> ARTIFACT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactName").getter(ArtifactSummary.getter(ArtifactSummary::artifactName)).setter(ArtifactSummary.setter(Builder::artifactName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactName").build()}).build();
    private static final SdkField<ArtifactSource> SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Source").getter(ArtifactSummary.getter(ArtifactSummary::source)).setter(ArtifactSummary.setter(Builder::source)).constructor(ArtifactSource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()}).build();
    private static final SdkField<String> ARTIFACT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ArtifactType").getter(ArtifactSummary.getter(ArtifactSummary::artifactType)).setter(ArtifactSummary.setter(Builder::artifactType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArtifactType").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(ArtifactSummary.getter(ArtifactSummary::creationTime)).setter(ArtifactSummary.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(ArtifactSummary.getter(ArtifactSummary::lastModifiedTime)).setter(ArtifactSummary.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_ARN_FIELD, ARTIFACT_NAME_FIELD, SOURCE_FIELD, ARTIFACT_TYPE_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String artifactArn;
    private final String artifactName;
    private final ArtifactSource source;
    private final String artifactType;
    private final Instant creationTime;
    private final Instant lastModifiedTime;

    private ArtifactSummary(BuilderImpl builder) {
        this.artifactArn = builder.artifactArn;
        this.artifactName = builder.artifactName;
        this.source = builder.source;
        this.artifactType = builder.artifactType;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
    }

    public String artifactArn() {
        return this.artifactArn;
    }

    public String artifactName() {
        return this.artifactName;
    }

    public ArtifactSource source() {
        return this.source;
    }

    public String artifactType() {
        return this.artifactType;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactName());
        hashCode = 31 * hashCode + Objects.hashCode(this.source());
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactType());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArtifactSummary)) {
            return false;
        }
        ArtifactSummary other = (ArtifactSummary)obj;
        return Objects.equals(this.artifactArn(), other.artifactArn()) && Objects.equals(this.artifactName(), other.artifactName()) && Objects.equals(this.source(), other.source()) && Objects.equals(this.artifactType(), other.artifactType()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime());
    }

    public String toString() {
        return ToString.builder((String)"ArtifactSummary").add("ArtifactArn", (Object)this.artifactArn()).add("ArtifactName", (Object)this.artifactName()).add("Source", (Object)this.source()).add("ArtifactType", (Object)this.artifactType()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ArtifactArn": {
                return Optional.ofNullable(clazz.cast(this.artifactArn()));
            }
            case "ArtifactName": {
                return Optional.ofNullable(clazz.cast(this.artifactName()));
            }
            case "Source": {
                return Optional.ofNullable(clazz.cast(this.source()));
            }
            case "ArtifactType": {
                return Optional.ofNullable(clazz.cast(this.artifactType()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArtifactSummary, T> g) {
        return obj -> g.apply((ArtifactSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String artifactArn;
        private String artifactName;
        private ArtifactSource source;
        private String artifactType;
        private Instant creationTime;
        private Instant lastModifiedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ArtifactSummary model) {
            this.artifactArn(model.artifactArn);
            this.artifactName(model.artifactName);
            this.source(model.source);
            this.artifactType(model.artifactType);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
        }

        public final String getArtifactArn() {
            return this.artifactArn;
        }

        @Override
        public final Builder artifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
            return this;
        }

        public final void setArtifactArn(String artifactArn) {
            this.artifactArn = artifactArn;
        }

        public final String getArtifactName() {
            return this.artifactName;
        }

        @Override
        public final Builder artifactName(String artifactName) {
            this.artifactName = artifactName;
            return this;
        }

        public final void setArtifactName(String artifactName) {
            this.artifactName = artifactName;
        }

        public final ArtifactSource.Builder getSource() {
            return this.source != null ? this.source.toBuilder() : null;
        }

        @Override
        public final Builder source(ArtifactSource source) {
            this.source = source;
            return this;
        }

        public final void setSource(ArtifactSource.BuilderImpl source) {
            this.source = source != null ? source.build() : null;
        }

        public final String getArtifactType() {
            return this.artifactType;
        }

        @Override
        public final Builder artifactType(String artifactType) {
            this.artifactType = artifactType;
            return this;
        }

        public final void setArtifactType(String artifactType) {
            this.artifactType = artifactType;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public ArtifactSummary build() {
            return new ArtifactSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ArtifactSummary> {
        public Builder artifactArn(String var1);

        public Builder artifactName(String var1);

        public Builder source(ArtifactSource var1);

        default public Builder source(Consumer<ArtifactSource.Builder> source) {
            return this.source((ArtifactSource)((ArtifactSource.Builder)ArtifactSource.builder().applyMutation(source)).build());
        }

        public Builder artifactType(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);
    }
}

