/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.KernelGatewayImageConfig;
import software.amazon.awssdk.services.sagemaker.model.SageMakerResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAppImageConfigResponse
extends SageMakerResponse
implements ToCopyableBuilder<Builder, DescribeAppImageConfigResponse> {
    private static final SdkField<String> APP_IMAGE_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppImageConfigArn").getter(DescribeAppImageConfigResponse.getter(DescribeAppImageConfigResponse::appImageConfigArn)).setter(DescribeAppImageConfigResponse.setter(Builder::appImageConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigArn").build()}).build();
    private static final SdkField<String> APP_IMAGE_CONFIG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AppImageConfigName").getter(DescribeAppImageConfigResponse.getter(DescribeAppImageConfigResponse::appImageConfigName)).setter(DescribeAppImageConfigResponse.setter(Builder::appImageConfigName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppImageConfigName").build()}).build();
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationTime").getter(DescribeAppImageConfigResponse.getter(DescribeAppImageConfigResponse::creationTime)).setter(DescribeAppImageConfigResponse.setter(Builder::creationTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedTime").getter(DescribeAppImageConfigResponse.getter(DescribeAppImageConfigResponse::lastModifiedTime)).setter(DescribeAppImageConfigResponse.setter(Builder::lastModifiedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedTime").build()}).build();
    private static final SdkField<KernelGatewayImageConfig> KERNEL_GATEWAY_IMAGE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("KernelGatewayImageConfig").getter(DescribeAppImageConfigResponse.getter(DescribeAppImageConfigResponse::kernelGatewayImageConfig)).setter(DescribeAppImageConfigResponse.setter(Builder::kernelGatewayImageConfig)).constructor(KernelGatewayImageConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KernelGatewayImageConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_IMAGE_CONFIG_ARN_FIELD, APP_IMAGE_CONFIG_NAME_FIELD, CREATION_TIME_FIELD, LAST_MODIFIED_TIME_FIELD, KERNEL_GATEWAY_IMAGE_CONFIG_FIELD));
    private final String appImageConfigArn;
    private final String appImageConfigName;
    private final Instant creationTime;
    private final Instant lastModifiedTime;
    private final KernelGatewayImageConfig kernelGatewayImageConfig;

    private DescribeAppImageConfigResponse(BuilderImpl builder) {
        super(builder);
        this.appImageConfigArn = builder.appImageConfigArn;
        this.appImageConfigName = builder.appImageConfigName;
        this.creationTime = builder.creationTime;
        this.lastModifiedTime = builder.lastModifiedTime;
        this.kernelGatewayImageConfig = builder.kernelGatewayImageConfig;
    }

    public String appImageConfigArn() {
        return this.appImageConfigArn;
    }

    public String appImageConfigName() {
        return this.appImageConfigName;
    }

    public Instant creationTime() {
        return this.creationTime;
    }

    public Instant lastModifiedTime() {
        return this.lastModifiedTime;
    }

    public KernelGatewayImageConfig kernelGatewayImageConfig() {
        return this.kernelGatewayImageConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.appImageConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.appImageConfigName());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.kernelGatewayImageConfig());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAppImageConfigResponse)) {
            return false;
        }
        DescribeAppImageConfigResponse other = (DescribeAppImageConfigResponse)((Object)obj);
        return Objects.equals(this.appImageConfigArn(), other.appImageConfigArn()) && Objects.equals(this.appImageConfigName(), other.appImageConfigName()) && Objects.equals(this.creationTime(), other.creationTime()) && Objects.equals(this.lastModifiedTime(), other.lastModifiedTime()) && Objects.equals(this.kernelGatewayImageConfig(), other.kernelGatewayImageConfig());
    }

    public String toString() {
        return ToString.builder((String)"DescribeAppImageConfigResponse").add("AppImageConfigArn", (Object)this.appImageConfigArn()).add("AppImageConfigName", (Object)this.appImageConfigName()).add("CreationTime", (Object)this.creationTime()).add("LastModifiedTime", (Object)this.lastModifiedTime()).add("KernelGatewayImageConfig", (Object)this.kernelGatewayImageConfig()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AppImageConfigArn": {
                return Optional.ofNullable(clazz.cast(this.appImageConfigArn()));
            }
            case "AppImageConfigName": {
                return Optional.ofNullable(clazz.cast(this.appImageConfigName()));
            }
            case "CreationTime": {
                return Optional.ofNullable(clazz.cast(this.creationTime()));
            }
            case "LastModifiedTime": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedTime()));
            }
            case "KernelGatewayImageConfig": {
                return Optional.ofNullable(clazz.cast(this.kernelGatewayImageConfig()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAppImageConfigResponse, T> g) {
        return obj -> g.apply((DescribeAppImageConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends SageMakerResponse.BuilderImpl
    implements Builder {
        private String appImageConfigArn;
        private String appImageConfigName;
        private Instant creationTime;
        private Instant lastModifiedTime;
        private KernelGatewayImageConfig kernelGatewayImageConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAppImageConfigResponse model) {
            super(model);
            this.appImageConfigArn(model.appImageConfigArn);
            this.appImageConfigName(model.appImageConfigName);
            this.creationTime(model.creationTime);
            this.lastModifiedTime(model.lastModifiedTime);
            this.kernelGatewayImageConfig(model.kernelGatewayImageConfig);
        }

        public final String getAppImageConfigArn() {
            return this.appImageConfigArn;
        }

        @Override
        public final Builder appImageConfigArn(String appImageConfigArn) {
            this.appImageConfigArn = appImageConfigArn;
            return this;
        }

        public final void setAppImageConfigArn(String appImageConfigArn) {
            this.appImageConfigArn = appImageConfigArn;
        }

        public final String getAppImageConfigName() {
            return this.appImageConfigName;
        }

        @Override
        public final Builder appImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
            return this;
        }

        public final void setAppImageConfigName(String appImageConfigName) {
            this.appImageConfigName = appImageConfigName;
        }

        public final Instant getCreationTime() {
            return this.creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        public final Instant getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public final Builder lastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
            return this;
        }

        public final void setLastModifiedTime(Instant lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public final KernelGatewayImageConfig.Builder getKernelGatewayImageConfig() {
            return this.kernelGatewayImageConfig != null ? this.kernelGatewayImageConfig.toBuilder() : null;
        }

        @Override
        public final Builder kernelGatewayImageConfig(KernelGatewayImageConfig kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig;
            return this;
        }

        public final void setKernelGatewayImageConfig(KernelGatewayImageConfig.BuilderImpl kernelGatewayImageConfig) {
            this.kernelGatewayImageConfig = kernelGatewayImageConfig != null ? kernelGatewayImageConfig.build() : null;
        }

        @Override
        public DescribeAppImageConfigResponse build() {
            return new DescribeAppImageConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SageMakerResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAppImageConfigResponse> {
        public Builder appImageConfigArn(String var1);

        public Builder appImageConfigName(String var1);

        public Builder creationTime(Instant var1);

        public Builder lastModifiedTime(Instant var1);

        public Builder kernelGatewayImageConfig(KernelGatewayImageConfig var1);

        default public Builder kernelGatewayImageConfig(Consumer<KernelGatewayImageConfig.Builder> kernelGatewayImageConfig) {
            return this.kernelGatewayImageConfig((KernelGatewayImageConfig)((KernelGatewayImageConfig.Builder)KernelGatewayImageConfig.builder().applyMutation(kernelGatewayImageConfig)).build());
        }
    }
}

