/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.sagemaker.model.MetricDefinition;
import software.amazon.awssdk.services.sagemaker.model.MetricDefinitionListCopier;
import software.amazon.awssdk.services.sagemaker.model.TrainingInputMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperParameterAlgorithmSpecification
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperParameterAlgorithmSpecification> {
    private static final SdkField<String> TRAINING_IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingImage").getter(HyperParameterAlgorithmSpecification.getter(HyperParameterAlgorithmSpecification::trainingImage)).setter(HyperParameterAlgorithmSpecification.setter(Builder::trainingImage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingImage").build()}).build();
    private static final SdkField<String> TRAINING_INPUT_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrainingInputMode").getter(HyperParameterAlgorithmSpecification.getter(HyperParameterAlgorithmSpecification::trainingInputModeAsString)).setter(HyperParameterAlgorithmSpecification.setter(Builder::trainingInputMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrainingInputMode").build()}).build();
    private static final SdkField<String> ALGORITHM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AlgorithmName").getter(HyperParameterAlgorithmSpecification.getter(HyperParameterAlgorithmSpecification::algorithmName)).setter(HyperParameterAlgorithmSpecification.setter(Builder::algorithmName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmName").build()}).build();
    private static final SdkField<List<MetricDefinition>> METRIC_DEFINITIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("MetricDefinitions").getter(HyperParameterAlgorithmSpecification.getter(HyperParameterAlgorithmSpecification::metricDefinitions)).setter(HyperParameterAlgorithmSpecification.setter(Builder::metricDefinitions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricDefinitions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAINING_IMAGE_FIELD, TRAINING_INPUT_MODE_FIELD, ALGORITHM_NAME_FIELD, METRIC_DEFINITIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String trainingImage;
    private final String trainingInputMode;
    private final String algorithmName;
    private final List<MetricDefinition> metricDefinitions;

    private HyperParameterAlgorithmSpecification(BuilderImpl builder) {
        this.trainingImage = builder.trainingImage;
        this.trainingInputMode = builder.trainingInputMode;
        this.algorithmName = builder.algorithmName;
        this.metricDefinitions = builder.metricDefinitions;
    }

    public String trainingImage() {
        return this.trainingImage;
    }

    public TrainingInputMode trainingInputMode() {
        return TrainingInputMode.fromValue(this.trainingInputMode);
    }

    public String trainingInputModeAsString() {
        return this.trainingInputMode;
    }

    public String algorithmName() {
        return this.algorithmName;
    }

    public boolean hasMetricDefinitions() {
        return this.metricDefinitions != null && !(this.metricDefinitions instanceof SdkAutoConstructList);
    }

    public List<MetricDefinition> metricDefinitions() {
        return this.metricDefinitions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingImage());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingInputModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.algorithmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.metricDefinitions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperParameterAlgorithmSpecification)) {
            return false;
        }
        HyperParameterAlgorithmSpecification other = (HyperParameterAlgorithmSpecification)obj;
        return Objects.equals(this.trainingImage(), other.trainingImage()) && Objects.equals(this.trainingInputModeAsString(), other.trainingInputModeAsString()) && Objects.equals(this.algorithmName(), other.algorithmName()) && Objects.equals(this.metricDefinitions(), other.metricDefinitions());
    }

    public String toString() {
        return ToString.builder((String)"HyperParameterAlgorithmSpecification").add("TrainingImage", (Object)this.trainingImage()).add("TrainingInputMode", (Object)this.trainingInputModeAsString()).add("AlgorithmName", (Object)this.algorithmName()).add("MetricDefinitions", this.metricDefinitions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrainingImage": {
                return Optional.ofNullable(clazz.cast(this.trainingImage()));
            }
            case "TrainingInputMode": {
                return Optional.ofNullable(clazz.cast(this.trainingInputModeAsString()));
            }
            case "AlgorithmName": {
                return Optional.ofNullable(clazz.cast(this.algorithmName()));
            }
            case "MetricDefinitions": {
                return Optional.ofNullable(clazz.cast(this.metricDefinitions()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<HyperParameterAlgorithmSpecification, T> g) {
        return obj -> g.apply((HyperParameterAlgorithmSpecification)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trainingImage;
        private String trainingInputMode;
        private String algorithmName;
        private List<MetricDefinition> metricDefinitions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(HyperParameterAlgorithmSpecification model) {
            this.trainingImage(model.trainingImage);
            this.trainingInputMode(model.trainingInputMode);
            this.algorithmName(model.algorithmName);
            this.metricDefinitions(model.metricDefinitions);
        }

        public final String getTrainingImage() {
            return this.trainingImage;
        }

        @Override
        public final Builder trainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
            return this;
        }

        public final void setTrainingImage(String trainingImage) {
            this.trainingImage = trainingImage;
        }

        public final String getTrainingInputMode() {
            return this.trainingInputMode;
        }

        @Override
        public final Builder trainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
            return this;
        }

        @Override
        public final Builder trainingInputMode(TrainingInputMode trainingInputMode) {
            this.trainingInputMode(trainingInputMode == null ? null : trainingInputMode.toString());
            return this;
        }

        public final void setTrainingInputMode(String trainingInputMode) {
            this.trainingInputMode = trainingInputMode;
        }

        public final String getAlgorithmName() {
            return this.algorithmName;
        }

        @Override
        public final Builder algorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
            return this;
        }

        public final void setAlgorithmName(String algorithmName) {
            this.algorithmName = algorithmName;
        }

        public final Collection<MetricDefinition.Builder> getMetricDefinitions() {
            return this.metricDefinitions != null ? (Collection)this.metricDefinitions.stream().map(MetricDefinition::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder metricDefinitions(Collection<MetricDefinition> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copy(metricDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(MetricDefinition ... metricDefinitions) {
            this.metricDefinitions(Arrays.asList(metricDefinitions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... metricDefinitions) {
            this.metricDefinitions(Stream.of(metricDefinitions).map(c -> (MetricDefinition)((MetricDefinition.Builder)MetricDefinition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMetricDefinitions(Collection<MetricDefinition.BuilderImpl> metricDefinitions) {
            this.metricDefinitions = MetricDefinitionListCopier.copyFromBuilder(metricDefinitions);
        }

        public HyperParameterAlgorithmSpecification build() {
            return new HyperParameterAlgorithmSpecification(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperParameterAlgorithmSpecification> {
        public Builder trainingImage(String var1);

        public Builder trainingInputMode(String var1);

        public Builder trainingInputMode(TrainingInputMode var1);

        public Builder algorithmName(String var1);

        public Builder metricDefinitions(Collection<MetricDefinition> var1);

        public Builder metricDefinitions(MetricDefinition ... var1);

        public Builder metricDefinitions(Consumer<MetricDefinition.Builder> ... var1);
    }
}

