/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.sagemaker.model.MonitoringConstraintsResource;
import software.amazon.awssdk.services.sagemaker.model.MonitoringStatisticsResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MonitoringBaselineConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MonitoringBaselineConfig> {
    private static final SdkField<MonitoringConstraintsResource> CONSTRAINTS_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ConstraintsResource").getter(MonitoringBaselineConfig.getter(MonitoringBaselineConfig::constraintsResource)).setter(MonitoringBaselineConfig.setter(Builder::constraintsResource)).constructor(MonitoringConstraintsResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConstraintsResource").build()}).build();
    private static final SdkField<MonitoringStatisticsResource> STATISTICS_RESOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("StatisticsResource").getter(MonitoringBaselineConfig.getter(MonitoringBaselineConfig::statisticsResource)).setter(MonitoringBaselineConfig.setter(Builder::statisticsResource)).constructor(MonitoringStatisticsResource::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticsResource").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINTS_RESOURCE_FIELD, STATISTICS_RESOURCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final MonitoringConstraintsResource constraintsResource;
    private final MonitoringStatisticsResource statisticsResource;

    private MonitoringBaselineConfig(BuilderImpl builder) {
        this.constraintsResource = builder.constraintsResource;
        this.statisticsResource = builder.statisticsResource;
    }

    public MonitoringConstraintsResource constraintsResource() {
        return this.constraintsResource;
    }

    public MonitoringStatisticsResource statisticsResource() {
        return this.statisticsResource;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constraintsResource());
        hashCode = 31 * hashCode + Objects.hashCode(this.statisticsResource());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MonitoringBaselineConfig)) {
            return false;
        }
        MonitoringBaselineConfig other = (MonitoringBaselineConfig)obj;
        return Objects.equals(this.constraintsResource(), other.constraintsResource()) && Objects.equals(this.statisticsResource(), other.statisticsResource());
    }

    public String toString() {
        return ToString.builder((String)"MonitoringBaselineConfig").add("ConstraintsResource", (Object)this.constraintsResource()).add("StatisticsResource", (Object)this.statisticsResource()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ConstraintsResource": {
                return Optional.ofNullable(clazz.cast(this.constraintsResource()));
            }
            case "StatisticsResource": {
                return Optional.ofNullable(clazz.cast(this.statisticsResource()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MonitoringBaselineConfig, T> g) {
        return obj -> g.apply((MonitoringBaselineConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MonitoringConstraintsResource constraintsResource;
        private MonitoringStatisticsResource statisticsResource;

        private BuilderImpl() {
        }

        private BuilderImpl(MonitoringBaselineConfig model) {
            this.constraintsResource(model.constraintsResource);
            this.statisticsResource(model.statisticsResource);
        }

        public final MonitoringConstraintsResource.Builder getConstraintsResource() {
            return this.constraintsResource != null ? this.constraintsResource.toBuilder() : null;
        }

        @Override
        public final Builder constraintsResource(MonitoringConstraintsResource constraintsResource) {
            this.constraintsResource = constraintsResource;
            return this;
        }

        public final void setConstraintsResource(MonitoringConstraintsResource.BuilderImpl constraintsResource) {
            this.constraintsResource = constraintsResource != null ? constraintsResource.build() : null;
        }

        public final MonitoringStatisticsResource.Builder getStatisticsResource() {
            return this.statisticsResource != null ? this.statisticsResource.toBuilder() : null;
        }

        @Override
        public final Builder statisticsResource(MonitoringStatisticsResource statisticsResource) {
            this.statisticsResource = statisticsResource;
            return this;
        }

        public final void setStatisticsResource(MonitoringStatisticsResource.BuilderImpl statisticsResource) {
            this.statisticsResource = statisticsResource != null ? statisticsResource.build() : null;
        }

        public MonitoringBaselineConfig build() {
            return new MonitoringBaselineConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MonitoringBaselineConfig> {
        public Builder constraintsResource(MonitoringConstraintsResource var1);

        default public Builder constraintsResource(Consumer<MonitoringConstraintsResource.Builder> constraintsResource) {
            return this.constraintsResource((MonitoringConstraintsResource)((MonitoringConstraintsResource.Builder)MonitoringConstraintsResource.builder().applyMutation(constraintsResource)).build());
        }

        public Builder statisticsResource(MonitoringStatisticsResource var1);

        default public Builder statisticsResource(Consumer<MonitoringStatisticsResource.Builder> statisticsResource) {
            return this.statisticsResource((MonitoringStatisticsResource)((MonitoringStatisticsResource.Builder)MonitoringStatisticsResource.builder().applyMutation(statisticsResource)).build());
        }
    }
}

