/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.sagemaker.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TensorBoardOutputConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TensorBoardOutputConfig> {
    private static final SdkField<String> LOCAL_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LocalPath").getter(TensorBoardOutputConfig.getter(TensorBoardOutputConfig::localPath)).setter(TensorBoardOutputConfig.setter(Builder::localPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LocalPath").build()}).build();
    private static final SdkField<String> S3_OUTPUT_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("S3OutputPath").getter(TensorBoardOutputConfig.getter(TensorBoardOutputConfig::s3OutputPath)).setter(TensorBoardOutputConfig.setter(Builder::s3OutputPath)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("S3OutputPath").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOCAL_PATH_FIELD, S3_OUTPUT_PATH_FIELD));
    private static final long serialVersionUID = 1L;
    private final String localPath;
    private final String s3OutputPath;

    private TensorBoardOutputConfig(BuilderImpl builder) {
        this.localPath = builder.localPath;
        this.s3OutputPath = builder.s3OutputPath;
    }

    public String localPath() {
        return this.localPath;
    }

    public String s3OutputPath() {
        return this.s3OutputPath;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.localPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputPath());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TensorBoardOutputConfig)) {
            return false;
        }
        TensorBoardOutputConfig other = (TensorBoardOutputConfig)obj;
        return Objects.equals(this.localPath(), other.localPath()) && Objects.equals(this.s3OutputPath(), other.s3OutputPath());
    }

    public String toString() {
        return ToString.builder((String)"TensorBoardOutputConfig").add("LocalPath", (Object)this.localPath()).add("S3OutputPath", (Object)this.s3OutputPath()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LocalPath": {
                return Optional.ofNullable(clazz.cast(this.localPath()));
            }
            case "S3OutputPath": {
                return Optional.ofNullable(clazz.cast(this.s3OutputPath()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TensorBoardOutputConfig, T> g) {
        return obj -> g.apply((TensorBoardOutputConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String localPath;
        private String s3OutputPath;

        private BuilderImpl() {
        }

        private BuilderImpl(TensorBoardOutputConfig model) {
            this.localPath(model.localPath);
            this.s3OutputPath(model.s3OutputPath);
        }

        public final String getLocalPath() {
            return this.localPath;
        }

        @Override
        public final Builder localPath(String localPath) {
            this.localPath = localPath;
            return this;
        }

        public final void setLocalPath(String localPath) {
            this.localPath = localPath;
        }

        public final String getS3OutputPath() {
            return this.s3OutputPath;
        }

        @Override
        public final Builder s3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
            return this;
        }

        public final void setS3OutputPath(String s3OutputPath) {
            this.s3OutputPath = s3OutputPath;
        }

        public TensorBoardOutputConfig build() {
            return new TensorBoardOutputConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TensorBoardOutputConfig> {
        public Builder localPath(String var1);

        public Builder s3OutputPath(String var1);
    }
}

